/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectLongHashMap;
import java.util.ConcurrentModificationException;

public class TObjectLongIterator
extends TIterator {
    private final TObjectLongHashMap _map;

    public TObjectLongIterator(TObjectLongHashMap tObjectLongHashMap) {
        super(tObjectLongHashMap);
        this._map = tObjectLongHashMap;
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] objectArray = this._map._set;
        int n = this._index;
        while (n-- > 0 && (objectArray[n] == null || objectArray[n] == TObjectHash.REMOVED)) {
        }
        return n;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public Object key() {
        return this._map._set[this._index];
    }

    public long value() {
        return this._map._values[this._index];
    }

    public long setValue(long l) {
        long l2 = this.value();
        this._map._values[this._index] = l;
        return l2;
    }
}

