/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.vmware.api;

import com.tripwire.vmware.api.ManagedObject;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.ScheduledTaskSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimServiceLocator;
import java.net.URL;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;

public class ServiceInstance {
    private final VimPortType m_service;
    private final ServiceContent m_content;
    private ManagedObjectReference m_scheduleManager;
    private final ManagedObjectReference m_reference;
    private String m_url;

    public ManagedObjectReference getPropCol() {
        return this.m_content.getPropertyCollector();
    }

    public ServiceInstance(String url) throws Exception {
        this.m_url = url;
        System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
        VimServiceLocator locator = new VimServiceLocator();
        locator.setMaintainSession(true);
        this.m_service = locator.getVimPort(new URL(url));
        this.m_reference = new ManagedObjectReference();
        this.m_reference.setType("ServiceInstance");
        this.m_reference.set_value("ServiceInstance");
        this.m_content = this.getService().retrieveServiceContent(this.m_reference);
        this.setScheduleManager(this.m_content.getScheduledTaskManager());
    }

    public ManagedObject getManagedObject() {
        return new ManagedObject(this, this.m_reference);
    }

    public ServiceContent getServiceContent() {
        return this.m_content;
    }

    public void login(String username, String password) throws Exception {
        this.getService().login(this.m_content.getSessionManager(), username, password, null);
    }

    public void logout() throws Exception {
        this.getService().logout(this.m_content.getSessionManager());
    }

    public ManagedObjectReference createScheduledTask(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference1, ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        return this.getService().createScheduledTask(managedObjectReference, managedObjectReference1, scheduledTaskSpec);
    }

    public ManagedObjectReference generateLogBundles_Task(ManagedObjectReference diagnosticManager, boolean includeDefault, ManagedObjectReference[] host) throws Exception {
        return this.getService().generateLogBundles_Task(diagnosticManager, includeDefault, host);
    }

    public String backupFirmwareConfiguration(ManagedObjectReference hostFirmwareSystem) throws Exception {
        return this.getService().backupFirmwareConfiguration(hostFirmwareSystem);
    }

    public ObjectContent[] retrieveProperties(PropertyFilterSpec[] propertyFilterSpecs) throws Exception {
        return this.getService().retrieveProperties(this.m_content.getPropertyCollector(), propertyFilterSpecs);
    }

    public ManagedObjectReference getRootFolder() {
        return this.m_content.getRootFolder();
    }

    public ManagedObjectReference getScheduleManager() {
        return this.m_scheduleManager;
    }

    public void setScheduleManager(ManagedObjectReference scheduleManager) {
        this.m_scheduleManager = scheduleManager;
    }

    public String getCookie() throws Exception {
        Stub st = (Stub)((Object)this.getService());
        Call callObj = st._getCall();
        MessageContext msgContext = callObj.getMessageContext();
        String cookieString = (String)msgContext.getProperty("Cookie");
        return cookieString;
    }

    public VimPortType getService() {
        return this.m_service;
    }
}

