/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.ConditionTrace;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.ConditionalVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConditionalList
implements Conditional {
    private static final long serialVersionUID = 1L;
    protected List m_conditions = new ArrayList();
    private transient int m_hashCode = -1;

    protected ConditionalList() {
    }

    public void add(Conditional condition) {
        this.m_conditions.add(condition);
    }

    public List<Conditional> getConditions() {
        return this.m_conditions;
    }

    public int size() {
        return this.m_conditions.size();
    }

    public void clear() {
        this.m_conditions.clear();
    }

    public boolean isEmpty() {
        return this.m_conditions.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionalList that = (ConditionalList)obj;
        return ((Object)this.m_conditions).equals(that.m_conditions);
    }

    public int hashCode() {
        if (this.m_hashCode == -1) {
            this.m_hashCode = ((Object)this.m_conditions).hashCode();
        }
        return this.m_hashCode;
    }

    @Override
    public boolean accept(ConditionalVisitor visitor) throws SpaceException {
        if (!visitor.visit(this)) {
            return false;
        }
        for (Conditional cond : this.m_conditions) {
            if (cond.accept(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        Iterator it = this.m_conditions.iterator();
        while (it.hasNext()) {
            ((Conditional)it.next()).reset();
        }
    }

    public abstract boolean isAndList();

    public static ConditionalList createAndList() {
        return new AndConditions();
    }

    public static ConditionalList createOrList() {
        return new OrConditions();
    }

    public static class OrConditions
    extends ConditionalList {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate(Object source) throws Exception {
            try {
                ConditionTrace.begin("OR");
                for (Conditional cond : this.m_conditions) {
                    if (!cond.evaluate(source)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                ConditionTrace.end();
            }
        }

        public boolean isAndList() {
            return false;
        }
    }

    public static class AndConditions
    extends ConditionalList {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate(Object source) throws Exception {
            try {
                ConditionTrace.begin("AND");
                for (Conditional cond : this.m_conditions) {
                    if (cond.evaluate(source)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                ConditionTrace.end();
            }
        }

        public boolean isAndList() {
            return true;
        }
    }
}

