/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class PropertyStream {
    private PrintStream m_stream;
    protected static final int TABSIZE = 3;
    protected static Map sm_map = new HashMap();

    public PropertyStream(PrintStream stream) {
        this.m_stream = stream;
        Entry entry = (Entry)sm_map.get(stream);
        if (entry == null) {
            sm_map.put(stream, new Entry());
        }
    }

    public PropertyStream() {
        this(System.out);
    }

    public void begin(Object dump) {
        this.begin(dump.getClass().getName());
    }

    public void begin(String sName) {
        this.indent();
        this.m_stream.print('(');
        this.m_stream.print(sName);
        this.m_stream.println();
        this.m_stream.flush();
        this.incrementIndent();
    }

    public void property(String sName, Object value) {
        this.property(sName, PropertyStream.safeToString(value));
    }

    public void property(String sName, double value) {
        this.property(sName, String.valueOf(value));
    }

    public void property(String sName, long value) {
        this.property(sName, String.valueOf(value));
    }

    public void property(String sName, String value) {
        this.indent();
        this.m_stream.print('(');
        this.m_stream.print(sName);
        this.m_stream.print(", ");
        this.m_stream.print(value);
        this.m_stream.print(')');
        this.m_stream.println();
        this.m_stream.flush();
    }

    public void end() {
        this.decrementIndent();
        this.indent();
        this.m_stream.print(')');
        this.m_stream.println();
        this.m_stream.flush();
    }

    protected Entry getEntry() {
        Entry entry = (Entry)sm_map.get(this.m_stream);
        if (entry == null) {
            throw new IllegalStateException();
        }
        return entry;
    }

    protected void indent() {
        Entry entry = this.getEntry();
        int spaces = entry.m_nTabLevel * 3;
        while (--spaces >= 0) {
            this.m_stream.print(' ');
        }
    }

    protected void incrementIndent() {
        Entry entry = this.getEntry();
        ++entry.m_nTabLevel;
    }

    protected void decrementIndent() {
        Entry entry = this.getEntry();
        --entry.m_nTabLevel;
    }

    protected static String safeToString(Object o) {
        return o == null ? "null" : o.toString();
    }

    static class Entry {
        int m_nTabLevel = 0;
    }
}

