/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.ModeBase;
import com.mindbright.terminal.tandem6530.Screen6530;
import com.mindbright.terminal.tandem6530.Screen6530Buffer;
import com.mindbright.terminal.tandem6530.Terminal6530Callback;

public class BlockMode
extends ModeBase {
    protected static final int ROWS = 24;
    protected static final int COLS = 80;
    protected Terminal6530Callback termCallback;
    protected Screen6530[] pages;
    protected int displayPage;
    protected int selectedPage;
    protected boolean insertMode = false;
    protected int MAX_PAGES;
    protected DisplayView display;

    public BlockMode(Terminal6530Callback terminal6530Callback, int n) {
        this.termCallback = terminal6530Callback;
        this.MAX_PAGES = n;
        this.pages = new Screen6530[this.MAX_PAGES];
        for (int i = 0; i < this.MAX_PAGES; ++i) {
            this.pages[i] = new Screen6530(24, 80, ' ', true);
        }
        this.displayPage = 0;
        this.selectedPage = 0;
    }

    public void keyHandler(char c, int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 8: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doBS();
                if (this.insertMode) {
                    this.pages[this.displayPage].deleteChars(1);
                }
                bl = true;
                break;
            }
            case 9: {
                if ((n2 & 1) == 1) {
                    this.pages[this.displayPage].doBackTabs(1);
                    bl = true;
                    break;
                }
                this.pages[this.displayPage].doHTab();
                bl = true;
                break;
            }
            case 10: {
                if ((n2 & 1) == 1) {
                    this.pages[this.displayPage].cursorDown(1);
                    this.pages[this.displayPage].doCR();
                    bl = true;
                    break;
                }
                if ((n2 & 2) == 2) {
                    this.pages[this.displayPage].cursorToLastCharOnRow();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.pages[this.displayPage].doCR();
                bl = true;
                break;
            }
            case 36: {
                if ((n2 & 2) == 2) {
                    this.pages[this.displayPage].cursorHomeDown();
                    this.pages[this.displayPage].cursorToLastCharOnRow();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.pages[this.displayPage].cursorHome();
                bl = true;
                break;
            }
            case 35: {
                if (n2 != 0) break;
                this.pages[this.displayPage].cursorHomeDown();
                bl = true;
                break;
            }
            case 155: {
                if ((n2 & 8) == 8) {
                    this.insertMode = true;
                    this.pages[this.displayPage].setInsertMode(true);
                    bl = true;
                    break;
                }
                if ((n2 & 2) == 2) {
                    this.pages[this.displayPage].insertLines(1);
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                if (this.insertMode) {
                    this.insertMode = false;
                    this.pages[this.displayPage].setInsertMode(false);
                } else {
                    this.pages[this.displayPage].insertChars(1);
                }
                bl = true;
                break;
            }
            case 127: {
                if (n2 == 0) {
                    this.pages[this.displayPage].deleteChars(1);
                    bl = true;
                    break;
                }
                if ((n2 & 2) != 2) break;
                this.pages[this.displayPage].deleteLines(1);
                bl = true;
                break;
            }
            case 39: {
                if (n2 != 0) break;
                this.pages[this.displayPage].cursorForward(1);
                bl = true;
                break;
            }
            case 37: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doBS();
                bl = true;
                break;
            }
            case 38: {
                if (n2 != 0) break;
                this.pages[this.displayPage].cursorUp(1);
                bl = true;
                break;
            }
            case 40: {
                if (n2 != 0) break;
                this.pages[this.displayPage].cursorDown(1);
                bl = true;
                break;
            }
            case 49: {
                if ((n2 & 9) == 9) {
                    this.pages[this.displayPage].clearTab(true);
                    bl = true;
                    break;
                }
                if ((n2 & 8) != 8) break;
                this.pages[this.displayPage].setTab(true);
                bl = true;
                break;
            }
            case 50: {
                if ((n2 & 9) == 9) {
                    this.pages[this.displayPage].clearBelow();
                    bl = true;
                    break;
                }
                if ((n2 & 8) != 8) break;
                this.pages[this.displayPage].clearRight();
                bl = true;
                break;
            }
            case 51: {
                if ((n2 & 8) != 8) break;
                this.pages[this.displayPage].clearAllTabs();
                bl = true;
                break;
            }
        }
        if (bl) {
            this.repaint();
            return;
        }
        if (c == '\uffff') {
            return;
        }
        this.pages[this.displayPage].cursorWrite(c);
        this.repaint();
    }

    public void hostChar(char c) {
        this.pages[this.selectedPage].bufferWrite(c);
        this.repaint();
    }

    protected void updateDirty() {
        if (this.display != null) {
            this.display.updateDirtyArea(0, 0, 23, 79);
        }
    }

    protected void repaint() {
        if (this.display != null) {
            this.display.repaint();
        }
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
        this.pages[this.displayPage].setDisplay(displayView);
        if (displayView != null) {
            displayView.setVisTop(0);
            displayView.updateScrollbarValues();
            this.repaint();
        }
    }

    public void switchReset() {
        for (int i = 0; i < this.MAX_PAGES; ++i) {
            this.pages[i].reset();
        }
        this.insertMode = false;
        this.doSelectPage(1);
        this.doDisplayPage(1);
        this.repaint();
    }

    public void doBackspace() {
        this.pages[this.selectedPage].doBS();
        this.repaint();
    }

    public void doHTab() {
        this.pages[this.selectedPage].doHTab();
        this.repaint();
    }

    public void doLineFeed() {
        this.pages[this.selectedPage].doLF();
        this.repaint();
    }

    public void doCarriageReturn() {
        this.pages[this.selectedPage].doCR();
        this.repaint();
    }

    public void doSetTab() {
        this.pages[this.selectedPage].setTab(false);
    }

    public void doClearTab() {
        this.pages[this.selectedPage].clearTab(false);
    }

    public void doClearAllTabs() {
        this.pages[this.selectedPage].clearAllTabs();
    }

    public void doSetVideoAttribute(int n) {
        this.pages[this.selectedPage].setAttribute(n);
        this.repaint();
    }

    public void doSetDefaultVideoAttribute(int n) {
        this.pages[this.selectedPage].setDefaultAttribute(n);
        this.repaint();
    }

    public void doSetBufferAddress(int n, int n2) {
        this.pages[this.selectedPage].bufferSetPos(n - 1, n2 - 1);
    }

    public void doSetCursorAddress(int n, int n2) {
        this.doSetCursorAddress(false, n, n2);
    }

    public void doSetCursorAddress(boolean bl, int n, int n2) {
        if (n > 24 || n2 > 80) {
            return;
        }
        int n3 = bl ? this.displayPage : this.selectedPage;
        this.pages[n3].cursorSetPos(n - 1, n2 - 1);
        this.repaint();
    }

    public void doStartField(FieldAttributes fieldAttributes) {
        this.doSetVideoAttribute(fieldAttributes.getVideoAttrib() & 0x1F);
    }

    public void doBackTab() {
        this.pages[this.selectedPage].doBackTabs(1);
        this.repaint();
    }

    public void doSetMaxPageNumber(int n) {
    }

    public void doCursorUp() {
        this.pages[this.selectedPage].cursorUp(1);
        this.repaint();
    }

    public void doCursorRight() {
        this.pages[this.selectedPage].cursorForward(1);
        this.repaint();
    }

    public void doCursorHomeDown() {
        this.pages[this.selectedPage].cursorHomeDown();
        this.repaint();
    }

    public void doCursorHome() {
        this.pages[this.selectedPage].cursorSetPos(0, 0);
        this.repaint();
    }

    public void doClearMemoryToSpaces(int n, int n2, int n3, int n4) {
        this.pages[this.selectedPage].clear(n2 - 1, n2 - 1, n3 - 1, n4 - 1);
        this.repaint();
    }

    public void doEraseToEndOfPageOrMemory() {
        this.pages[this.selectedPage].clearBelow(false);
        this.repaint();
    }

    public void doEraseToEndOfLineOrField() {
        this.pages[this.selectedPage].clearRight(false);
        this.repaint();
    }

    public String doReadWithAddress(int n, int n2, int n3, int n4) {
        return this.pages[this.selectedPage].read(n - 1, n2 - 1, n3 - 1, n4 - 1);
    }

    public String doReadWithAddressAll(int n, int n2, int n3, int n4) {
        return this.pages[this.selectedPage].read(n - 1, n2 - 1, n3 - 1, n4 - 1);
    }

    public void doInsertLine() {
        this.pages[this.selectedPage].insertLines(1, false);
        this.repaint();
    }

    public void doDeleteLine() {
        this.pages[this.selectedPage].deleteLines(1, false);
        this.repaint();
    }

    public void doInsertCharacter() {
        this.pages[this.selectedPage].insertChars(1, false);
        this.repaint();
    }

    public void doDeleteCharacter() {
        this.pages[this.selectedPage].deleteChars(1, false);
        this.repaint();
    }

    public String doReadWholePageOrBuffer() {
        return this.pages[this.selectedPage].readWhole();
    }

    public void doDisplayPage(int n) {
        if (n >= 1 && n <= this.MAX_PAGES) {
            this.pages[this.displayPage].setDisplay(null);
            this.displayPage = n - 1;
            this.pages[this.displayPage].setDisplay(this.display);
            this.updateDirty();
            this.repaint();
        }
    }

    public void doSelectPage(int n) {
        if (n >= 1 && n <= this.MAX_PAGES) {
            this.selectedPage = n - 1;
        }
    }

    public int getRow() {
        return this.pages[this.selectedPage].getCursorRow() + 1;
    }

    public int getCol() {
        return this.pages[this.selectedPage].getCursorCol() + 1;
    }

    public int getPage() {
        return this.selectedPage + 1;
    }

    public char[] getChars(int n, int n2) {
        return this.pages[this.displayPage].getCharsAt(n, n2);
    }

    public int[] getAttribs(int n, int n2) {
        return this.pages[this.displayPage].getAttribsAt(n, n2);
    }

    public void doClickSelect(int n, int n2, String string) {
        this.pages[this.displayPage].doClickSelect(n, n2, string);
    }

    public void resetClickSelect() {
        this.pages[this.displayPage].resetClickSelect();
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        this.pages[this.displayPage].setSelection(n, n2, n3, n4);
    }

    public void selectAll() {
        this.pages[this.displayPage].selectAll();
    }

    public void resetSelection() {
        this.pages[this.displayPage].resetSelection();
    }

    public String getSelection(String string) {
        return this.pages[this.displayPage].getSelection(string);
    }

    public SearchContext search(SearchContext searchContext, String string, boolean bl, boolean bl2) {
        SearchContext searchContext2 = this.pages[this.displayPage].search(searchContext, string, bl, bl2);
        if (searchContext2 != null) {
            if (this.display != null) {
                this.display.setVisTop(searchContext2.getStartRow());
            }
            this.pages[this.displayPage].setVisTop(searchContext2.getStartRow());
            this.pages[this.displayPage].setSelection(searchContext2.getStartRow(), searchContext2.getStartCol(), searchContext2.getEndRow(), searchContext2.getEndCol());
            if (this.display != null) {
                this.display.repaint(true);
            }
        }
        return searchContext2;
    }

    public void setBuffer(Screen6530Buffer screen6530Buffer) {
        this.pages[0].setBuffer(screen6530Buffer);
    }
}

