/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TLongHashSetDecorator
extends AbstractSet
implements Set,
Cloneable {
    protected TLongHashSet _set;

    public TLongHashSetDecorator(TLongHashSet tLongHashSet) {
        this._set = tLongHashSet;
    }

    public Object clone() {
        try {
            TLongHashSetDecorator tLongHashSetDecorator = (TLongHashSetDecorator)super.clone();
            tLongHashSetDecorator._set = (TLongHashSet)this._set.clone();
            return tLongHashSetDecorator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean add(Object object) {
        return this._set.add(this.unwrap(object));
    }

    public boolean equals(Object object) {
        if (this._set.equals(object)) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (set.size() != this._set.size()) {
                return false;
            }
            Iterator iterator = set.iterator();
            int n = set.size();
            while (n-- > 0) {
                Object e = iterator.next();
                if (e instanceof Long) {
                    long l = this.unwrap(e);
                    if (this._set.contains(l)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object object) {
        return this._set.remove(this.unwrap(object));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TLongIterator it;
            {
                this.it = TLongHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TLongHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Long wrap(long l) {
        return new Long(l);
    }

    protected long unwrap(Object object) {
        return (Long)object;
    }
}

