/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.operator;

import com.tripwire.space.core.conditional.operator.AbstractNumericalOperator;
import com.tripwire.space.core.conditional.operator.BinaryOperator;
import java.util.Date;

public class BetweenOperator
extends BinaryOperator {
    private boolean m_caseSensitive;

    BetweenOperator() {
        this(true);
    }

    BetweenOperator(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public int getId() {
        return this.m_caseSensitive ? 5 : 11;
    }

    public boolean evaluate(Object operand, Object range) {
        if (operand == null || range == null) {
            return false;
        }
        Object min = ((Object[])range)[0];
        Object max = ((Object[])range)[1];
        if (min instanceof Number || min instanceof Date) {
            return this.evaluate(AbstractNumericalOperator.toLong(operand), AbstractNumericalOperator.toLong(min), AbstractNumericalOperator.toLong(max));
        }
        if (min instanceof String) {
            return this.evaluate((String)operand, (String)min, (String)max);
        }
        throw new UnsupportedOperationException("Right hand side was passed an array of " + min.getClass().getName() + ", but this operator can only operate on Numbers, Dates or Strings.");
    }

    public boolean evaluate(long operand, long[] range) {
        return this.evaluate(operand, range[0], range[1]);
    }

    private boolean evaluate(long operand, long min, long max) {
        return min <= operand && operand <= max;
    }

    public boolean evaluate(String operand, String min, String max) {
        if (this.m_caseSensitive) {
            return operand.compareTo(min) >= 0 && operand.compareTo(max) <= 0;
        }
        return operand.compareToIgnoreCase(min) >= 0 && operand.compareToIgnoreCase(max) <= 0;
    }
}

