/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.ValidationException;
import com.tripwire.space.core.conditional.ActualCollectable;
import com.tripwire.space.core.conditional.CachedOperandExtractor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XmlExtractor
extends CachedOperandExtractor
implements ActualCollectable {
    private static final long serialVersionUID = 1L;
    protected static final XPathFactory XFACTORY = XPathFactory.newInstance();
    private transient String m_xpath;
    private transient QName m_rtype;
    private transient XPathExpression m_xpathExpr;

    public XmlExtractor(String xpath) throws ValidationException {
        this.setXPath(xpath);
        this.m_rtype = XPathConstants.STRING;
    }

    public String getXPath() {
        return this.m_xpath;
    }

    public final void setXPath(String xpath) throws ValidationException {
        if (xpath == null) {
            throw new ValidationException("XmlExtractor.xpath.required");
        }
        try {
            this.m_xpathExpr = XFACTORY.newXPath().compile(xpath);
            this.m_xpath = xpath;
            this.reset();
        }
        catch (XPathExpressionException e) {
            throw new ValidationException(e, "XmlExtractor.xpath.invalid", new Object[]{xpath});
        }
    }

    public QName getReturnType() {
        return this.m_rtype;
    }

    public void setReturnType(QName returnType) {
        this.m_rtype = returnType == null ? XPathConstants.STRING : returnType;
        this.reset();
    }

    protected Object extractValue(Object source) throws SpaceException {
        try {
            return this.m_xpathExpr.evaluate(source, this.m_rtype);
        }
        catch (XPathExpressionException e) {
            throw SpaceException.asSpaceException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XmlExtractor that = (XmlExtractor)obj;
        return this.m_xpath.equals(that.m_xpath) && this.m_rtype.equals(that.m_rtype);
    }

    public int hashCode() {
        return this.m_xpath.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_xpath);
        out.writeObject(this.m_rtype);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, ValidationException {
        this.setXPath((String)in.readObject());
        this.m_rtype = (QName)in.readObject();
    }

    public void collectExtractedValue(Map map) throws SpaceException {
        this.mapActual(map, this.getXPath(), this.getExtractedForDisplay());
    }

    public Object getCollectableKey() {
        return this.getXPath();
    }
}

