/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2PKISigner;
import com.mindbright.ssh2.SSH2SignatureException;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.ssh2.SSH2UserCancelException;

public class SSH2AuthPublicKey
implements SSH2AuthModule {
    private SSH2PKISigner signer;
    private boolean test;
    public static final String STANDARD_NAME = "publickey";

    public SSH2AuthPublicKey(SSH2PKISigner sSH2PKISigner) {
        this(sSH2PKISigner, true);
    }

    public SSH2AuthPublicKey(SSH2PKISigner sSH2PKISigner, boolean bl) {
        this.signer = sSH2PKISigner;
        this.test = bl;
    }

    protected SSH2PKISigner getSigner() {
        return this.signer;
    }

    public String getStandardName() {
        return STANDARD_NAME;
    }

    public SSH2TransportPDU processMethodMessage(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        switch (sSH2TransportPDU.getType()) {
            case 60: {
                try {
                    sSH2TransportPDU = this.createRequest(sSH2UserAuth, false);
                    break;
                }
                catch (SSH2SignatureException sSH2SignatureException) {
                    sSH2TransportPDU = null;
                    sSH2UserAuth.getTransport().getLog().warning("SSH2AuthPublicKey", "createRequest: " + sSH2SignatureException.getMessage());
                    throw new SSH2UserCancelException(sSH2SignatureException.getMessage());
                }
            }
            default: {
                sSH2UserAuth.getTransport().getLog().warning("SSH2AuthPublicKey", "received unexpected packet of type: " + sSH2TransportPDU.getType());
                sSH2TransportPDU = null;
                throw new SSH2FatalException("SSH2AuthPublicKey: got unexpected packet of type: " + sSH2TransportPDU.getType());
            }
        }
        return sSH2TransportPDU;
    }

    public SSH2TransportPDU startAuthentication(SSH2UserAuth sSH2UserAuth) throws SSH2SignatureException {
        return this.createRequest(sSH2UserAuth, this.test);
    }

    private SSH2TransportPDU createRequest(SSH2UserAuth sSH2UserAuth, boolean bl) throws SSH2SignatureException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        SSH2PKISigner sSH2PKISigner = this.getSigner();
        byte[] byArray = sSH2PKISigner.getPublicKeyBlob();
        sSH2TransportPDU.writeBoolean(!bl);
        sSH2TransportPDU.writeString(sSH2PKISigner.getAlgorithmName());
        sSH2TransportPDU.writeString(byArray);
        if (!bl) {
            this.signPDU(sSH2UserAuth, sSH2TransportPDU, sSH2PKISigner, byArray);
        }
        return sSH2TransportPDU;
    }

    private void signPDU(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU, SSH2PKISigner sSH2PKISigner, byte[] byArray) throws SSH2SignatureException {
        SSH2TransportPDU sSH2TransportPDU2 = sSH2TransportPDU;
        if (sSH2UserAuth.getTransport().incompatiblePublicKeyAuth) {
            sSH2TransportPDU2 = SSH2TransportPDU.createOutgoingPacket(50);
            sSH2TransportPDU2.writeString(sSH2UserAuth.user);
            sSH2TransportPDU2.writeString("ssh-userauth");
            sSH2TransportPDU2.writeString(STANDARD_NAME);
            sSH2TransportPDU2.writeBoolean(true);
            sSH2TransportPDU2.writeString(sSH2PKISigner.getAlgorithmName());
            sSH2TransportPDU2.writeString(byArray);
        }
        byte[] byArray2 = sSH2UserAuth.getTransport().getSessionId();
        int n = sSH2TransportPDU2.wPos - sSH2TransportPDU2.getPayloadOffset();
        byte[] byArray3 = new byte[n + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(sSH2TransportPDU2.data, sSH2TransportPDU2.getPayloadOffset(), byArray3, byArray2.length, n);
        sSH2PKISigner.setIncompatibility(sSH2UserAuth.getTransport());
        byte[] byArray4 = sSH2PKISigner.sign(byArray3);
        sSH2TransportPDU.writeString(byArray4);
    }

    public void clearSensitiveData() {
        this.signer.clearSensitiveData();
    }

    public boolean retryPointless() {
        return true;
    }
}

