/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIterator;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TFloatHashSet
extends TFloatHash
implements Serializable {
    public TFloatHashSet() {
    }

    public TFloatHashSet(int n) {
        super(n);
    }

    public TFloatHashSet(int n, float f) {
        super(n, f);
    }

    public TFloatHashSet(float[] fArray) {
        this(fArray.length);
        this.addAll(fArray);
    }

    public TFloatHashSet(TFloatHashingStrategy tFloatHashingStrategy) {
        super(tFloatHashingStrategy);
    }

    public TFloatHashSet(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, tFloatHashingStrategy);
    }

    public TFloatHashSet(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f, tFloatHashingStrategy);
    }

    public TFloatHashSet(float[] fArray, TFloatHashingStrategy tFloatHashingStrategy) {
        this(fArray.length, tFloatHashingStrategy);
        this.addAll(fArray);
    }

    public TFloatIterator iterator() {
        return new TFloatIterator(this);
    }

    public boolean add(float f) {
        int n = this.insertionIndex(f);
        if (n < 0) {
            return false;
        }
        byte by = this._states[n];
        this._set[n] = f;
        this._states[n] = 1;
        this.postInsertHook(by == 0);
        return true;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        float[] fArray = this._set;
        byte[] byArray = this._states;
        this._set = new float[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.insertionIndex(f);
            this._set[n4] = f;
            this._states[n4] = 1;
        }
    }

    public float[] toArray() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public void clear() {
        super.clear();
        float[] fArray = this._set;
        byte[] byArray = this._states;
        int n = fArray.length;
        while (n-- > 0) {
            fArray[n] = 0.0f;
            byArray[n] = 0;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TFloatHashSet)) {
            return false;
        }
        final TFloatHashSet tFloatHashSet = (TFloatHashSet)object;
        if (tFloatHashSet.size() != this.size()) {
            return false;
        }
        return this.forEach(new TFloatProcedure(){

            public final boolean execute(float f) {
                return tFloatHashSet.contains(f);
            }
        });
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEach(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public boolean remove(float f) {
        int n = this.index(f);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    public boolean containsAll(float[] fArray) {
        int n = fArray.length;
        while (n-- > 0) {
            if (this.contains(fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(float[] fArray) {
        boolean bl = false;
        int n = fArray.length;
        while (n-- > 0) {
            if (!this.add(fArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(float[] fArray) {
        boolean bl = false;
        int n = fArray.length;
        while (n-- > 0) {
            if (!this.remove(fArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(float[] fArray) {
        boolean bl = false;
        Arrays.sort(fArray);
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = fArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(fArray, fArray2[n]) >= 0) continue;
            this.remove(fArray2[n]);
            bl = true;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEach(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            float f = objectInputStream.readFloat();
            this.add(f);
        }
    }

    private final class HashProcedure
    implements TFloatProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float f) {
            this.h += TFloatHashSet.this._hashingStrategy.computeHashCode(f);
            return true;
        }
    }
}

