/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.vmware.api;

import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;

public class Traversal {
    private final TraversalSpec m_traversal = new TraversalSpec();

    public Traversal(String name, String type, String path) {
        this.m_traversal.setName(name);
        this.m_traversal.setType(type);
        this.m_traversal.setPath(path);
    }

    public void examine() {
        this.m_traversal.setSkip(Boolean.FALSE);
    }

    public void makeRecursive() {
        this.addChildTraversalReference(this);
    }

    public void addChildTraversalReference(Traversal other) {
        this.addChildSelectionSpec(new SelectionSpec(null, null, other.m_traversal.getName()));
    }

    public void addChildTraversal(Traversal other) {
        this.addChildSelectionSpec(other.m_traversal);
    }

    public SelectionSpec getSpec() {
        return this.m_traversal;
    }

    private void addChildSelectionSpec(SelectionSpec other) {
        SelectionSpec[] selectSet = this.m_traversal.getSelectSet();
        if (selectSet == null) {
            selectSet = new SelectionSpec[]{};
        }
        int count = selectSet.length;
        SelectionSpec[] newSelectSet = new SelectionSpec[count + 1];
        System.arraycopy(selectSet, 0, newSelectSet, 0, count);
        newSelectSet[count] = other;
        this.m_traversal.setSelectSet(newSelectSet);
    }
}

