/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.common.util.Dbg;
import com.tripwire.common.util.Objects;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.ActualCollectable;
import com.tripwire.space.core.conditional.CachedOperandExtractor;
import java.util.Map;
import java.util.regex.Matcher;

public class TextExtractor
extends CachedOperandExtractor
implements ActualCollectable {
    private static final long serialVersionUID = 1L;
    private int m_group;
    private String m_label;

    public TextExtractor() {
        this(0);
    }

    public TextExtractor(int group) {
        this.m_group = group;
    }

    public TextExtractor(int group, String label) {
        this.m_group = group;
        this.m_label = label;
    }

    public int getGroup() {
        return this.m_group;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getLabel() {
        return this.m_label;
    }

    protected Object extractValue(Object source) {
        Matcher matcher = (Matcher)source;
        try {
            return matcher.group(this.m_group);
        }
        catch (IllegalStateException e) {
            Dbg.trace(e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextExtractor that = (TextExtractor)obj;
        return this.m_group == that.m_group && Objects.equals(this.getLabel(), that.getLabel());
    }

    public int hashCode() {
        return this.m_label == null ? this.m_group : this.m_group + this.m_label.hashCode();
    }

    public void collectExtractedValue(Map map) throws SpaceException {
        this.mapActual(map, this.getCollectableKey(), this.getExtractedForDisplay());
    }

    public Object getCollectableKey() {
        if (this.m_label != null) {
            return this.m_label;
        }
        return ResourceManager.getInstance().getString("TextExtractor.groupingPrefix") + ' ' + String.valueOf(this.m_group);
    }
}

