/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.system;

import com.tripwire.common.util.system.LinuxOperatingSystem;
import java.io.File;

public class RedhatLinuxOperatingSystem
extends LinuxOperatingSystem {
    protected String m_redHatVersion = null;

    public boolean matchesOperatingSystem(String osName) {
        return super.matchesOperatingSystem(osName) && this.isRedhatLinux();
    }

    protected boolean isRedhatLinux() {
        return new File("/etc/redhat-release").exists();
    }

    protected String getRedhatVersion() {
        int startVersion;
        String line;
        if (this.m_redHatVersion == null && (line = this.getFirstLine(new File("/etc/redhat-release"))) != null && (startVersion = line.indexOf("release")) >= 0) {
            int endVersion;
            startVersion += 7;
            while (Character.isWhitespace(line.charAt(startVersion))) {
                ++startVersion;
            }
            for (endVersion = startVersion; !Character.isWhitespace(line.charAt(endVersion)) && endVersion < line.length(); ++endVersion) {
            }
            this.m_redHatVersion = line.substring(startVersion, endVersion);
        }
        return this.m_redHatVersion;
    }
}

