/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostDhcpService;
import com.vmware.vim25.HostDnsConfig;
import com.vmware.vim25.HostIpRouteConfig;
import com.vmware.vim25.HostNatService;
import com.vmware.vim25.HostNetworkInfo;
import com.vmware.vim25.HostPortGroup;
import com.vmware.vim25.HostVirtualNic;
import com.vmware.vim25.HostVirtualSwitch;
import com.vmware.vim25.PhysicalNic;

public class HostNetworkInfoCollector
extends AbstractVmwareCollector {
    public HostNetworkInfoCollector() {
        super(HostNetworkInfo.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostNetworkInfo";
        if (o instanceof HostNetworkInfo) {
            HostVirtualSwitch[] vswitches;
            HostVirtualNic[] vnics;
            HostPortGroup[] portGroups;
            PhysicalNic[] pnics;
            HostDhcpService[] dhcps;
            HostNetworkInfo hostNetworkInfo = (HostNetworkInfo)o;
            HostIpRouteConfig consoleIpRouteConfig = hostNetworkInfo.getConsoleIpRouteConfig();
            this.doCollect(consoleIpRouteConfig, curKey);
            HostVirtualNic[] consoleVnics = hostNetworkInfo.getConsoleVnic();
            if (null != consoleVnics) {
                for (int ii = 0; ii < consoleVnics.length; ++ii) {
                    if (null == consoleVnics[ii]) continue;
                    this.doCollect(consoleVnics[ii], curKey + ".ConsoleVnics" + ii);
                }
            }
            if (null != (dhcps = hostNetworkInfo.getDhcp())) {
                for (int ii = 0; ii < dhcps.length; ++ii) {
                    if (null == dhcps[ii]) continue;
                    this.doCollect(dhcps[ii], curKey + ".Dhcps" + ii);
                }
            }
            HostDnsConfig dnsConfig = hostNetworkInfo.getDnsConfig();
            this.doCollect(dnsConfig, curKey);
            HostIpRouteConfig ipRouteConfig = hostNetworkInfo.getIpRouteConfig();
            this.doCollect(ipRouteConfig, curKey);
            HostNatService[] nats = hostNetworkInfo.getNat();
            if (null != nats) {
                for (int ii = 0; ii < nats.length; ++ii) {
                    if (null == nats[ii]) continue;
                    this.doCollect(nats[ii], curKey + ".Nats" + ii);
                }
            }
            if (null != (pnics = hostNetworkInfo.getPnic())) {
                for (int ii = 0; ii < pnics.length; ++ii) {
                    if (null == pnics[ii]) continue;
                    this.doCollect(pnics[ii], curKey + ".Pnics" + ii);
                }
            }
            if (null != (portGroups = hostNetworkInfo.getPortgroup())) {
                for (int ii = 0; ii < portGroups.length; ++ii) {
                    if (null == portGroups[ii]) continue;
                    this.doCollect(portGroups[ii], curKey + ".PortGroups" + ii);
                }
            }
            if (null != (vnics = hostNetworkInfo.getVnic())) {
                for (int ii = 0; ii < vnics.length; ++ii) {
                    if (null == vnics[ii]) continue;
                    this.doCollect(vnics[ii], curKey + ".Vnics" + ii);
                }
            }
            if (null != (vswitches = hostNetworkInfo.getVswitch())) {
                for (int ii = 0; ii < vswitches.length; ++ii) {
                    if (null == vswitches[ii]) continue;
                    this.doCollect(vswitches[ii], curKey + ".Vswitches" + ii);
                }
            }
        }
    }
}

