/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostBIOSInfo;
import com.vmware.vim25.HostCpuIdInfo;
import com.vmware.vim25.HostCpuInfo;
import com.vmware.vim25.HostCpuPackage;
import com.vmware.vim25.HostHardwareInfo;
import com.vmware.vim25.HostNumaInfo;
import com.vmware.vim25.HostPciDevice;
import com.vmware.vim25.HostSystemInfo;

public class HostHardwareInfoCollector
extends AbstractVmwareCollector {
    public HostHardwareInfoCollector() {
        super(HostHardwareInfo.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostHardwareInfo";
        if (o instanceof HostHardwareInfo) {
            HostHardwareInfo hostHardwareInfo = (HostHardwareInfo)o;
            HostBIOSInfo biosInfo = hostHardwareInfo.getBiosInfo();
            this.doCollect(biosInfo, curKey);
            HostCpuIdInfo[] cpuFeatures = hostHardwareInfo.getCpuFeature();
            if (null != cpuFeatures) {
                for (int ii = 0; ii < cpuFeatures.length; ++ii) {
                    if (null == cpuFeatures[ii]) continue;
                    this.doCollect(cpuFeatures[ii], curKey + ".CpuFeature" + ii);
                }
            }
            HostCpuInfo cpuInfo = hostHardwareInfo.getCpuInfo();
            this.doCollect(cpuInfo, curKey);
            HostCpuPackage[] cpuPkgs = hostHardwareInfo.getCpuPkg();
            if (null != cpuPkgs) {
                for (int ii = 0; ii < cpuPkgs.length; ++ii) {
                    if (null == cpuPkgs[ii]) continue;
                    this.doCollect(cpuPkgs[ii], curKey + ".CpuPkg" + ii);
                }
            }
            long memorySize = hostHardwareInfo.getMemorySize();
            this.doPut(curKey + ".MemorySize", "" + memorySize);
            HostNumaInfo numaInfo = hostHardwareInfo.getNumaInfo();
            this.doCollect(numaInfo, curKey);
            HostPciDevice[] pciDevices = hostHardwareInfo.getPciDevice();
            if (null != pciDevices) {
                for (int ii = 0; ii < pciDevices.length; ++ii) {
                    if (null == pciDevices[ii]) continue;
                    this.doCollect(pciDevices[ii], curKey + ".PciDevice" + ii);
                }
            }
            HostSystemInfo systemInfo = hostHardwareInfo.getSystemInfo();
            this.doCollect(systemInfo, curKey);
        }
    }
}

