/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.gui;

import com.mindbright.util.Progress;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas
implements Progress {
    long max = 0L;
    long current = 0L;
    Color barColor;
    FontMetrics fm;
    Image img;
    Graphics memG;

    public synchronized void setBarColor(Color color) {
        this.barColor = color;
    }

    public void progress(long l) {
        this.setValue(l);
    }

    public synchronized void setValue(long l) {
        this.setValue(l, false);
    }

    public synchronized void setValue(long l, boolean bl) {
        long l2 = this.current = l > this.max ? this.max : l;
        if (bl) {
            this.update(this.getGraphics());
        } else {
            this.repaint();
        }
    }

    public synchronized void setMax(long l, boolean bl) {
        this.max = l;
        if (bl) {
            this.current = 0L;
        }
        this.setValue(this.current, true);
    }

    public ProgressBar(long l, int n, int n2) {
        this.max = l;
        this.setSize(new Dimension(n, n2));
        this.barColor = Color.black;
    }

    public boolean isFinished() {
        return this.current == this.max;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = (int)(this.max > 0L ? 100L * this.current / this.max : 100L);
        int n4 = (int)((double)n3 / 100.0 * (double)(n - 2));
        String string = n3 + "%";
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        if (this.img == null) {
            this.setBackground(Color.white);
            this.img = this.createImage(n, n2);
            this.memG = this.img.getGraphics();
        }
        this.memG.setPaintMode();
        this.memG.setColor(Color.white);
        this.memG.fillRect(0, 0, n, n2);
        this.memG.setColor(Color.black);
        this.memG.drawRect(0, 0, n - 1, n2 - 1);
        this.memG.drawString(string, n / 2 - this.fm.stringWidth(string) / 2 + 1, n2 / 2 + this.fm.getMaxAscent() + this.fm.getLeading() - this.fm.getHeight() / 2);
        this.memG.setColor(this.barColor);
        this.memG.setXORMode(Color.white);
        this.memG.fillRect(1, 1, n4, n2 - 2);
        graphics.drawImage(this.img, 0, 0, this);
    }
}

