/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1Any;
import com.mindbright.asn1.ASN1ConstructedString;
import com.mindbright.asn1.ASN1Decoder;
import com.mindbright.asn1.ASN1Encoder;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.asn1.ASN1String;
import com.mindbright.asn1.ASN1Structure;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1DER
implements ASN1Encoder,
ASN1Decoder {
    protected static final byte[] BOOL_TRUE = new byte[]{-1};
    protected static final byte[] BOOL_FALSE = new byte[]{0};
    protected static final int INDEFINITE_LEN = -1;

    public int encode(OutputStream outputStream, ASN1Object aSN1Object) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = aSN1Object.getTag();
        int n3 = n = aSN1Object.encodeValue(this, byteArrayOutputStream);
        outputStream.write((byte)n2);
        ++n3;
        byteArrayOutputStream.writeTo(outputStream);
        return n3 += this.encodeLength(outputStream, n);
    }

    public int encodeLength(OutputStream outputStream, int n) throws IOException {
        int n2 = 0;
        if (n < 128) {
            outputStream.write((byte)n);
            ++n2;
        } else {
            byte[] byArray = new byte[5];
            int n3 = 4;
            do {
                byArray[n3--] = (byte)(n & 0xFF);
            } while ((n >>>= 8) > 0);
            int n4 = 5 - n3;
            byArray[n3] = (byte)(0x80 | n4 - 1);
            outputStream.write(byArray, n3, n4);
            n2 += n4;
        }
        return n2;
    }

    public int encodeBoolean(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(bl ? BOOL_TRUE : BOOL_FALSE);
        return 1;
    }

    public int encodeInteger(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        outputStream.write(byArray);
        return byArray.length;
    }

    public int encodeNull(OutputStream outputStream) throws IOException {
        return 0;
    }

    public int encodeOID(OutputStream outputStream, int[] nArray) throws IOException {
        int n = 1;
        outputStream.write(40 * nArray[0] + nArray[1]);
        for (int i = 2; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < 128) {
                outputStream.write((byte)n2);
                ++n;
                continue;
            }
            byte[] byArray = new byte[4];
            int n3 = 4;
            do {
                byArray[--n3] = (byte)(n2 & 0x7F);
                n2 >>>= 7;
                if (n3 >= 3) continue;
                byArray[n3] = (byte)(byArray[n3] & 0xFF | 0x80);
            } while (n2 > 0);
            while (n3 < 4) {
                outputStream.write(byArray[n3++]);
                ++n;
            }
        }
        return n;
    }

    public int encodeString(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(byArray);
        return byArray.length;
    }

    public int encodeStructure(OutputStream outputStream, ASN1Structure aSN1Structure) throws IOException {
        int n = aSN1Structure.getCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ASN1Object aSN1Object = aSN1Structure.getComponent(i);
            if (aSN1Structure.isOptional(i)) {
                ASN1Object aSN1Object2 = aSN1Structure.getDefault(i);
                if (!aSN1Object.isSet() || aSN1Object.equals(aSN1Object2)) continue;
            }
            n2 += this.encode(outputStream, aSN1Object);
        }
        return n2;
    }

    public int decode(InputStream inputStream, ASN1Object aSN1Object) throws IOException {
        int n = this.decodeTag(inputStream);
        int[] nArray = this.decodeLength(inputStream);
        this.decodeValue(inputStream, n, nArray[0], aSN1Object);
        return 1 + nArray[1] + nArray[0];
    }

    public int decodeTag(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if ((n & 0x1F) == 31) {
            throw new IOException("Long form of tags not supported yet");
        }
        return n;
    }

    public int[] decodeLength(InputStream inputStream) throws IOException {
        int n = 1;
        int n2 = inputStream.read();
        if (n2 > 128) {
            int n3 = n2 & 0x7F;
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                n2 <<= 8;
                n2 += inputStream.read();
                ++n;
            }
        } else if (n2 == 128) {
            n2 = -1;
        }
        return new int[]{n2, n};
    }

    public void decodeValue(InputStream inputStream, int n, int n2, ASN1Object aSN1Object) throws IOException {
        if ((n & 0x20) != 0 && aSN1Object instanceof ASN1String) {
            ASN1ConstructedString aSN1ConstructedString = new ASN1ConstructedString(n, aSN1Object.getClass());
            aSN1ConstructedString.decodeValue(this, inputStream, n, n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < aSN1ConstructedString.getCount(); ++i) {
                ASN1Object aSN1Object2 = aSN1ConstructedString.getComponent(i);
                aSN1Object2.encodeValue(this, byteArrayOutputStream);
            }
            ((ASN1String)aSN1Object).setRaw(byteArrayOutputStream.toByteArray());
        } else {
            aSN1Object.decodeValue(this, inputStream, n, n2);
        }
    }

    public boolean decodeBoolean(InputStream inputStream, int n) throws IOException {
        byte by = (byte)inputStream.read();
        if (n != 1 || by != BOOL_FALSE[0] && by != BOOL_TRUE[0]) {
            throw new IOException("Invalid DER encoding of boolean");
        }
        return by == BOOL_TRUE[0];
    }

    public BigInteger decodeInteger(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readNextN(inputStream, byArray, n);
        return new BigInteger(byArray);
    }

    public void decodeNull(InputStream inputStream, int n) throws IOException {
        if (n != 0) {
            throw new IOException("Invalid DER encoding of NULL");
        }
    }

    public int[] decodeOID(InputStream inputStream, int n) throws IOException {
        int[] nArray = new int[n + 1];
        if (n < 1) {
            throw new IOException("Invalid DER encoding of OID");
        }
        nArray[0] = inputStream.read();
        --n;
        if (nArray[0] > 119) {
            nArray[1] = nArray[0] - 80;
            nArray[0] = 2;
        } else {
            nArray[1] = nArray[0] % 40;
            nArray[0] = nArray[0] / 40;
        }
        int n2 = 2;
        while (n > 0) {
            int n3 = 0;
            int n4 = inputStream.read();
            --n;
            while (n4 > 128) {
                n3 <<= 7;
                n3 |= (n4 &= 0x7F);
                n4 = inputStream.read();
                --n;
            }
            n3 <<= 7;
            nArray[n2++] = n3 |= n4;
        }
        int[] nArray2 = nArray;
        nArray = new int[n2];
        System.arraycopy(nArray2, 0, nArray, 0, n2);
        return nArray;
    }

    public byte[] decodeString(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readNextN(inputStream, byArray, n);
        return byArray;
    }

    private void decodeStructureIndef(InputStream inputStream, ASN1Structure aSN1Structure) throws IOException {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            int n2 = this.decodeTag(inputStream);
            int[] nArray = this.decodeLength(inputStream);
            if (n2 == 0 && nArray[0] == 0) {
                bl = true;
                continue;
            }
            ASN1Object aSN1Object = null;
            while ((aSN1Object = aSN1Structure.getDecodeComponent(n++, n2)) == null) {
            }
            this.decodeValue(inputStream, n2, nArray[0], aSN1Object);
        }
    }

    public void decodeStructure(InputStream inputStream, int n, ASN1Structure aSN1Structure) throws IOException {
        if (n == -1) {
            this.decodeStructureIndef(inputStream, aSN1Structure);
            return;
        }
        CountingInputStream countingInputStream = inputStream instanceof CountingInputStream ? (CountingInputStream)inputStream : new CountingInputStream(inputStream);
        int n2 = 0;
        while (n > 0) {
            int n3 = this.decodeTag(countingInputStream);
            int[] nArray = this.decodeLength(countingInputStream);
            n -= 1 + nArray[1];
            ASN1Object aSN1Object = null;
            int n4 = countingInputStream.pos;
            while ((aSN1Object = aSN1Structure.getDecodeComponent(n2++, n3)) == null) {
            }
            this.decodeValue(countingInputStream, n3, nArray[0], aSN1Object);
            if (nArray[0] < 0) {
                n -= countingInputStream.pos - n4;
                continue;
            }
            if (countingInputStream.pos - n4 != nArray[0]) {
                throw new IOException("Component size mismatch: " + (countingInputStream.pos - n4) + " " + n);
            }
            n -= nArray[0];
        }
    }

    private void readNextN(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 != -1) continue;
            throw new IOException("DER encoding ended prematurely");
        }
    }

    public static void main(String[] stringArray) {
        try {
            ASN1DER aSN1DER = new ASN1DER();
            ASN1Any aSN1Any = new ASN1Any();
            FileInputStream fileInputStream = new FileInputStream("key.p12");
            aSN1DER.decode(fileInputStream, aSN1Any);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final class CountingInputStream
    extends InputStream {
        int pos = 0;
        InputStream in;

        CountingInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        public int read() throws IOException {
            int n = this.in.read();
            ++this.pos;
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 > 0) {
                this.pos += n3;
            }
            return n3;
        }
    }
}

