/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TDoubleHashSet;
import gnu.trove.TDoubleIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TDoubleHashSetDecorator
extends AbstractSet
implements Set,
Cloneable {
    protected TDoubleHashSet _set;

    public TDoubleHashSetDecorator(TDoubleHashSet tDoubleHashSet) {
        this._set = tDoubleHashSet;
    }

    public Object clone() {
        try {
            TDoubleHashSetDecorator tDoubleHashSetDecorator = (TDoubleHashSetDecorator)super.clone();
            tDoubleHashSetDecorator._set = (TDoubleHashSet)this._set.clone();
            return tDoubleHashSetDecorator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean add(Object object) {
        return this._set.add(this.unwrap(object));
    }

    public boolean equals(Object object) {
        if (this._set.equals(object)) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (set.size() != this._set.size()) {
                return false;
            }
            Iterator iterator = set.iterator();
            int n = set.size();
            while (n-- > 0) {
                Object e = iterator.next();
                if (e instanceof Double) {
                    double d = this.unwrap(e);
                    if (this._set.contains(d)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object object) {
        return this._set.remove(this.unwrap(object));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TDoubleIterator it;
            {
                this.it = TDoubleHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TDoubleHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Double wrap(double d) {
        return new Double(d);
    }

    protected double unwrap(Object object) {
        return (Double)object;
    }
}

