/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongIntIterator;
import gnu.trove.TLongIntProcedure;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongIntHashMap
extends TLongHash
implements Serializable {
    protected transient int[] _values;

    public TLongIntHashMap() {
    }

    public TLongIntHashMap(int n) {
        super(n);
    }

    public TLongIntHashMap(int n, float f) {
        super(n, f);
    }

    public TLongIntHashMap(TLongHashingStrategy tLongHashingStrategy) {
        super(tLongHashingStrategy);
    }

    public TLongIntHashMap(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n, tLongHashingStrategy);
    }

    public TLongIntHashMap(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f, tLongHashingStrategy);
    }

    public Object clone() {
        TLongIntHashMap tLongIntHashMap = (TLongIntHashMap)super.clone();
        tLongIntHashMap._values = (int[])this._values.clone();
        return tLongIntHashMap;
    }

    public TLongIntIterator iterator() {
        return new TLongIntIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new int[n2];
        return n2;
    }

    public int put(long l, int n) {
        int n2 = 0;
        int n3 = this.insertionIndex(l);
        boolean bl = true;
        if (n3 < 0) {
            n3 = -n3 - 1;
            n2 = this._values[n3];
            bl = false;
        }
        byte by = this._states[n3];
        this._set[n3] = l;
        this._states[n3] = 1;
        this._values[n3] = n;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return n2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        int[] nArray = this._values;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._values = new int[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertionIndex(l);
            this._set[n4] = l;
            this._values[n4] = nArray[n3];
            this._states[n4] = 1;
        }
    }

    public int get(long l) {
        int n = this.index(l);
        return n < 0 ? 0 : this._values[n];
    }

    public void clear() {
        super.clear();
        long[] lArray = this._set;
        int[] nArray = this._values;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = 0L;
            nArray[n] = 0;
            byArray[n] = 0;
        }
    }

    public int remove(long l) {
        int n = 0;
        int n2 = this.index(l);
        if (n2 >= 0) {
            n = this._values[n2];
            this.removeAt(n2);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLongIntHashMap)) {
            return false;
        }
        TLongIntHashMap tLongIntHashMap = (TLongIntHashMap)object;
        if (tLongIntHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tLongIntHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public long[] keys() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public boolean containsValue(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.contains(l);
    }

    public boolean forEachKey(TLongProcedure tLongProcedure) {
        return this.forEach(tLongProcedure);
    }

    public boolean forEachValue(TIntProcedure tIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongIntProcedure tLongIntProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int[] nArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongIntProcedure.execute(lArray[n], nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TLongIntProcedure tLongIntProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int[] nArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongIntProcedure.execute(lArray[n], nArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TIntFunction tIntFunction) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n] = tIntFunction.execute(nArray[n]);
        }
    }

    public boolean increment(long l) {
        return this.adjustValue(l, 1);
    }

    public boolean adjustValue(long l, int n) {
        int n2 = this.index(l);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + n;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInputStream.readLong();
            int n2 = objectInputStream.readInt();
            this.put(l, n2);
        }
    }

    private static final class EqProcedure
    implements TLongIntProcedure {
        private final TLongIntHashMap _otherMap;

        EqProcedure(TLongIntHashMap tLongIntHashMap) {
            this._otherMap = tLongIntHashMap;
        }

        public final boolean execute(long l, int n) {
            int n2 = this._otherMap.index(l);
            return n2 >= 0 && this.eq(n, this._otherMap.get(l));
        }

        private final boolean eq(int n, int n2) {
            return n == n2;
        }
    }

    private final class HashProcedure
    implements TLongIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long l, int n) {
            this.h += TLongIntHashMap.this._hashingStrategy.computeHashCode(l) ^ HashFunctions.hash(n);
            return true;
        }
    }
}

