/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.THashIterator;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap
extends TObjectHash
implements Map,
Serializable {
    private static final long serialVersionUID = -183533684431610484L;
    protected transient Object[] _values;

    public THashMap() {
    }

    public THashMap(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public THashMap(int n) {
        super(n);
    }

    public THashMap(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public THashMap(int n, float f) {
        super(n, f);
    }

    public THashMap(int n, float f, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f, tObjectHashingStrategy);
    }

    public THashMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public THashMap(Map map, TObjectHashingStrategy tObjectHashingStrategy) {
        this(map.size(), tObjectHashingStrategy);
        this.putAll(map);
    }

    public Object clone() {
        THashMap tHashMap = (THashMap)super.clone();
        tHashMap._values = (Object[])this._values.clone();
        return tHashMap;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(Object object, Object object2) {
        if (null == object) {
            throw new NullPointerException("null keys not supported");
        }
        Object object3 = null;
        Object object4 = null;
        int n = this.insertionIndex(object);
        if (n < 0) {
            n = -n - 1;
            object3 = this._values[n];
        }
        object4 = this._set[n];
        this._set[n] = object;
        this._values[n] = object2;
        if (null == object3) {
            this.postInsertHook(object4 == null);
        }
        return object3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(map));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        Object[] objectArray = this._values;
        Object[] objectArray2 = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray2[n] == null || objectArray2[n] == REMOVED || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectObjectProcedure tObjectObjectProcedure) {
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectObjectProcedure tObjectObjectProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], objectArray2[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TObjectFunction tObjectFunction) {
        Object[] objectArray = this._values;
        Object[] objectArray2 = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray2[n] == null || objectArray2[n] == REMOVED) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        this._set = new Object[n];
        this._values = new Object[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == null || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = objectArray2[n3];
        }
    }

    public Object get(Object object) {
        int n = this.index(object);
        return n < 0 ? null : this._values[n];
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
            objectArray2[n] = null;
        }
    }

    public Object remove(Object object) {
        Object object2 = null;
        int n = this.index(object);
        if (n >= 0) {
            object2 = this._values[n];
            this.removeAt(n);
        }
        return object2;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = null;
    }

    public Collection values() {
        return new ValueView();
    }

    public Set keySet() {
        return new KeyView();
    }

    public Set entrySet() {
        return new EntryView();
    }

    public boolean containsValue(Object object) {
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        if (null == object) {
            int n = objectArray2.length;
            while (n-- > 0) {
                if (objectArray[n] == null || objectArray[n] == REMOVED || object != objectArray2[n]) continue;
                return true;
            }
        } else {
            int n = objectArray2.length;
            while (n-- > 0) {
                if (objectArray[n] == null || objectArray[n] == REMOVED || object != objectArray2[n] && !object.equals(objectArray2[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public void putAll(Map map) {
        this.ensureCapacity(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._hashingStrategy == null) {
            this._hashingStrategy = this;
        }
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    final class Entry
    implements Map.Entry {
        private final Object key;
        private Object val;
        private final int index;

        Entry(Object object, Object object2, int n) {
            this.key = object;
            this.val = object2;
            this.index = n;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object object) {
            if (THashMap.this._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            THashMap.this._values[this.index] = object;
            this.val = object = this.val;
            return object;
        }
    }

    protected class KeyView
    implements Set {
        protected KeyView() {
        }

        public Iterator iterator() {
            return new TObjectHashIterator(THashMap.this);
        }

        public int hashCode() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                n += iterator.next().hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (super.equals(object)) {
                return true;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return this.size() == collection.size() && this.containsAll(collection);
            }
            return false;
        }

        public boolean remove(Object object) {
            return null != THashMap.this.remove(object);
        }

        public boolean contains(Object object) {
            return THashMap.this.contains(object);
        }

        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public boolean removeAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        public void clear() {
            THashMap.this.clear();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return THashMap.this.size();
        }

        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            return objectArray;
        }

        public Object[] toArray(Object[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator iterator = this.iterator();
            for (int i = 0; i < n; ++i) {
                objectArray[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        public boolean isEmpty() {
            return THashMap.this.isEmpty();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        protected final class EntryIterator
        extends THashIterator {
            EntryIterator(THashMap tHashMap) {
                super(tHashMap);
            }

            public Object objectAtIndex(int n) {
                return new Entry(((KeyView)KeyView.this).THashMap.this._set[n], ((KeyView)KeyView.this).THashMap.this._values[n], n);
            }
        }
    }

    protected class EntryView
    extends KeyView {
        protected EntryView() {
        }

        public Iterator iterator() {
            return new KeyView.EntryIterator(THashMap.this);
        }

        public boolean remove(Object object) {
            Object object2;
            Object object3 = this.keyForEntry(object);
            int n = THashMap.this.index(object3);
            if (n >= 0 && ((object2 = this.valueForEntry(object)) == THashMap.this._values[n] || null != object2 && object2.equals(THashMap.this._values[n]))) {
                THashMap.this.removeAt(n);
                return true;
            }
            return false;
        }

        public boolean contains(Object object) {
            Object object2 = THashMap.this.get(this.keyForEntry(object));
            Object v = ((Map.Entry)object).getValue();
            return v == object2 || null != object2 && object2.equals(v);
        }

        protected Object valueForEntry(Object object) {
            return ((Map.Entry)object).getValue();
        }

        protected Object keyForEntry(Object object) {
            return ((Map.Entry)object).getKey();
        }
    }

    protected class ValueView
    extends KeyView {
        protected ValueView() {
        }

        public Iterator iterator() {
            return new THashIterator(THashMap.this){

                protected Object objectAtIndex(int n) {
                    return ((ValueView)this).THashMap.this._values[n];
                }
            };
        }

        public boolean contains(Object object) {
            return THashMap.this.containsValue(object);
        }

        public boolean remove(Object object) {
            boolean bl = false;
            Object[] objectArray = THashMap.this._values;
            Object[] objectArray2 = THashMap.this._set;
            int n = objectArray.length;
            while (n-- > 0) {
                if ((objectArray2[n] == null || objectArray2[n] == TObjectHash.REMOVED || object != objectArray[n]) && (null == objectArray[n] || !objectArray[n].equals(object))) continue;
                THashMap.this.removeAt(n);
                bl = true;
            }
            return bl;
        }
    }

    private static final class EqProcedure
    implements TObjectObjectProcedure {
        private final Map _otherMap;

        EqProcedure(Map map) {
            this._otherMap = map;
        }

        public final boolean execute(Object object, Object object2) {
            Object v = this._otherMap.get(object);
            return v == object2 || v != null && v.equals(object2);
        }
    }

    private final class HashProcedure
    implements TObjectObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(Object object, Object object2) {
            this.h += THashMap.this._hashingStrategy.computeHashCode(object) ^ (object2 == null ? 0 : object2.hashCode());
            return true;
        }
    }
}

