/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TDoubleArrayList
implements Serializable,
Cloneable {
    protected double[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TDoubleArrayList() {
        this(10);
    }

    public TDoubleArrayList(int n) {
        this._data = new double[n];
        this._pos = 0;
    }

    public TDoubleArrayList(double[] dArray) {
        this(Math.max(dArray.length, 10));
        this.add(dArray);
    }

    public void ensureCapacity(int n) {
        if (n > this._data.length) {
            int n2 = Math.max(this._data.length << 1, n);
            double[] dArray = new double[n2];
            System.arraycopy(this._data, 0, dArray, 0, this._data.length);
            this._data = dArray;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            double[] dArray = new double[this.size()];
            this.toNativeArray(dArray, 0, dArray.length);
            this._data = dArray;
        }
    }

    public void add(double d) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = d;
    }

    public void add(double[] dArray) {
        this.add(dArray, 0, dArray.length);
    }

    public void add(double[] dArray, int n, int n2) {
        this.ensureCapacity(this._pos + n2);
        System.arraycopy(dArray, n, this._data, this._pos, n2);
        this._pos += n2;
    }

    public void insert(int n, double d) {
        if (n == this._pos) {
            this.add(d);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._pos - n);
        this._data[n] = d;
        ++this._pos;
    }

    public void insert(int n, double[] dArray) {
        this.insert(n, dArray, 0, dArray.length);
    }

    public void insert(int n, double[] dArray, int n2, int n3) {
        if (n == this._pos) {
            this.add(dArray, n2, n3);
            return;
        }
        this.ensureCapacity(this._pos + n3);
        System.arraycopy(this._data, n, this._data, n + n3, this._pos - n);
        System.arraycopy(dArray, n2, this._data, n, n3);
        this._pos += n3;
    }

    public double get(int n) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._data[n];
    }

    public double getQuick(int n) {
        return this._data[n];
    }

    public void set(int n, double d) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this._data[n] = d;
    }

    public double getSet(int n, double d) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        double d2 = this._data[n];
        this._data[n] = d;
        return d2;
    }

    public void set(int n, double[] dArray) {
        this.set(n, dArray, 0, dArray.length);
    }

    public void set(int n, double[] dArray, int n2, int n3) {
        if (n < 0 || n + n3 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(dArray, n2, this._data, n, n3);
    }

    public void setQuick(int n, double d) {
        this._data[n] = d;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int n) {
        this._data = new double[n];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0.0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public double remove(int n) {
        double d = this.get(n);
        this.remove(n, 1);
        return d;
    }

    public void remove(int n, int n2) {
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            System.arraycopy(this._data, n2, this._data, 0, this._pos - n2);
        } else if (this._pos - n2 != n) {
            System.arraycopy(this._data, n + n2, this._data, n, this._pos - (n + n2));
        }
        this._pos -= n2;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        int n = this._pos;
        while (n-- > 0) {
            this._data[n] = tDoubleFunction.execute(this._data[n]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            this.swap(n3, i);
        }
    }

    public void shuffle(Random random) {
        int n = this._pos;
        while (n-- > 1) {
            this.swap(n, random.nextInt(n));
        }
    }

    private final void swap(int n, int n2) {
        double d = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = d;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public double[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public double[] toNativeArray(int n, int n2) {
        double[] dArray = new double[n2];
        this.toNativeArray(dArray, n, n2);
        return dArray;
    }

    public void toNativeArray(double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, 0, dArray, n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TDoubleArrayList) {
            TDoubleArrayList tDoubleArrayList = (TDoubleArrayList)object;
            if (tDoubleArrayList.size() != this.size()) {
                return false;
            }
            int n = this._pos;
            while (n-- > 0) {
                if (this._data[n] == tDoubleArrayList._data[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._pos;
        while (n2-- > 0) {
            n += HashFunctions.hash(this._data[n2]);
        }
        return n;
    }

    public boolean forEach(TDoubleProcedure tDoubleProcedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (tDoubleProcedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TDoubleProcedure tDoubleProcedure) {
        int n = this._pos;
        while (n-- > 0) {
            if (tDoubleProcedure.execute(this._data[n])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int n, int n2) {
        Arrays.sort(this._data, n, n2);
    }

    public void fill(double d) {
        Arrays.fill(this._data, 0, this._pos, d);
    }

    public void fill(int n, int n2, double d) {
        if (n2 > this._pos) {
            this.ensureCapacity(n2);
            this._pos = n2;
        }
        Arrays.fill(this._data, n, n2, d);
    }

    public int binarySearch(double d) {
        return this.binarySearch(d, 0, this._pos);
    }

    public int binarySearch(double d, int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            double d2 = this._data[n5];
            if (d2 < d) {
                n3 = n5 + 1;
                continue;
            }
            if (d2 > d) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public int indexOf(double d) {
        return this.indexOf(0, d);
    }

    public int indexOf(int n, double d) {
        for (int i = n; i < this._pos; ++i) {
            if (this._data[i] != d) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        return this.lastIndexOf(this._pos, d);
    }

    public int lastIndexOf(int n, double d) {
        int n2 = n;
        while (n2-- > 0) {
            if (this._data[n2] != d) continue;
            return n2;
        }
        return -1;
    }

    public boolean contains(double d) {
        return this.lastIndexOf(d) >= 0;
    }

    public TDoubleArrayList grep(TDoubleProcedure tDoubleProcedure) {
        TDoubleArrayList tDoubleArrayList = new TDoubleArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!tDoubleProcedure.execute(this._data[i])) continue;
            tDoubleArrayList.add(this._data[i]);
        }
        return tDoubleArrayList;
    }

    public TDoubleArrayList inverseGrep(TDoubleProcedure tDoubleProcedure) {
        TDoubleArrayList tDoubleArrayList = new TDoubleArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (tDoubleProcedure.execute(this._data[i])) continue;
            tDoubleArrayList.add(this._data[i]);
        }
        return tDoubleArrayList;
    }

    public double max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        double d = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (!(this._data[n] > d)) continue;
            d = this._data[n];
        }
        return d;
    }

    public double min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        double d = this._data[this._pos - 1];
        int n = this._pos - 1;
        while (n-- > 0) {
            if (!(this._data[n] < d)) continue;
            d = this._data[n];
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this._pos - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this._data[i]);
            stringBuffer.append(", ");
        }
        if (this.size() > 0) {
            stringBuffer.append(this._data[this._pos - 1]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

