/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.util;

import com.tripwire.honeybee.ui.model.marketing.LinkedImage;
import com.tripwire.honeybee.ui.model.marketing.LinkedText;
import com.tripwire.honeybee.ui.util.BrowserLauncher;
import com.tripwire.honeybee.ui.util.JOutputPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFactory {
    public static JFrame createTopLevelFrame(String title, Image icon) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(3);
        frame.setIconImage(icon);
        return frame;
    }

    public static void packFrame(JFrame frame) {
        frame.pack();
        frame.setResizable(false);
        Dimension dscreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
        Dimension dframe = frame.getSize();
        frame.setLocation((dscreen.width - dframe.width) / 2, (dscreen.height - dframe.height) / 2);
    }

    private static void addURLAction(JButton button, final String link) {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(link);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        button.addActionListener(listener);
    }

    private static void useHandCursor(JComponent component) {
        component.setCursor(Cursor.getPredefinedCursor(12));
    }

    private static void useDefaultCursor(JComponent component) {
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static JLabel createGraphicLabel(Image image) {
        ImageIcon icon = new ImageIcon(image);
        JLabel label = new JLabel(icon);
        label.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        return label;
    }

    public static JLabel createTextLabel(String text, boolean bold) {
        JLabel label = new JLabel(text);
        if (bold) {
            label.setFont(label.getFont().deriveFont(1));
        }
        return label;
    }

    public static JTextField createTextEntry() {
        JTextField field = new JTextField();
        Dimension dim = new Dimension(100, 20);
        field.setMinimumSize(dim);
        field.setMaximumSize(dim);
        field.setPreferredSize(dim);
        field.setSize(dim);
        return field;
    }

    public static JPasswordField createPasswordEntry() {
        JPasswordField field = new JPasswordField();
        Dimension dim = new Dimension(100, 20);
        field.setMinimumSize(dim);
        field.setMaximumSize(dim);
        field.setPreferredSize(dim);
        field.setSize(dim);
        return field;
    }

    public static JOutputPane createTextPane() {
        JOutputPane pane = new JOutputPane();
        pane.setEditable(false);
        return pane;
    }

    public static JButton createButton(String text, final Runnable action) {
        JButton button = new JButton(text);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
        return button;
    }

    public static JButton createTextLinkButton(String text, String link) {
        JButton button = new JButton(text);
        button.setForeground(UIManager.getColor("textHighlight"));
        button.setFont(button.getFont().deriveFont(1));
        return button;
    }

    public static void updateTextLinkButton(final JButton button, String text, String link) {
        button.setText(text);
        ActionListener[] listeners = button.getActionListeners();
        if (listeners.length > 0) {
            button.removeActionListener(listeners[0]);
        }
        final EmptyBorder emptyBorder = new EmptyBorder(1, 1, 1, 1);
        final Border underlineBorder = new Border(){

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(button.getForeground());
                g.drawLine(x, y + height - 1, width - 1, y + height - 1);
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(1, 1, 1, 1);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        };
        button.setBorder(emptyBorder);
        button.setContentAreaFilled(false);
        if (link != null) {
            button.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent e) {
                    button.setBorder(emptyBorder);
                }

                public void mouseEntered(MouseEvent e) {
                    button.setBorder(underlineBorder);
                }
            });
            ComponentFactory.addURLAction(button, link);
            ComponentFactory.useHandCursor(button);
        } else {
            ComponentFactory.useDefaultCursor(button);
        }
    }

    public static void updateTextLinkButtons(JButton[] buttons, List<LinkedText> links) {
        assert (buttons.length == links.size());
        int i = 0;
        for (JButton button : buttons) {
            LinkedText linkedText = links.get(i++);
            ComponentFactory.updateTextLinkButton(button, linkedText.getText(), linkedText.getLinkUrl());
        }
    }

    public static JButton[] createTextLinkButtons(List<LinkedText> links) {
        JButton[] buttons = new JButton[links.size()];
        int i = 0;
        for (LinkedText link : links) {
            buttons[i++] = ComponentFactory.createTextLinkButton(link.getText(), link.getLinkUrl());
        }
        ComponentFactory.updateTextLinkButtons(buttons, links);
        return buttons;
    }

    public static JButton createGraphicLinkButton(Image image, String link) {
        JButton button = new JButton(new ImageIcon(image));
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        button.setBorder(emptyBorder);
        button.setContentAreaFilled(false);
        if (link != null) {
            ComponentFactory.useHandCursor(button);
        }
        button.setFocusable(false);
        ComponentFactory.updateGraphicLinkButton(button, image, link);
        return button;
    }

    public static void updateGraphicLinkButton(JButton button, Image image, String link) {
        button.setIcon(new ImageIcon(image));
        ActionListener[] listeners = button.getActionListeners();
        if (listeners.length > 0) {
            button.removeActionListener(listeners[0]);
        }
        if (link != null) {
            ComponentFactory.addURLAction(button, link);
        }
    }

    public static JButton[] createGraphicLinkButtons(List<LinkedImage> images) {
        ArrayList<JButton> list = new ArrayList<JButton>();
        for (LinkedImage image : images) {
            list.add(ComponentFactory.createGraphicLinkButton(image.getImage(), image.getLinkUrl()));
        }
        list.toArray(new JButton[list.size()]);
        JButton[] buttons = new JButton[list.size()];
        list.toArray(buttons);
        return buttons;
    }

    public static void updateGraphicLinkButtons(JButton[] buttons, List<LinkedImage> images) {
        assert (buttons.length == images.size());
        int i = 0;
        for (JButton button : buttons) {
            LinkedImage image = images.get(i++);
            ComponentFactory.updateGraphicLinkButton(button, image.getImage(), image.getLinkUrl());
        }
    }

    private static Color midColor(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

