/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.model.marketing;

import com.tripwire.honeybee.ui.model.marketing.AssetModel;
import com.tripwire.honeybee.ui.model.marketing.AssetRetriever;
import com.tripwire.honeybee.ui.model.marketing.MarketingCollateralModel;
import com.tripwire.honeybee.ui.model.marketing.MoreInfoAreaModel;
import com.tripwire.honeybee.ui.model.marketing.MoreInfoAreaModelImpl;
import com.tripwire.honeybee.ui.model.marketing.RightBannerModel;
import com.tripwire.honeybee.ui.model.marketing.RightBannerModelImpl;
import com.tripwire.honeybee.ui.model.marketing.TopBannerModel;
import com.tripwire.honeybee.ui.model.marketing.TopBannerModelImpl;
import com.tripwire.honeybee.ui.model.marketing.local.LocalAssetRetriever;
import com.tripwire.honeybee.ui.model.marketing.remote.RemoteAssetRetriever;

public class MarketingCollateralModelImpl
implements MarketingCollateralModel {
    protected TopBannerModel m_topBannerModel = new TopBannerModelImpl();
    protected RightBannerModel m_rightBannerModel = new RightBannerModelImpl();
    protected MoreInfoAreaModel m_moreInfoAreaModel = new MoreInfoAreaModelImpl();

    public MarketingCollateralModelImpl(String remoteUrl) {
        boolean validAssets = false;
        if (remoteUrl != null) {
            RemoteAssetRetriever remoteRetriever = new RemoteAssetRetriever(remoteUrl);
            validAssets = this.loadAssets(remoteRetriever);
        }
        if (!validAssets) {
            this.loadAssets(LocalAssetRetriever.getInstance());
        }
    }

    private boolean loadAssets(AssetRetriever retriever) {
        if (!this.loadSingleSetOfAssets(retriever, this.m_topBannerModel)) {
            return false;
        }
        if (!this.loadSingleSetOfAssets(retriever, this.m_rightBannerModel)) {
            return false;
        }
        return this.loadSingleSetOfAssets(retriever, this.m_moreInfoAreaModel);
    }

    private boolean loadSingleSetOfAssets(AssetRetriever retriever, AssetModel model) {
        model.setAssetRetriever(retriever);
        model.loadAssets();
        return model.isValid();
    }

    public TopBannerModel getTopBanner() {
        return this.m_topBannerModel;
    }

    public RightBannerModel getRightBanner() {
        return this.m_rightBannerModel;
    }

    public MoreInfoAreaModel getMoreInfoArea() {
        return this.m_moreInfoAreaModel;
    }
}

