/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import java.io.InputStream;

public class SharedByteArrayInputStream
extends InputStream {
    private int m_start;
    private int m_pos;
    private int m_count;
    private int m_mark;
    private byte[] m_buffer;

    public SharedByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.m_buffer = buffer;
        this.m_pos = offset;
        int capacity = buffer.length;
        int count = offset + length;
        if (count > capacity) {
            count = capacity;
        }
        this.m_count = count;
        this.m_mark = offset;
        this.m_start = offset;
    }

    public SharedByteArrayInputStream(byte[] buffer) {
        this.m_buffer = buffer;
        this.m_count = buffer.length;
        this.m_pos = 0;
        this.m_mark = 0;
        this.m_start = 0;
    }

    public int available() {
        return this.m_count - this.m_pos;
    }

    public int read() {
        return this.m_pos < this.m_count ? this.m_buffer[this.m_pos++] & 0xFF : -1;
    }

    public long skip(long n) {
        if ((long)this.m_pos + n > (long)this.m_count) {
            n = this.m_count - this.m_pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.m_pos = (int)((long)this.m_pos + n);
        return n;
    }

    public int read(byte[] b, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int pos = this.m_pos;
        int count = this.m_count - pos;
        if (count <= 0) {
            return -1;
        }
        if (len > count) {
            len = count;
        }
        System.arraycopy(this.m_buffer, pos, b, off, len);
        this.m_pos += len;
        return len;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int getStart() {
        return this.m_start;
    }

    public int size() {
        return this.m_count;
    }

    public byte[] referenceByteArray() {
        return this.m_buffer;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.m_mark = this.m_pos;
    }

    public void reset() {
        this.m_pos = this.m_mark;
    }

    public void close() {
    }
}

