/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.util.StringUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;

public class ArrayUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final long[] EMPTY_LONGS = new long[0];

    public static int find(Object[] ao, Object o) {
        if (ao != null) {
            int N = ao.length;
            for (int i = 0; i < N; ++i) {
                Object current = ao[i];
                if (!o.equals(current)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int find(byte[] ao, byte o, int startIndex) {
        return ArrayUtil.find(ao, o, startIndex, ao.length);
    }

    public static int find(byte[] ao, byte o, int startIndex, int endIndex) {
        if (ao != null) {
            if (startIndex < 0) {
                startIndex = 0;
            }
            while (startIndex < endIndex) {
                if (o == ao[startIndex]) {
                    return startIndex;
                }
                ++startIndex;
            }
        }
        return -1;
    }

    public static int hashCode(byte[] ab) {
        return ArrayUtil.hashCode(ab, 0, ab.length);
    }

    public static int hashCode(byte[] ab, int offset, int length) {
        int hash = 0;
        int place = 0;
        int N = offset + length;
        for (int i = offset; i < N; ++i) {
            hash ^= ab[i] << place * 8;
            if (place == 3) {
                place = 0;
                continue;
            }
            ++place;
        }
        return hash;
    }

    public static int compareTo(byte[] lhs, byte[] rhs) {
        return ArrayUtil.compareTo(lhs, 0, lhs.length, rhs, 0, rhs.length);
    }

    public static int compareTo(byte[] lhs, int lhsOffset, int lhsLength, byte[] rhs, int rhsOffset, int rhsLength) {
        int smallestLen = Math.min(lhsLength, rhsLength);
        for (int i = 0; i < smallestLen; ++i) {
            byte l = lhs[lhsOffset + i];
            byte r = rhs[rhsOffset + i];
            if (l == r) continue;
            return l - r;
        }
        return lhsLength - rhsLength;
    }

    public static boolean equals(byte[] lhs, int lhsOffset, int lhsLength, byte[] rhs, int rhsOffset, int rhsLength) {
        if (lhsLength != rhsLength) {
            return false;
        }
        for (int i = 0; i < lhsLength; ++i) {
            byte l = lhs[lhsOffset + i];
            byte r = rhs[rhsOffset + i];
            if (l == r) continue;
            return false;
        }
        return true;
    }

    public static String toFormattedString(byte[] ab) {
        int N = ab.length;
        StringBuffer sb = new StringBuffer(N * 3 + 2);
        sb.append('{');
        for (int i = 0; i < N; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(StringUtil.toString(ab[i]));
        }
        sb.append('}');
        return sb.toString();
    }

    public static String toString(int[] array) {
        if (array == null) {
            return "null";
        }
        int N = array.length;
        StringBuffer sb = new StringBuffer(N * 2);
        sb.append('[');
        for (int i = 0; i != N; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(long[] array) {
        if (array == null) {
            return "null";
        }
        int N = array.length;
        StringBuffer sb = new StringBuffer(N * 2);
        sb.append('[');
        for (int i = 0; i != N; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(byte[] array) {
        if (array == null) {
            return "null";
        }
        int N = array.length;
        StringBuffer sb = new StringBuffer(N * 2);
        sb.append('[');
        for (int i = 0; i != N; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String[] toStringArray(Object[] objects) {
        int N = objects.length;
        String[] stringKeys = new String[N];
        System.arraycopy(objects, 0, stringKeys, 0, N);
        return stringKeys;
    }

    public static byte[] concatenate(byte[] first, byte[] second) {
        int firstN = first.length;
        int secondN = second.length;
        byte[] concatenated = new byte[firstN + secondN];
        System.arraycopy(first, 0, concatenated, 0, firstN);
        System.arraycopy(second, 0, concatenated, firstN, secondN);
        return concatenated;
    }

    public static Object[] slice(Object[] src, int start) {
        return ArrayUtil.slice(src, start, src.length);
    }

    public static Object[] slice(Object[] src, int start, int end) {
        assert (start > 0);
        assert (start < end);
        Object[] dst = new String[end - start];
        System.arraycopy(src, start, dst, 0, end - start);
        return dst;
    }

    public static int[] reverse(int[] array) {
        int N = array.length;
        int[] reversed = new int[N];
        int i = 0;
        int j = N - 1;
        while (i < N) {
            reversed[i] = array[j];
            ++i;
            --j;
        }
        return reversed;
    }

    public static long[] reverse(long[] array) {
        int N = array.length;
        long[] reversed = new long[N];
        int i = 0;
        int j = N - 1;
        while (i < N) {
            reversed[i] = array[j];
            ++i;
            --j;
        }
        return reversed;
    }

    public static String[] append(String[] array1, String[] array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        int n1 = array1.length;
        int n2 = array2.length;
        String[] newArray = new String[n1 + n2];
        System.arraycopy(array1, 0, newArray, 0, n1);
        System.arraycopy(array2, 0, newArray, n1, n2);
        return newArray;
    }

    public static String[] append(String[] array, String string) {
        if (array == null) {
            return new String[]{string};
        }
        int N = array.length;
        String[] newArray = new String[N + 1];
        System.arraycopy(array, 0, newArray, 0, N);
        newArray[N] = string;
        return newArray;
    }

    public static String[] appendUnique(String[] objects, String o) {
        if (objects != null && ArrayUtil.find(objects, o) != -1) {
            return objects;
        }
        return ArrayUtil.append(objects, o);
    }

    public static String[] remove(String[] objects, int at) {
        assert (objects != null && objects.length > 0);
        assert (at >= 0);
        objects[at] = null;
        int size = objects.length - 1;
        String[] newObjects = new String[size];
        System.arraycopy(objects, 0, newObjects, 0, at);
        if (at < size) {
            System.arraycopy(objects, at + 1, newObjects, at, size);
        }
        return newObjects;
    }

    public static String[] remove(String[] objects, String o) {
        int at = ArrayUtil.find(objects, o);
        if (at == -1) {
            return objects;
        }
        return ArrayUtil.remove(objects, at);
    }

    public static Object[] append(Object[] objects, Object o) {
        int size = objects.length;
        Object[] newArray = (Object[])Array.newInstance(objects.getClass().getComponentType(), size + 1);
        System.arraycopy(objects, 0, newArray, 0, size);
        newArray[size] = o;
        return newArray;
    }

    public static Object[] append(Object[] objects, Object[] append) {
        int first = objects.length;
        int second = append.length;
        Object[] newArray = (Object[])Array.newInstance(objects.getClass().getComponentType(), first + second);
        System.arraycopy(objects, 0, newArray, 0, first);
        System.arraycopy(append, 0, newArray, first, second);
        return newArray;
    }

    public static Object[] appendUnique(Object[] objects, Object o) {
        if (objects != null && ArrayUtil.find(objects, o) != -1) {
            return objects;
        }
        return ArrayUtil.append(objects, o);
    }

    public static Object[] appendUnique(Object[] objs1, Object[] objs2) {
        int at;
        if (objs1 == null) {
            return objs2;
        }
        if (objs2 == null) {
            return objs1;
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        int N = objs1.length;
        for (at = 0; at != N; ++at) {
            set.add(objs1[at]);
        }
        N = objs2.length;
        for (at = 0; at != N; ++at) {
            set.add(objs2[at]);
        }
        int n2 = set.size();
        Object[] objs = (Object[])Array.newInstance(objs1.getClass().getComponentType(), n2);
        return set.toArray(objs);
    }

    public static Object[] remove(Object[] objects, int at) {
        assert (objects != null && objects.length > 0);
        assert (at >= 0);
        objects[at] = null;
        int size = objects.length - 1;
        Object[] newObjects = new Object[size];
        System.arraycopy(objects, 0, newObjects, 0, at);
        if (at < size) {
            System.arraycopy(objects, at + 1, newObjects, at, size);
        }
        return newObjects;
    }

    public static Object[] remove(Object[] objects, Object o) {
        int at = ArrayUtil.find(objects, o);
        if (at == -1) {
            return objects;
        }
        return ArrayUtil.remove(objects, at);
    }

    public static byte[] readBytes(DataInput is) throws IOException {
        int size = is.readInt();
        if (size == 0) {
            return null;
        }
        byte[] data = new byte[size];
        is.readFully(data, 0, size);
        return data;
    }

    public static void writeBytes(DataOutput out, byte[] data) throws IOException {
        if (data == null) {
            out.writeInt(0);
        } else {
            int size = data.length;
            out.writeInt(size);
            if (size > 0) {
                out.write(data, 0, size);
            }
        }
    }

    public static int[] readInts(DataInput is) throws IOException {
        int size = is.readInt();
        if (size == 0) {
            return null;
        }
        int[] data = new int[size];
        for (int at = 0; at < size; ++at) {
            data[at] = is.readInt();
        }
        return data;
    }

    public static void writeInts(DataOutput out, int[] data) throws IOException {
        if (data == null) {
            out.write(0);
        } else {
            int size = data.length;
            out.writeInt(size);
            for (int at = 0; at < size; ++at) {
                out.writeInt(data[at]);
            }
        }
    }

    public static long[] readLongs(DataInput is) throws IOException {
        int size = is.readInt();
        if (size == 0) {
            return null;
        }
        long[] data = new long[size];
        for (int at = 0; at < size; ++at) {
            data[at] = is.readLong();
        }
        return data;
    }

    public static void writeLongs(DataOutput out, long[] data) throws IOException {
        if (data == null) {
            out.write(0);
        } else {
            int size = data.length;
            out.writeInt(size);
            for (int at = 0; at < size; ++at) {
                out.writeLong(data[at]);
            }
        }
    }

    public static int count(byte[] array, int offset, int length, byte value) {
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (array[i + offset] != value) continue;
            ++count;
        }
        return count;
    }
}

