/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.ScsiLun;
import com.vmware.vim25.ScsiLunDurableName;

public class ScsiLunCollector
extends AbstractVmwareCollector {
    public ScsiLunCollector() {
        super(ScsiLun.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".ScsiLun";
        if (o instanceof ScsiLun) {
            Integer queueDepth;
            ScsiLun scsiLun = (ScsiLun)o;
            ScsiLunDurableName[] alternateNames = scsiLun.getAlternateName();
            if (null != alternateNames) {
                for (int ii = 0; ii < alternateNames.length; ++ii) {
                    if (null == alternateNames[ii]) continue;
                    this.doCollect(alternateNames[ii], curKey + ".AlternateName" + ii);
                }
            }
            String canonicalName = scsiLun.getCanonicalName();
            this.doPut(curKey + ".CanonicalName", canonicalName);
            String deviceName = scsiLun.getDeviceName();
            this.doPut(curKey + ".DeviceName", deviceName);
            String deviceType = scsiLun.getDeviceType();
            this.doPut(curKey + ".DeviceType", deviceType);
            ScsiLunDurableName durableName = scsiLun.getDurableName();
            this.doCollect(durableName, curKey);
            String key = scsiLun.getKey();
            this.doPut(curKey + ".Key", key);
            String lunType = scsiLun.getLunType();
            this.doPut(curKey + ".LunType", lunType);
            String model = scsiLun.getModel();
            this.doPut(curKey + ".Model", model);
            String[] operationalState = scsiLun.getOperationalState();
            if (null != operationalState) {
                for (int ii = 0; ii < operationalState.length; ++ii) {
                    this.doPut(curKey + ".OperationalState" + ii, operationalState[ii]);
                }
            }
            if (null != (queueDepth = scsiLun.getQueueDepth())) {
                this.doPut(curKey + ".QueueDepth", "" + queueDepth);
            }
            String revision = scsiLun.getRevision();
            this.doPut(curKey + ".Revision", revision);
            Integer scsiLevel = scsiLun.getScsiLevel();
            if (null != scsiLevel) {
                this.doPut(curKey + ".ScsiLevel", "" + scsiLevel);
            }
            String serialNumber = scsiLun.getSerialNumber();
            this.doPut(curKey + ".SerialNumber", serialNumber);
            byte[] standardInquiry = scsiLun.getStandardInquiry();
            if (null != standardInquiry) {
                for (int ii = 0; ii < standardInquiry.length; ++ii) {
                    this.doPut(curKey + ".StandardInquiry" + ii, "" + standardInquiry[ii]);
                }
            }
            String uuid = scsiLun.getUuid();
            this.doPut(curKey + ".Uuid", uuid);
            String vendor = scsiLun.getVendor();
            this.doPut(curKey + ".Vendor", vendor);
        }
    }
}

