/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostNetworkPolicy;
import com.vmware.vim25.HostPortGroup;
import com.vmware.vim25.HostPortGroupPort;
import com.vmware.vim25.HostPortGroupSpec;

public class HostPortGroupCollector
extends AbstractVmwareCollector {
    public HostPortGroupCollector() {
        super(HostPortGroup.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostPortGroup";
        if (o instanceof HostPortGroup) {
            HostPortGroupPort[] ports;
            HostPortGroup hostPortGroup = (HostPortGroup)o;
            HostNetworkPolicy computedPolicy = hostPortGroup.getComputedPolicy();
            this.doCollect(computedPolicy, curKey);
            String key = hostPortGroup.getKey();
            if (null != key) {
                this.doPut(curKey + ".Key", key);
            }
            if (null != (ports = hostPortGroup.getPort())) {
                for (int ii = 0; ii < ports.length; ++ii) {
                    if (null == ports[ii]) continue;
                    this.doCollect(ports[ii], curKey + ".Port" + ii);
                }
            }
            HostPortGroupSpec spec = hostPortGroup.getSpec();
            this.doCollect(spec, curKey);
            String vswitch = hostPortGroup.getVswitch();
            if (null != vswitch) {
                this.doPut(curKey + ".Vswitch", vswitch);
            }
        }
    }
}

