/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostCapability;

public class HostCapabilityCollector
extends AbstractVmwareCollector {
    public HostCapabilityCollector() {
        super(HostCapability.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostCapability";
        if (o instanceof HostCapability) {
            Integer maxSupportedVMs;
            Integer maxSupportedVcpus;
            HostCapability hostCapability = (HostCapability)o;
            Integer maxRunningVMs = hostCapability.getMaxRunningVMs();
            if (null != maxRunningVMs) {
                this.doPut(curKey + ".MaxRunningVMs", "" + maxRunningVMs);
            }
            if (null != (maxSupportedVcpus = hostCapability.getMaxSupportedVcpus())) {
                this.doPut(curKey + ".MaxSupportedVcpus", "" + maxSupportedVcpus);
            }
            if (null != (maxSupportedVMs = hostCapability.getMaxSupportedVMs())) {
                this.doPut(curKey + ".MaxSupportedVMs", "" + maxSupportedVMs);
            }
            boolean backgroundSnapshotsSupported = hostCapability.isBackgroundSnapshotsSupported();
            this.doPut(curKey + ".BackgroundSnapshotsSupported", "" + backgroundSnapshotsSupported);
            boolean cpuMemoryResourceConfigurationSupported = hostCapability.isCpuMemoryResourceConfigurationSupported();
            this.doPut(curKey + ".BackgroundSnapshotsSupported", "" + backgroundSnapshotsSupported);
            boolean datastorePrincipalSupported = hostCapability.isDatastorePrincipalSupported();
            this.doPut(curKey + ".DatastorePrincipalSupported", "" + datastorePrincipalSupported);
            boolean highGuestMemSupported = hostCapability.isHighGuestMemSupported();
            this.doPut(curKey + ".HighGuestMemSupported", "" + highGuestMemSupported);
            boolean iscsiSupported = hostCapability.isIscsiSupported();
            this.doPut(curKey + ".IscsiSupported", "" + iscsiSupported);
            boolean localSwapDatastoreSupported = hostCapability.isLocalSwapDatastoreSupported();
            this.doPut(curKey + ".LocalSwapDatastoreSupported", "" + localSwapDatastoreSupported);
            boolean maintenanceModeSupported = hostCapability.isMaintenanceModeSupported();
            this.doPut(curKey + ".MaintenanceModeSupported", "" + maintenanceModeSupported);
            boolean nfsSupported = hostCapability.isNfsSupported();
            this.doPut(curKey + ".BackgroundSnapshotsSupported", "" + backgroundSnapshotsSupported);
            boolean nicTeamingSupported = hostCapability.isNicTeamingSupported();
            this.doPut(curKey + ".NicTeamingSupported", "" + nicTeamingSupported);
            boolean perVmSwapFiles = hostCapability.isPerVmSwapFiles();
            this.doPut(curKey + ".BackgroundSnapshotsSupported", "" + backgroundSnapshotsSupported);
            boolean preAssignedPCIUnitNumbersSupported = hostCapability.isPreAssignedPCIUnitNumbersSupported();
            this.doPut(curKey + ".BackgroundSnapshotsSupported", "" + backgroundSnapshotsSupported);
            boolean rebootSupported = hostCapability.isRebootSupported();
            this.doPut(curKey + ".RebootSupported", "" + rebootSupported);
            boolean recursiveResourcePoolsSupported = hostCapability.isRecursiveResourcePoolsSupported();
            this.doPut(curKey + ".RecursiveResourcePoolsSupported", "" + recursiveResourcePoolsSupported);
            boolean restrictedSnapshotRelocateSupported = hostCapability.isRestrictedSnapshotRelocateSupported();
            this.doPut(curKey + ".BackgroundSnapshotsSupported", "" + backgroundSnapshotsSupported);
            boolean sanSupported = hostCapability.isSanSupported();
            this.doPut(curKey + ".SanSupported", "" + sanSupported);
            boolean scaledScreenshotSupported = hostCapability.isScaledScreenshotSupported();
            this.doPut(curKey + ".ScaledScreenshotSupported", "" + scaledScreenshotSupported);
            boolean screenshotSupported = hostCapability.isScreenshotSupported();
            this.doPut(curKey + ".ScreenshotSupported", "" + screenshotSupported);
            boolean shutdownSupported = hostCapability.isShutdownSupported();
            this.doPut(curKey + ".ShutdownSupported", "" + shutdownSupported);
            boolean standbySupported = hostCapability.isStandbySupported();
            this.doPut(curKey + ".StandbySupported", "" + standbySupported);
            boolean suspendedRelocateSupported = hostCapability.isSuspendedRelocateSupported();
            this.doPut(curKey + ".SuspendedRelocateSupported", "" + suspendedRelocateSupported);
            boolean unsharedSwapVMotionSupported = hostCapability.isUnsharedSwapVMotionSupported();
            this.doPut(curKey + ".UnsharedSwapVMotionSupported", "" + unsharedSwapVMotionSupported);
            boolean vlanTaggingSupported = hostCapability.isVlanTaggingSupported();
            this.doPut(curKey + ".VlanTaggingSupported", "" + vlanTaggingSupported);
            boolean vmotionSupported = hostCapability.isVmotionSupported();
            this.doPut(curKey + ".VmotionSupported", "" + vmotionSupported);
        }
    }
}

