/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.TerminalInterpreter;
import java.util.NoSuchElementException;

public final class TerminalXTerm
extends TerminalInterpreter {
    public static final boolean DEBUG = false;
    public static final boolean DEBUGNOTIMPL = false;
    public static final boolean DEBUGSTATE = false;
    public static final boolean DEBUGPRINT = false;
    public static final int CASE_GROUND_STATE = 0;
    public static final int CASE_IGNORE_STATE = 1;
    public static final int CASE_IGNORE_ESC = 2;
    public static final int CASE_IGNORE = 3;
    public static final int CASE_BELL = 4;
    public static final int CASE_BS = 5;
    public static final int CASE_CR = 6;
    public static final int CASE_ESC = 7;
    public static final int CASE_VMOT = 8;
    public static final int CASE_TAB = 9;
    public static final int CASE_SI = 10;
    public static final int CASE_SO = 11;
    public static final int CASE_SCR_STATE = 12;
    public static final int CASE_SCS0_STATE = 13;
    public static final int CASE_SCS1_STATE = 14;
    public static final int CASE_SCS2_STATE = 15;
    public static final int CASE_SCS3_STATE = 16;
    public static final int CASE_ESC_IGNORE = 17;
    public static final int CASE_ESC_DIGIT = 18;
    public static final int CASE_ESC_SEMI = 19;
    public static final int CASE_DEC_STATE = 20;
    public static final int CASE_ICH = 21;
    public static final int CASE_CUU = 22;
    public static final int CASE_CUD = 23;
    public static final int CASE_CUF = 24;
    public static final int CASE_CUB = 25;
    public static final int CASE_CUP = 26;
    public static final int CASE_ED = 27;
    public static final int CASE_EL = 28;
    public static final int CASE_IL = 29;
    public static final int CASE_DL = 30;
    public static final int CASE_DCH = 31;
    public static final int CASE_DA1 = 32;
    public static final int CASE_TRACK_MOUSE = 33;
    public static final int CASE_TBC = 34;
    public static final int CASE_SET = 35;
    public static final int CASE_RST = 36;
    public static final int CASE_SGR = 37;
    public static final int CASE_CPR = 38;
    public static final int CASE_DECSTBM = 39;
    public static final int CASE_DECREQTPARM = 40;
    public static final int CASE_DECSET = 41;
    public static final int CASE_DECRST = 42;
    public static final int CASE_DECALN = 43;
    public static final int CASE_GSETS = 44;
    public static final int CASE_DECSC = 45;
    public static final int CASE_DECRC = 46;
    public static final int CASE_DECKPAM = 47;
    public static final int CASE_DECKPNM = 48;
    public static final int CASE_IND = 49;
    public static final int CASE_NEL = 50;
    public static final int CASE_HTS = 51;
    public static final int CASE_RI = 52;
    public static final int CASE_SS2 = 53;
    public static final int CASE_SS3 = 54;
    public static final int CASE_CSI_STATE = 55;
    public static final int CASE_OSC = 56;
    public static final int CASE_RIS = 57;
    public static final int CASE_LS2 = 58;
    public static final int CASE_LS3 = 59;
    public static final int CASE_LS3R = 60;
    public static final int CASE_LS2R = 61;
    public static final int CASE_LS1R = 62;
    public static final int CASE_PRINT = 63;
    public static final int CASE_XTERM_SAVE = 64;
    public static final int CASE_XTERM_RESTORE = 65;
    public static final int CASE_XTERM_TITLE = 66;
    public static final int CASE_DECID = 67;
    public static final int CASE_HP_MEM_LOCK = 68;
    public static final int CASE_HP_MEM_UNLOCK = 69;
    public static final int CASE_HP_BUGGY_LL = 70;
    public static final int CASE_SEQ_CAPTURE = 71;
    public static final int CASE_ESC_SEMIOSC = 72;
    public static final int CASE_XTERM_SEQ = 73;
    public static final int CASE_ENQ = 74;
    public static final int CASE_XTERMWIN = 75;
    public static final int CASE_CNL = 76;
    public static final int CASE_CPL = 77;
    public static final int CASE_CHA = 78;
    public static final int CASE_CHT = 79;
    public static final int CASE_SU = 80;
    public static final int CASE_SD = 81;
    public static final int CASE_ECH = 82;
    public static final int CASE_CBT = 83;
    public static final int CASE_HPA = 84;
    public static final int CASE_REP = 85;
    public static final int CASE_VPA = 86;
    public static final int CASE_ANSI_PRINTER = 87;
    public static final int[] asciiLineDrawChars = new int[]{32, 43, 58, 32, 32, 32, 32, 92, 35, 35, 35, 43, 43, 43, 43, 43, 126, 45, 45, 45, 95, 43, 43, 43, 43, 124, 60, 62, 42, 33, 102, 111, 62, 60, 94, 118};
    public static final int XVK_UP = 0;
    public static final int XVK_DOWN = 1;
    public static final int XVK_RIGHT = 2;
    public static final int XVK_LEFT = 3;
    public static final int XVK_PAGE_UP = 4;
    public static final int XVK_PAGE_DOWN = 5;
    public static final int XVK_END = 6;
    public static final int XVK_HOME = 7;
    public static final int XVK_INSERT = 8;
    public static final int XVK_F1 = 9;
    public static final int XVK_F2 = 10;
    public static final int XVK_F3 = 11;
    public static final int XVK_F4 = 12;
    public static final int XVK_F5 = 13;
    public static final int XVK_F6 = 14;
    public static final int XVK_F7 = 15;
    public static final int XVK_F8 = 16;
    public static final int XVK_F9 = 17;
    public static final int XVK_F10 = 18;
    public static final int XVK_F11 = 19;
    public static final int XVK_F12 = 20;
    public static final int XVK_NUMPAD0 = 21;
    public static final int XVK_NUMPAD1 = 22;
    public static final int XVK_NUMPAD2 = 23;
    public static final int XVK_NUMPAD3 = 24;
    public static final int XVK_NUMPAD4 = 25;
    public static final int XVK_NUMPAD5 = 26;
    public static final int XVK_NUMPAD6 = 27;
    public static final int XVK_NUMPAD7 = 28;
    public static final int XVK_NUMPAD8 = 29;
    public static final int XVK_NUMPAD9 = 30;
    public static final int XVK_MULTIPLY = 31;
    public static final int XVK_ADD = 32;
    public static final int XVK_SUBTRACT = 33;
    public static final int XVK_DIVIDE = 34;
    public static final int XVK_MAX = 35;
    public final int[] vk2xvk = new int[]{38, 40, 39, 37, 33, 34, 35, 36, 155, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 109, 111};
    public static final int EMUL_XTERM = 0;
    public static final int EMUL_LINUX = 1;
    public static final int EMUL_SCOANSI = 2;
    public static final int EMUL_ATT6386 = 3;
    public static final int EMUL_SUN = 4;
    public static final int EMUL_AIX = 5;
    public static final int EMUL_VT220 = 6;
    public static final int EMUL_VT100 = 7;
    public static final int EMUL_ANSI = 8;
    public static final int EMUL_VT52 = 9;
    public static final int EMUL_ALTERNATENAME = 10;
    public static final int EMUL_XTERMCOL = 10;
    public static final int EMUL_LINUXLAT = 11;
    public static final int EMUL_AT386 = 13;
    public static final int EMUL_VT102 = 17;
    public static final int EMUL_VT320 = 16;
    public static final int DEFAULT_TERM = 0;
    public static final String[] terminalTypes = new String[]{"xterm", "linux", "scoansi", "att6386", "sun", "aixterm", "vt220", "vt100", "ansi", "vt52", "xterm-color", "linux-lat", "", "at386", "", "", "vt320", "vt102"};
    int whoAmI;
    int whoAmIReally;
    boolean dumbMode = false;
    public static final String[][] specialKeyMap = new String[][]{{"A", "A", "A", "A", "A", "A", "A", "A", "A", "A"}, {"B", "B", "B", "B", "B", "B", "B", "B", "B", "B"}, {"C", "C", "C", "C", "C", "C", "C", "C", "C", "C"}, {"D", "D", "D", "D", "D", "D", "D", "D", "D", "D"}, {"5~", "5~", "I", "V", "216z", "150q", "5~", "5~", "5~", "5~"}, {"6~", "6~", "G", "U", "222z", "154q", "6~", "6~", "6~", "6~"}, {"F", "4~", "F", "Y", "220z", "146q", "4~", "4~", "4~", "4~"}, {"H", "1~", "H", "H", "214z", "H", "1~", "1~", "1~", "1~"}, {"2~", "2~", "L", "@", "2~", "139q", "2~", "2~", "L", "L"}, {"11~", "[A", "M", "P", "224z", "001q", "P", "P", "P", "P"}, {"12~", "[B", "N", "Q", "225z", "002q", "Q", "Q", "Q", "Q"}, {"13~", "[C", "O", "R", "226z", "003q", "R", "R", "R", "R"}, {"14~", "[D", "P", "S", "227z", "004q", "S", "S", "S", "S"}, {"15~", "[E", "Q", "T", "228z", "005q", "17~", null, null, null}, {"17~", "17~", "R", "U", "229z", "006q", "18~", null, null, null}, {"18~", "18~", "S", "V", "230z", "007q", "19~", null, null, null}, {"19~", "19~", "T", "W", "231z", "008q", "20~", null, null, null}, {"20~", "20~", "U", "X", "232z", "009q", "21~", null, null, null}, {"21~", "21~", "V", "Y", "233z", "010q", "29~", null, null, null}, {"23~", "23~", "W", "Z", "234z", "011q", null, null, null, null}, {"24~", "24~", "X", "A", "235z", "012q", null, null, null, null}};
    public static final String[][] specialKeyMapShift = new String[][]{{"A", "A", "A", "A", "A", "A", "A", "A", "A", "A"}, {"B", "B", "B", "B", "B", "B", "B", "B", "B", "B"}, {"C", "C", "C", "C", "C", "C", "C", "C", "C", "C"}, {"D", "D", "D", "D", "D", "D", "D", "D", "D", "D"}, {"5~", "5~", "I", "V", "216z", "150q", "5~", "5~", "5~", "5~"}, {"6~", "6~", "G", "U", "222z", "154q", "6~", "6~", "6~", "6~"}, {"4~", "4~", "F", "Y", "220z", "146q", "4~", "4~", "4~", "4~"}, {"@", "1~", "H", "H", "214z", "H", "1~", "1~", "1~", "1~"}, {"2~", "2~", "L", "@", "2~", "139q", "2~", "2~", "L", "L"}, {"23~", "23~", "Y", "P", "224z", "013q", "P", "P", "P", "P"}, {"24~", "24~", "Z", "Q", "225z", "014q", "Q", "Q", "Q", "Q"}, {"25~", "25~", "a", "R", "226z", "015q", "R", "R", "R", "R"}, {"26~", "26~", "b", "S", "227z", "016q", "S", "S", "S", "S"}, {"28~", "28~", "c", "T", "228z", "017q", "17~", null, null, null}, {"29~", "29~", "d", "U", "229z", "018q", "18~", null, null, null}, {"31~", "31~", "e", "V", "230z", "019q", "19~", null, null, null}, {"32~", "32~", "f", "W", "231z", "020q", "20~", null, null, null}, {"33~", "33~", "g", "X", "232z", "021q", "21~", null, null, null}, {"34~", "34~", "h", "Y", "233z", "022q", "29~", null, null, null}, {"23$", null, "i", "Z", "234z", "023q", null, null, null, null}, {"24$", null, "j", "A", "235z", "024q", null, null, null, null}};
    public static final String[][] specialKeyMapCtrl = new String[][]{{"A", "A", "A", "A", "A", "A", "A", "A", "A", "A"}, {"B", "B", "B", "B", "B", "B", "B", "B", "B", "B"}, {"C", "C", "C", "C", "C", "C", "C", "C", "C", "C"}, {"D", "D", "D", "D", "D", "D", "D", "D", "D", "D"}, {"5~", "5~", "I", "V", "216z", "150q", "5~", "5~", "5~", "5~"}, {"6~", "6~", "G", "U", "222z", "154q", "6~", "6~", "6~", "6~"}, {"4~", "4~", "F", "Y", "220z", "146q", "4~", "4~", "4~", "4~"}, {"@", "1~", "H", "H", "214z", "H", "1~", "1~", "1~", "1~"}, {"2~", "2~", "L", "@", "2~", "139q", "2~", "2~", "L", "L"}, {"11^", null, "k", "P", "224z", "025q", "P", "P", "P", "P"}, {"12^", null, "l", "Q", "225z", "026q", "Q", "Q", "Q", "Q"}, {"13^", null, "m", "R", "226z", "027q", "R", "R", "R", "R"}, {"14^", null, "n", "S", "227z", "028q", "S", "S", "S", "S"}, {"15^", null, "o", "T", "228z", "029q", "17~", null, null, null}, {"17^", null, "p", "U", "229z", "030q", "18~", null, null, null}, {"18^", null, "q", "V", "230z", "031q", "19~", null, null, null}, {"19^", null, "r", "W", "231z", "032q", "20~", null, null, null}, {"20^", null, "s", "X", "232z", "033q", "21~", null, null, null}, {"21^", null, "t", "Y", "233z", "034q", "29~", null, null, null}, {"23^", null, "u", "Z", "234z", "035q", null, null, null, null}, {"24^", null, "v", "A", "235z", "036q", null, null, null, null}};
    public static final String[][] specialKeyMapCtrlShift = new String[][]{{"A", "A", "A", "A", "A", "A", "A", "A", "A", "A"}, {"B", "B", "B", "B", "B", "B", "B", "B", "B", "B"}, {"C", "C", "C", "C", "C", "C", "C", "C", "C", "C"}, {"D", "D", "D", "D", "D", "D", "D", "D", "D", "D"}, {"5~", "5~", "I", "V", "216z", "150q", "5~", "5~", "5~", "5~"}, {"6~", "6~", "G", "U", "222z", "154q", "6~", "6~", "6~", "6~"}, {"4~", "4~", "F", "Y", "220z", "146q", "4~", "4~", "4~", "4~"}, {"@", "1~", "H", "H", "214z", "H", "1~", "1~", "1~", "1~"}, {"2~", "2~", "L", "@", "2~", "139q", "2~", "2~", "L", "L"}, {"23^", null, "w", "P", "224z", "001q", "P", "P", "P", "P"}, {"24^", null, "x", "Q", "225z", "002q", "Q", "Q", "Q", "Q"}, {"25^", null, "y", "R", "226z", "003q", "R", "R", "R", "R"}, {"26^", null, "z", "S", "227z", "004q", "S", "S", "S", "S"}, {"28^", null, "@", "T", "228z", "005q", "17~", null, null, null}, {"29^", null, "[", "U", "229z", "006q", "18~", null, null, null}, {"31^", null, "\\", "V", "230z", "007q", "19~", null, null, null}, {"32^", null, "]", "W", "231z", "008q", "20~", null, null, null}, {"33^", null, "^", "X", "232z", "009q", "21~", null, null, null}, {"34^", null, "_", "Y", "233z", "010q", "29~", null, null, null}, {"23@", null, "`", "Z", "234z", "011q", null, null, null, null}, {"24@", null, "{", "A", "235z", "012q", null, null, null, null}};
    public static final String[][][] theSpecialKeyMaps = new String[][][]{specialKeyMap, specialKeyMapShift, specialKeyMapCtrl, specialKeyMapCtrlShift};
    public static final int R_ESC = 0;
    public static final int R_SS2 = 1;
    public static final int R_SS3 = 2;
    public static final int R_DCS = 3;
    public static final int R_CSI = 4;
    public static final int R_OSC = 5;
    public static final int R_PM = 6;
    public static final int R_APC = 7;
    public static final String[] replyTypes = new String[]{"\u001b", "\u001bN", "\u001bO", "\u001bP", "\u001b[", "\u001b]", "\u001b^", "\u001b_"};
    public static final char CHARSET_UK = 'A';
    public static final char CHARSET_ASCII = 'B';
    public static final char CHARSET_LINES = '0';
    public static final char CHARSET_ASCII_ALT = '1';
    public static final char CHARSET_ASCII_ALT2 = '2';
    char[] gSets = new char[4];
    int scsType;
    int curGL;
    int curGR;
    int curSS;
    int curGLDECSC;
    char[] gSetsDECSC = new char[4];
    String xtermSeq = null;
    String reply = null;
    public static final int PARAMNOTUSED = -1;
    int[] parseState;
    boolean windowRelative;
    boolean keypadAppl;
    boolean cursorKeysMode;
    public static final int MOUSE_DONTSEND = 0;
    public static final int MOUSE_X10COMP = 1;
    public static final int MOUSE_DECVT200 = 2;
    public static final int MOUSE_HLTRACK = 3;
    int sendMousePos;
    int[] param = new int[10];
    int nparam;
    public static final int[] groundTable = new int[]{63, 63, 63, 63, 63, 74, 63, 4, 5, 9, 8, 8, 8, 6, 11, 10, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 7, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 0, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    public static final int[] csiTable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 3, 19, 3, 3, 3, 20, 21, 22, 23, 24, 25, 76, 77, 78, 26, 79, 27, 28, 29, 30, 0, 0, 31, 0, 0, 80, 81, 0, 0, 0, 82, 0, 83, 0, 0, 0, 81, 0, 84, 0, 85, 32, 86, 0, 26, 34, 35, 87, 0, 0, 36, 37, 38, 0, 0, 0, 39, 45, 75, 46, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] decTable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 3, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 42, 0, 0, 0, 0, 0, 65, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] oscTable = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 3, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 42, 0, 0, 0, 0, 0, 65, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] xtermSeqTable = new int[]{71, 71, 71, 71, 71, 71, 71, 73, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71};
    public static final int[] eigTable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] escTable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 12, 17, 17, 17, 17, 13, 14, 15, 16, 17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 45, 46, 0, 0, 0, 0, 47, 48, 0, 0, 0, 0, 0, 49, 50, 70, 0, 51, 0, 0, 0, 0, 52, 53, 54, 1, 0, 0, 0, 66, 0, 0, 0, 0, 0, 67, 55, 0, 56, 1, 1, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 68, 69, 58, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 61, 62, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] iesTable = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] ignTable = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 0, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] scrTable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] scsTable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 44, 44, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static final boolean hasNullPadding(int n) {
        return n == 6 || n == 7 || n == 8 || n == 9;
    }

    public TerminalXTerm() {
        this(0);
    }

    public TerminalXTerm(int n) {
        try {
            this.setTerminalType(n);
        }
        catch (NoSuchElementException noSuchElementException) {
            try {
                this.setTerminalType(0);
            }
            catch (NoSuchElementException noSuchElementException2) {
                // empty catch block
            }
        }
    }

    public static String listAvailableTerminalTypes() {
        String string = " ";
        for (int i = 0; i < terminalTypes.length; ++i) {
            string = string + terminalTypes[i] + " ";
        }
        return string;
    }

    public static String[] getTerminalTypes() {
        int n;
        int n2 = 0;
        for (n = 0; n < terminalTypes.length; ++n) {
            if (terminalTypes[n].equals("")) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        for (n = 0; n < terminalTypes.length; ++n) {
            if (terminalTypes[n].equals("")) continue;
            stringArray[n2++] = terminalTypes[n];
        }
        return stringArray;
    }

    public String terminalType() {
        return terminalTypes[this.whoAmI];
    }

    public void setTerminalType(int n) throws NoSuchElementException {
        if (n < terminalTypes.length && n > -1) {
            this.whoAmI = n;
            this.whoAmIReally = n;
            if (this.whoAmI >= 10) {
                this.whoAmIReally -= 10;
            }
        } else {
            throw new NoSuchElementException(n + " is not a supported terminal-emulation");
        }
        this.vtReset();
    }

    public void setTerminalType(String string) throws NoSuchElementException {
        int n;
        for (n = 0; n < terminalTypes.length && !terminalTypes[n].equalsIgnoreCase(string); ++n) {
        }
        this.setTerminalType(n);
    }

    public void setDumbMode(boolean bl) {
        this.dumbMode = bl;
    }

    final int mapLineDrawToAscii(char c) {
        if (c >= '_' && c <= '~') {
            c = (char)asciiLineDrawChars[c - 95];
        } else if (c >= '+' && c <= '.') {
            c = (char)asciiLineDrawChars[c - 43 + 32];
        } else if (c == ' ') {
            // empty if block
        }
        return c;
    }

    final char mapLineDrawToLinux(char c) {
        switch (c) {
            case ' ': {
                c = (char)32;
                break;
            }
            case '\u0004': {
                c = (char)96;
                break;
            }
            case '\u00b1': {
                c = (char)97;
                break;
            }
            case '\u00f8': {
                c = (char)102;
                break;
            }
            case '\u00f1': {
                c = (char)103;
                break;
            }
            case '\u00b0': {
                c = (char)104;
                break;
            }
            case '\u0089': 
            case '\u00d9': {
                c = (char)106;
                break;
            }
            case '\u008c': 
            case '\u00bf': {
                c = (char)107;
                break;
            }
            case '\u0086': 
            case '\u00da': {
                c = (char)108;
                break;
            }
            case '\u0083': 
            case '\u00c0': {
                c = (char)109;
                break;
            }
            case '\u00c5': {
                c = (char)110;
                break;
            }
            case '\u008a': 
            case '\u00c4': {
                c = (char)113;
                break;
            }
            case '\u00f2': {
                c = (char)114;
                break;
            }
            case '\u0087': 
            case '\u00c3': {
                c = (char)116;
                break;
            }
            case '\u008d': 
            case '\u00b4': {
                c = (char)117;
                break;
            }
            case '\u00c1': {
                c = (char)118;
                break;
            }
            case '\u00c2': {
                c = (char)119;
                break;
            }
            case '\u0085': 
            case '\u00b3': {
                c = (char)120;
                break;
            }
            case '\u00f3': 
            case '\u00f9': {
                c = (char)121;
                break;
            }
            case '\u00fa': {
                c = (char)122;
                break;
            }
            case '\u00e3': 
            case '\u00fb': {
                c = (char)123;
                break;
            }
            case '\u00d8': 
            case '\u00fc': {
                c = (char)124;
                break;
            }
            case '\u009c': 
            case '\u00fd': {
                c = (char)125;
                break;
            }
            case '\u00fe': {
                c = (char)126;
                break;
            }
            case '\u0019': {
                c = (char)46;
                break;
            }
            case '\u00db': {
                c = (char)43;
                break;
            }
            case '\u0018': {
                c = (char)45;
                break;
            }
        }
        return c;
    }

    final char mapLineDrawToATT6386(char c) {
        switch (c) {
            case ' ': {
                c = (char)32;
                break;
            }
            case '`': {
                c = (char)96;
                break;
            }
            case '1': {
                c = (char)97;
                break;
            }
            case 'x': {
                c = (char)102;
                break;
            }
            case 'q': {
                c = (char)103;
                break;
            }
            case '0': {
                c = (char)104;
                break;
            }
            case 'Y': {
                c = (char)106;
                break;
            }
            case '?': {
                c = (char)107;
                break;
            }
            case 'Z': {
                c = (char)108;
                break;
            }
            case '@': {
                c = (char)109;
                break;
            }
            case 'E': {
                c = (char)110;
                break;
            }
            case 'o': {
                c = (char)111;
                break;
            }
            case 'p': {
                c = (char)112;
                break;
            }
            case 'D': {
                c = (char)113;
                break;
            }
            case 'r': {
                c = (char)114;
                break;
            }
            case 's': {
                c = (char)115;
                break;
            }
            case 'C': {
                c = (char)116;
                break;
            }
            case '4': {
                c = (char)117;
                break;
            }
            case 'A': {
                c = (char)118;
                break;
            }
            case 'B': {
                c = (char)119;
                break;
            }
            case '3': {
                c = (char)120;
                break;
            }
            case 'y': {
                c = (char)121;
                break;
            }
            case 'z': {
                c = (char)122;
                break;
            }
            case '{': {
                c = (char)123;
                break;
            }
            case '|': {
                c = (char)124;
                break;
            }
            case '}': {
                c = (char)125;
                break;
            }
            case '~': {
                c = (char)126;
                break;
            }
        }
        return c;
    }

    public int interpretChar(char c) {
        if (c > '\u00ff') {
            return c;
        }
        switch (this.parseState[c]) {
            case 63: {
                int n;
                int n2 = -1;
                if (c >= '\u0080' && this.curGR != -1) {
                    n = this.curGR;
                    c = (char)(c - 128);
                } else {
                    n = this.curGL;
                }
                switch (this.gSets[n]) {
                    case 'A': {
                        if (c == '#') {
                            n2 = 163;
                            break;
                        }
                        n2 = c;
                        break;
                    }
                    case '1': 
                    case '2': 
                    case 'B': {
                        n2 = c;
                        if (n2 >= 32) break;
                        if (n2 == 0 && TerminalXTerm.hasNullPadding(this.whoAmIReally)) {
                            return -1;
                        }
                        this.term.write('^');
                        n2 += 64;
                        break;
                    }
                    case '0': {
                        if (!this.term.getOption(16)) {
                            if (c < '_') {
                                n2 = c;
                                break;
                            }
                            if (this.whoAmIReally == 1) {
                                c = this.mapLineDrawToLinux(c);
                            } else if (this.whoAmIReally == 3) {
                                c = this.mapLineDrawToATT6386(c);
                            }
                            this.term.writeLineDrawChar(c);
                            break;
                        }
                        n2 = this.mapLineDrawToAscii(c);
                        break;
                    }
                }
                return n2;
            }
            case 0: {
                this.parseState = groundTable;
                break;
            }
            case 1: {
                this.parseState = ignTable;
                break;
            }
            case 2: {
                this.parseState = iesTable;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.term.doBell();
                break;
            }
            case 5: {
                this.term.doBS();
                break;
            }
            case 6: {
                this.term.doCR();
                this.parseState = groundTable;
                break;
            }
            case 7: {
                this.parseState = escTable;
                break;
            }
            case 8: {
                this.term.doLF();
                this.parseState = groundTable;
                break;
            }
            case 9: {
                this.term.doTab();
                break;
            }
            case 10: {
                this.curGL = 0;
                break;
            }
            case 11: {
                this.curGL = 1;
                break;
            }
            case 12: {
                this.parseState = scrTable;
                break;
            }
            case 13: {
                this.scsType = 0;
                this.parseState = scsTable;
                break;
            }
            case 14: {
                this.scsType = 1;
                this.parseState = scsTable;
                break;
            }
            case 15: {
                this.scsType = 2;
                this.parseState = scsTable;
                break;
            }
            case 16: {
                this.scsType = 3;
                this.parseState = scsTable;
                break;
            }
            case 17: {
                this.parseState = eigTable;
                break;
            }
            case 18: {
                int n = this.param[this.nparam - 1];
                if (n == -1) {
                    n = 0;
                }
                this.param[this.nparam - 1] = 10 * n + (c - 48);
                break;
            }
            case 19: {
                this.param[this.nparam++] = -1;
                break;
            }
            case 72: {
                this.param[this.nparam++] = -1;
                this.xtermSeq = "";
                this.parseState = xtermSeqTable;
                break;
            }
            case 20: {
                this.parseState = decTable;
                break;
            }
            case 21: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.insertChars(n);
                this.parseState = groundTable;
                break;
            }
            case 77: {
                this.term.doCR();
            }
            case 22: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorUp(n);
                this.parseState = groundTable;
                break;
            }
            case 76: {
                this.term.doCR();
            }
            case 23: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorDown(n);
                this.parseState = groundTable;
                break;
            }
            case 24: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorForward(n);
                this.parseState = groundTable;
                break;
            }
            case 25: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorBackward(n);
                this.parseState = groundTable;
                break;
            }
            case 26: {
                int n = this.param[0];
                int n3 = this.param[1];
                if (n < 1) {
                    n = 1;
                }
                if (this.nparam < 2 || n3 < 1) {
                    n3 = 1;
                }
                this.term.cursorSetPos(n - 1, n3 - 1, this.windowRelative);
                this.parseState = groundTable;
                break;
            }
            case 27: {
                switch (this.param[0]) {
                    case -1: 
                    case 0: {
                        this.term.clearBelow();
                        break;
                    }
                    case 1: {
                        this.term.clearAbove();
                        break;
                    }
                    case 2: {
                        this.term.clearScreen();
                        this.term.cursorSetPos(0, 0, this.windowRelative);
                    }
                }
                this.parseState = groundTable;
                break;
            }
            case 28: {
                switch (this.param[0]) {
                    case -1: 
                    case 0: {
                        this.term.clearRight();
                        break;
                    }
                    case 1: {
                        this.term.clearLeft();
                        break;
                    }
                    case 2: {
                        this.term.clearLine();
                    }
                }
                this.parseState = groundTable;
                break;
            }
            case 29: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.insertLines(n);
                this.parseState = groundTable;
                break;
            }
            case 30: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.deleteLines(n);
                this.parseState = groundTable;
                break;
            }
            case 31: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.deleteChars(n);
                this.parseState = groundTable;
                break;
            }
            case 67: {
                this.param[0] = -1;
            }
            case 32: {
                this.reply = replyTypes[4] + "?1;2c";
                this.term.sendBytes(this.reply.getBytes());
                this.parseState = groundTable;
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                if (this.param[0] <= 0) {
                    this.term.clearTab(this.term.getCursorH());
                } else if (this.param[0] == 3) {
                    this.term.clearAllTabs();
                }
                this.parseState = groundTable;
                break;
            }
            case 35: {
                this.ansiModes(true);
                this.parseState = groundTable;
                break;
            }
            case 36: {
                this.ansiModes(false);
                this.parseState = groundTable;
                break;
            }
            case 37: {
                this.sgrModes();
                this.parseState = groundTable;
                break;
            }
            case 38: {
                this.reply = null;
                if (this.param[0] == 5) {
                    this.reply = replyTypes[4] + "0n";
                } else if (this.param[0] == 6) {
                    this.reply = replyTypes[4] + (this.term.getCursorV() + 1) + ";" + (this.term.getCursorH() + 1) + "R";
                }
                if (this.reply != null) {
                    this.term.sendBytes(this.reply.getBytes());
                }
                this.parseState = groundTable;
                break;
            }
            case 39: {
                int n = this.param[0];
                int n4 = this.param[1];
                if (n < 1) {
                    n = 1;
                }
                if (this.nparam < 2 || n4 == -1 || n4 == 0 || n4 > this.term.rows()) {
                    n4 = this.term.rows();
                }
                if (n4 > n) {
                    this.term.setWindow(n - 1, n4);
                    this.term.cursorSetPos(0, 0, this.windowRelative);
                }
                this.parseState = groundTable;
                break;
            }
            case 40: {
                if (this.param[0] == -1 || this.param[0] == 1 || this.param[0] == 0) {
                    this.reply = replyTypes[4] + String.valueOf(this.term.getCursorV() + 2) + ";1;1;112;112;1;0x";
                }
                if (this.reply != null) {
                    this.term.sendBytes(this.reply.getBytes());
                }
                this.parseState = groundTable;
                break;
            }
            case 41: {
                this.dpModes(true);
                this.parseState = groundTable;
                break;
            }
            case 42: {
                this.dpModes(false);
                this.parseState = groundTable;
                break;
            }
            case 43: {
                this.term.fillScreen('E');
                this.parseState = groundTable;
                break;
            }
            case 44: {
                this.gSets[this.scsType] = c;
                this.parseState = groundTable;
                break;
            }
            case 45: {
                this.term.cursorSave();
                this.curGLDECSC = this.curGL;
                System.arraycopy(this.gSets, 0, this.gSetsDECSC, 0, 4);
                this.parseState = groundTable;
                break;
            }
            case 46: {
                this.term.cursorRestore();
                this.curGL = this.curGLDECSC;
                System.arraycopy(this.gSetsDECSC, 0, this.gSets, 0, 4);
                this.parseState = groundTable;
                break;
            }
            case 47: {
                this.keypadAppl = true;
                this.parseState = groundTable;
                break;
            }
            case 48: {
                this.keypadAppl = false;
                this.parseState = groundTable;
                break;
            }
            case 49: {
                this.term.cursorIndex(1);
                this.parseState = groundTable;
                break;
            }
            case 50: {
                this.term.cursorIndex(1);
                this.term.doCR();
                this.parseState = groundTable;
                break;
            }
            case 51: {
                this.term.setTab(this.term.getCursorH());
                this.parseState = groundTable;
                break;
            }
            case 52: {
                this.term.cursorIndexRev(1);
                this.parseState = groundTable;
                break;
            }
            case 53: {
                this.curSS = 2;
                this.parseState = groundTable;
                break;
            }
            case 54: {
                this.curSS = 3;
                this.parseState = groundTable;
                break;
            }
            case 55: {
                this.param[0] = -1;
                this.nparam = 1;
                this.parseState = csiTable;
                break;
            }
            case 56: {
                this.param[0] = -1;
                this.nparam = 1;
                this.parseState = oscTable;
                break;
            }
            case 57: {
                this.vtReset();
                this.parseState = groundTable;
                break;
            }
            case 58: {
                this.curGL = 2;
                this.parseState = groundTable;
                break;
            }
            case 59: {
                this.curGL = 3;
                this.parseState = groundTable;
                break;
            }
            case 60: {
                this.parseState = groundTable;
                this.curGR = 3;
                break;
            }
            case 61: {
                this.parseState = groundTable;
                this.curGR = 2;
                break;
            }
            case 62: {
                this.curGR = 1;
                this.parseState = groundTable;
                break;
            }
            case 64: {
                this.xtermSavemodes();
                this.parseState = groundTable;
                break;
            }
            case 65: {
                this.xtermRestoremodes();
                this.parseState = groundTable;
                break;
            }
            case 66: {
                break;
            }
            case 68: {
                this.parseState = groundTable;
                break;
            }
            case 69: {
                this.parseState = groundTable;
                break;
            }
            case 70: {
                this.parseState = groundTable;
                break;
            }
            case 73: {
                this.xtermModes();
                this.parseState = groundTable;
                break;
            }
            case 71: {
                this.xtermSeq = this.xtermSeq + c;
                break;
            }
            case 74: {
                this.term.sendBytes(this.terminalType().getBytes());
                break;
            }
            case 75: {
                this.xtermWinCtrl();
                this.parseState = groundTable;
            }
            case 79: {
                int n = this.param[0];
                if (n == -1) {
                    n = 1;
                }
                this.term.doTabs(n);
                this.parseState = groundTable;
                break;
            }
            case 80: {
                int n = this.param[0];
                if (n == -1) {
                    n = 1;
                }
                this.term.scrollUp(n);
                this.parseState = groundTable;
                break;
            }
            case 81: {
                int n = this.param[0];
                if (n == -1) {
                    n = 1;
                }
                this.term.scrollDown(n);
                this.parseState = groundTable;
                break;
            }
            case 82: {
                int n = this.param[0];
                if (n == -1) {
                    n = 1;
                }
                this.term.eraseChars(n);
                this.parseState = groundTable;
                break;
            }
            case 83: {
                int n = this.param[0];
                if (n == -1) {
                    n = 1;
                }
                this.term.doBackTabs(n);
                this.parseState = groundTable;
                break;
            }
            case 78: 
            case 84: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorSetPos(this.term.getCursorV(), n - 1, false);
                this.parseState = groundTable;
                break;
            }
            case 85: {
                this.parseState = groundTable;
                break;
            }
            case 86: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorSetPos(n - 1, this.term.getCursorH(), false);
                this.parseState = groundTable;
                break;
            }
            case 87: {
                int n = this.param[0];
                if (n == -1) {
                    n = 0;
                }
                this.ansiPrinterCtrl(n);
                this.parseState = groundTable;
                break;
            }
        }
        return -1;
    }

    protected void ansiModes(boolean bl) {
        block6: for (int i = 0; i < this.nparam; ++i) {
            switch (this.param[i]) {
                case 2: {
                    continue block6;
                }
                case 4: {
                    this.term.setOption(3, bl);
                    continue block6;
                }
                case 12: {
                    continue block6;
                }
                case 20: {
                    this.term.setOption(4, bl);
                    continue block6;
                }
            }
        }
    }

    protected void sgrModes() {
        block20: for (int i = 0; i < this.nparam; ++i) {
            switch (this.param[i]) {
                case -1: 
                case 0: {
                    this.term.clearAllAttributes();
                    continue block20;
                }
                case 1: 
                case 5: {
                    this.term.setAttribute(1, true);
                    continue block20;
                }
                case 4: {
                    this.term.setAttribute(4, true);
                    continue block20;
                }
                case 7: {
                    this.term.setAttribute(16, true);
                    continue block20;
                }
                case 8: {
                    continue block20;
                }
                case 22: {
                    this.term.setAttribute(1, false);
                    continue block20;
                }
                case 24: {
                    this.term.setAttribute(4, false);
                    continue block20;
                }
                case 25: {
                    this.term.setAttribute(1, false);
                    continue block20;
                }
                case 27: {
                    this.term.setAttribute(16, false);
                    continue block20;
                }
                case 28: {
                    continue block20;
                }
                case 10: {
                    this.gSets[this.scsType] = 66;
                    continue block20;
                }
                case 11: 
                case 12: {
                    this.gSets[this.scsType] = 48;
                    continue block20;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.term.setForegroundColor(this.param[i] - 30);
                    continue block20;
                }
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    this.term.setForegroundColor(this.param[i] - 90);
                    continue block20;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this.term.setBackgroundColor(this.param[i] - 40);
                    continue block20;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.term.setBackgroundColor(this.param[i] - 100);
                    continue block20;
                }
                case 39: {
                    this.term.setForegroundColor(-1);
                    continue block20;
                }
                case 49: {
                    this.term.setBackgroundColor(-1);
                    continue block20;
                }
            }
        }
    }

    protected void dpModes(boolean bl) {
        block29: for (int i = 0; i < this.nparam; ++i) {
            switch (this.param[i]) {
                case 1: {
                    this.cursorKeysMode = bl;
                    continue block29;
                }
                case 2: {
                    if (!bl) continue block29;
                    this.resetGSets();
                    continue block29;
                }
                case 3: {
                    this.term.setOption(11, bl);
                    continue block29;
                }
                case 4: {
                    continue block29;
                }
                case 5: {
                    this.term.setOption(0, bl);
                    continue block29;
                }
                case 6: {
                    this.windowRelative = bl;
                    continue block29;
                }
                case 7: {
                    this.term.setOption(1, bl);
                    continue block29;
                }
                case 8: {
                    continue block29;
                }
                case 9: {
                    if (bl) {
                        this.sendMousePos = 1;
                        continue block29;
                    }
                    this.sendMousePos = 0;
                    continue block29;
                }
                case 18: {
                    continue block29;
                }
                case 19: {
                    continue block29;
                }
                case 25: {
                    this.term.setOption(7, bl);
                    continue block29;
                }
                case 38: {
                    continue block29;
                }
                case 40: {
                    this.term.setOption(12, bl);
                    continue block29;
                }
                case 41: {
                    continue block29;
                }
                case 42: {
                    continue block29;
                }
                case 44: {
                    continue block29;
                }
                case 45: {
                    this.term.setOption(2, bl);
                    continue block29;
                }
                case 46: {
                    continue block29;
                }
                case 67: {
                    continue block29;
                }
                case 1000: {
                    if (bl) {
                        this.sendMousePos = 2;
                        continue block29;
                    }
                    this.sendMousePos = 0;
                    continue block29;
                }
                case 1001: {
                    if (bl) {
                        this.sendMousePos = 3;
                        continue block29;
                    }
                    this.sendMousePos = 0;
                    continue block29;
                }
                case 1002: {
                    continue block29;
                }
                case 1003: {
                    continue block29;
                }
                case 47: 
                case 1047: {
                    this.curGLDECSC = this.curGL;
                    System.arraycopy(this.gSets, 0, this.gSetsDECSC, 0, 4);
                    this.vtReset();
                    continue block29;
                }
                case 1048: {
                    this.term.cursorSave();
                    this.curGLDECSC = this.curGL;
                    System.arraycopy(this.gSets, 0, this.gSetsDECSC, 0, 4);
                    continue block29;
                }
                case 1049: {
                    this.term.cursorSave();
                    this.curGLDECSC = this.curGL;
                    System.arraycopy(this.gSets, 0, this.gSetsDECSC, 0, 4);
                    this.vtReset();
                    continue block29;
                }
            }
        }
    }

    protected void xtermModes() {
        switch (this.param[0]) {
            case 0: 
            case 1: 
            case 2: {
                this.term.setTitle(this.xtermSeq);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 20: {
                break;
            }
            case 39: {
                break;
            }
            case 49: {
                break;
            }
            case 46: {
                break;
            }
            case 50: {
                break;
            }
        }
    }

    protected void xtermWinCtrl() {
        block16: for (int i = 0; i < this.nparam; ++i) {
            switch (this.param[i]) {
                case 1: {
                    continue block16;
                }
                case 2: {
                    continue block16;
                }
                case 3: {
                    continue block16;
                }
                case 4: {
                    continue block16;
                }
                case 5: {
                    continue block16;
                }
                case 6: {
                    continue block16;
                }
                case 7: {
                    continue block16;
                }
                case 8: {
                    continue block16;
                }
                case 11: {
                    continue block16;
                }
                case 13: {
                    continue block16;
                }
                case 14: {
                    continue block16;
                }
                case 18: {
                    continue block16;
                }
                case 20: {
                    continue block16;
                }
                case 21: {
                    continue block16;
                }
            }
        }
    }

    protected void xtermSavemodes() {
    }

    protected void xtermRestoremodes() {
    }

    protected void ansiPrinterCtrl(int n) {
        switch (n) {
            case 0: {
                this.term.printScreen();
                break;
            }
            case 4: {
                this.term.stopPrinter();
                break;
            }
            case 5: {
                this.term.startPrinter();
                break;
            }
        }
    }

    protected final void resetGSets() {
        this.gSets[0] = 66;
        this.gSets[1] = 48;
        this.gSets[2] = 66;
        this.gSets[3] = 66;
        this.curGL = 0;
        this.curGR = -1;
    }

    public void vtReset() {
        this.resetGSets();
        this.curSS = 0;
        this.parseState = groundTable;
        this.windowRelative = false;
        this.keypadAppl = false;
        this.cursorKeysMode = false;
        this.sendMousePos = 0;
        if (this.term != null) {
            this.term.resetWindow();
            this.term.clearScreen();
            this.term.cursorSetPos(0, 0, false);
            this.term.resetTabs();
        }
    }

    protected void notImplemented(String string) {
        System.out.println("not implemented: " + string);
    }

    final int mapVKToXVK(int n) {
        int n2;
        for (n2 = 0; n2 < 35 && this.vk2xvk[n2] != n; ++n2) {
        }
        return n2;
    }

    public final int mapModToTab(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 = 1;
        }
        if ((n & 2) != 0) {
            n2 += 2;
        }
        return n2;
    }

    public final String mapSpecialKeys(int n, int n2) {
        int n3 = this.mapVKToXVK(n);
        int n4 = this.mapModToTab(n2);
        String[][] stringArray = theSpecialKeyMaps[n4];
        return stringArray[n3][this.whoAmIReally];
    }

    public void keyHandler(char c, int n, int n2) {
        String string = null;
        String string2 = "";
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string2 = this.cursorKeysMode ? replyTypes[2] : replyTypes[4];
                string = this.mapSpecialKeys(n, n2);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                if (this.term.getOption(14)) break;
                string2 = replyTypes[4];
                string = this.mapSpecialKeys(n, n2);
                break;
            }
            case 155: {
                string2 = replyTypes[4];
                string = this.mapSpecialKeys(n, n2);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                string2 = this.whoAmIReally == 7 || this.whoAmIReally == 8 || this.whoAmIReally == 3 ? replyTypes[2] : (this.whoAmIReally == 6 ? (n > 115 ? replyTypes[4] : replyTypes[2]) : (this.whoAmIReally == 9 ? replyTypes[0] : replyTypes[4]));
                string = this.mapSpecialKeys(n, n2);
                break;
            }
        }
        if (string != null && !this.dumbMode) {
            string = string2 + string;
            this.term.sendBytes(string.getBytes());
        }
        if (c == '\uffff') {
            return;
        }
        if (this.dumbMode && Character.isISOControl(c) && c != '\u0003' && c != '\u0004' && c != '\b' && c != '\r' && c != '\u007f') {
            return;
        }
        if ((n2 & 2) == 0 && (n2 & 8) != 0) {
            this.term.typedChar('\u001b');
        }
        if ((c == '\n' || c == '\r') && this.term.getOption(4)) {
            this.term.typedChar('\r');
            c = (char)10;
        }
        this.term.typedChar(c);
    }

    int xButton(int n) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 = 0;
        } else if ((n & 8) != 0) {
            n2 = 1;
        } else if ((n & 4) != 0) {
            n2 = 2;
        }
        return n2;
    }

    int xKeyState(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 8) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 4;
        }
        return n2 << 2;
    }

    public void mouseHandler(int n, int n2, boolean bl, int n3) {
        switch (this.sendMousePos) {
            case 0: {
                break;
            }
            case 1: {
                if (!bl) break;
                this.term.sendBytes(("\u001b[M" + (char)(32 + this.xButton(n3)) + (char)(32 + n2 + 1) + (char)(32 + n + 1)).getBytes());
                break;
            }
            case 2: {
                this.term.sendBytes(("\u001b[M" + (char)(32 + (bl ? this.xButton(n3) | this.xKeyState(n3) : 3)) + (char)(32 + n2 + 1) + (char)(32 + n + 1)).getBytes());
                break;
            }
        }
    }
}

