/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.GUI;
import com.mindbright.terminal.GlobalClipboard;
import com.mindbright.terminal.SearchContext;
import com.mindbright.terminal.TerminalCapture;
import com.mindbright.terminal.TerminalMenuHandler;
import com.mindbright.terminal.TerminalMenuListener;
import com.mindbright.terminal.TerminalPrinter;
import com.mindbright.terminal.TerminalWin;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class TerminalMenuHandlerFull
extends TerminalMenuHandler
implements ActionListener,
ItemListener,
TerminalPrinter {
    protected TerminalWin term;
    protected String titleName;
    private TerminalMenuListener listener;
    public static final int MENU_FILE = 0;
    public static final int MENU_EDIT = 1;
    public static final int MENU_SETTINGS = 2;
    static final int M_FILE_CAPTURE = 1;
    static final int M_FILE_SEND = 2;
    static final int M_FILE_CLOSE = 4;
    static final int M_SET_TERM = 1;
    static final int M_EDIT_COPY = 1;
    static final int M_EDIT_PASTE = 2;
    static final int M_EDIT_CPPASTE = 3;
    static final int M_EDIT_SELALL = 4;
    static final int M_EDIT_FIND = 5;
    static final int M_EDIT_CLS = 7;
    static final int M_EDIT_CLEARSB = 8;
    static final int M_EDIT_VTRESET = 9;
    protected static final String[][] menuTexts = new String[][]{{"File", "_Capture To File...", "Send ASCII File...", null, "Close"}, {"Edit", "Copy Ctrl+Ins", "Paste Shift+Ins", "Copy & Paste", "Select All", "Find...", null, "Clear Screen", "Clear Scrollback", "VT Reset"}, {"Settings", "Terminal..."}};
    protected static final int NO_SHORTCUT = -1;
    protected static final int[][] menuShortCuts = new int[][]{{-1, -1, -1, -1, 69}, {-1, -1, -1, -1, 65, 70, -1, -1, -1, -1}, {-1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    protected static final String[] PASTE_BUTTON = new String[]{"middle", "right", "shift+left"};
    protected static final String[] SCROLLBAR_POS = new String[]{"left", "right", "none"};
    protected static final String[] TERMINAL_TYPES = TerminalWin.getTerminalTypes();
    protected static final String[] FONT_LIST = GUI.getFontList();
    protected static final String[] ENCODINGS = new String[]{"iso-8859-1", "utf-8", "euc-jp", "euc-kr", "us-ascii"};
    protected static final String LBL_TERMINAL_TYPE = "Terminal type";
    protected static final String LBL_COLUMNS = "Columns";
    protected static final String LBL_ROWS = "Rows";
    protected static final String LBL_FONT = "Font";
    protected static final String LBL_ENCODING = "Encoding";
    protected static final String LBL_SIZE = "Size";
    protected static final String LBL_SCROLLBACK_BUFFER = "Scrollback buffer";
    protected static final String LBL_SCROLLBAR_POS = "Scrollbar position";
    protected static final String LBL_FG_COLOR = "Foreground color";
    protected static final String LBL_BG_COLOR = "Background color";
    protected static final String LBL_CURS_COLOR = "Cursor color";
    protected static final String LBL_PASTE_BUTTON = "Paste button";
    protected static final String LBL_SELECT_DELIM = "Select delim.";
    protected static final String LBL_TAB_GENERAL = "General";
    protected static final String LBL_TAB_MISC = "Misc";
    protected static final String LBL_TAB_COLORS = "Colors";
    protected static final String LBL_TAB_VTOPTIONS1 = "VT 1";
    protected static final String LBL_TAB_VTOPTIONS2 = "VT 2";
    protected static final String LBL_CUSTOM_RGB = "custom rgb";
    protected static final String LBL_FIND = "Find";
    protected static final String LBL_CASE_SENSITIVE = "Case sensitive";
    protected static final String LBL_FIND_BACKWARDS = "Find backwards";
    protected static final String LBL_BTN_OK = "OK";
    protected static final String LBL_BTN_CANCEL = "Cancel";
    protected static final String LBL_BTN_FIND = "Find";
    protected SearchContext lastSearch;
    private TerminalCapture termCapture;
    protected Object[][] menuItems;
    protected FileOutputStream printerOut;

    protected void setProperty(String string, String string2) {
        try {
            this.term.setProperty(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.showAlert("Failed to set property", illegalArgumentException.getMessage(), this.term.ownerFrame);
        }
    }

    protected String getProperty(String string) {
        return this.term.getProperty(string);
    }

    protected TerminalMenuHandlerFull() {
        this("MindTerm");
    }

    protected TerminalMenuHandlerFull(String string) {
        this.setTitleName(string);
    }

    public static TerminalMenuHandler getInstance(Frame frame) {
        try {
            Class<?> clazz = Class.forName(AWTConvenience.isSwingJFrame(frame) ? "com.mindbright.terminal.TerminalMenuHandlerFullSwing" : "com.mindbright.terminal.TerminalMenuHandlerFullAWT");
            return (TerminalMenuHandler)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setTitleName(String string) {
        this.titleName = string;
    }

    public void setTerminalWin(TerminalWin terminalWin) {
        this.term = terminalWin;
        terminalWin.attachPrinter(this);
    }

    public void setTerminalMenuListener(TerminalMenuListener terminalMenuListener) {
        this.listener = terminalMenuListener;
    }

    public void addBasicMenus(TerminalWin terminalWin, Frame frame) {
        this.setTerminalWin(terminalWin);
        this.addBasicMenusInternal(frame);
        terminalWin.setMenus(this);
        terminalWin.setClipboard(GlobalClipboard.getClipboardHandler(this));
        terminalWin.updateMenus();
    }

    public void updateSelection(boolean bl) {
        this.setEnabled(1, 1, bl);
        this.setEnabled(1, 3, bl);
    }

    public void update() {
        if (this.listener != null) {
            this.listener.update();
        }
    }

    public abstract void termSettingsDialog(String var1);

    public void termSettingsDialog() {
        this.termSettingsDialog("Terminal Settings");
    }

    public abstract void findDialog(String var1);

    protected void doFind(String string, boolean bl, boolean bl2) {
        this.lastSearch = this.term.search(this.lastSearch, string, bl2, bl);
        if (this.lastSearch == null) {
            this.term.ringBell();
        }
    }

    public final void sendFileDialog() {
        File file = GUI.selectFile(this.term.ownerFrame, this.titleName + " - Select ASCII-file to send", false);
        if (file == null) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            this.term.sendBytes(byArray);
        }
        catch (Throwable throwable) {
            GUI.showAlert(this.titleName + " - Alert", throwable.getMessage(), this.term.ownerFrame);
        }
    }

    public final FileOutputStream chooseFileDialog(String string) {
        File file = GUI.selectFile(this.term.ownerFrame, this.titleName + " - " + string, true);
        if (file == null) {
            return null;
        }
        try {
            boolean bl = false;
            if (file.exists()) {
                bl = GUI.showConfirm(this.titleName + " - File exists", "File exists, overwrite or append?", 0, 0, "Append", "Overwrite", true, this.term.ownerFrame, false, false);
            }
            return new FileOutputStream(file.getCanonicalPath(), bl);
        }
        catch (Throwable throwable) {
            GUI.showAlert(this.titleName + " - Alert", throwable.getMessage(), this.term.ownerFrame);
            return null;
        }
    }

    public final boolean captureToFileDialog() {
        FileOutputStream fileOutputStream = this.chooseFileDialog("Select file to capture to");
        if (fileOutputStream != null) {
            this.termCapture = new TerminalCapture(fileOutputStream);
            this.termCapture.startCapture(this.term);
            return true;
        }
        return false;
    }

    public void endCapture() {
        if (this.termCapture != null) {
            this.termCapture.endCapture();
            try {
                this.termCapture.getTarget().close();
            }
            catch (IOException iOException) {
                GUI.showAlert(this.titleName + " - Alert", iOException.getMessage(), this.term.ownerFrame);
            }
        }
    }

    protected abstract void setEnabled(int var1, int var2, boolean var3);

    protected abstract void setState(int var1, int var2, boolean var3);

    protected abstract boolean getState(int var1, int var2);

    protected abstract void addBasicMenusInternal(Frame var1);

    public abstract Object getMenu(int var1);

    private int[] mapAction(Object object) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        for (n = 0; n < this.menuItems.length; ++n) {
            for (n2 = 1; this.menuItems[n] != null && n2 < this.menuItems[n].length; ++n2) {
                if (this.menuItems[n][n2] != object) continue;
                nArray[0] = n;
                nArray[1] = n2;
                return nArray;
            }
        }
        return nArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleMenuAction(this.mapAction(actionEvent.getSource()));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.handleMenuAction(this.mapAction(itemEvent.getSource()));
    }

    public void handleMenuAction(int[] nArray) {
        switch (nArray[0]) {
            case 0: {
                switch (nArray[1]) {
                    case 1: {
                        if (this.getState(0, 1)) {
                            if (this.captureToFileDialog()) break;
                            this.setState(0, 1, false);
                            break;
                        }
                        this.endCapture();
                        break;
                    }
                    case 2: {
                        this.sendFileDialog();
                        break;
                    }
                    case 4: {
                        if (this.listener == null) break;
                        this.listener.close(this);
                    }
                }
                break;
            }
            case 1: {
                switch (nArray[1]) {
                    case 1: {
                        this.term.doCopy();
                        break;
                    }
                    case 2: {
                        this.term.doPaste();
                        break;
                    }
                    case 3: {
                        this.term.doCopy();
                        this.term.doPaste();
                        break;
                    }
                    case 4: {
                        this.term.selectAll();
                        break;
                    }
                    case 5: {
                        this.findDialog(this.titleName + " - Find");
                        break;
                    }
                    case 7: {
                        this.term.clearScreen();
                        this.term.setCursorPos(0, 0);
                        break;
                    }
                    case 8: {
                        this.term.clearSaveLines();
                        break;
                    }
                    case 9: {
                        this.term.reset();
                    }
                }
                break;
            }
            case 2: {
                switch (nArray[1]) {
                    case 1: {
                        this.termSettingsDialog();
                    }
                }
            }
        }
    }

    public void write(char c) {
        if (this.printerOut != null) {
            try {
                this.printerOut.write(c);
            }
            catch (IOException iOException) {
                GUI.showAlert(this.titleName + " - Alert", iOException.getMessage(), this.term.ownerFrame);
            }
        }
    }

    public void printScreen() {
    }

    public void startPrinter() {
        this.printerOut = this.chooseFileDialog("Passthrough print to file");
    }

    public void stopPrinter() {
        if (this.printerOut != null) {
            try {
                this.printerOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.printerOut = null;
            GUI.showAlert(this.titleName + " - Alert", "Passthrough printing ended, file saved.", this.term.ownerFrame);
        }
    }
}

