/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2TCPChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class SSH2TelnetProxyListener
implements Runnable {
    private static final int LISTEN_QUEUE_SIZE = 32;
    private SSH2Connection connection;
    private ServerSocket listenSocket;
    private String localAddr;
    private int localPort;
    private String prompt;
    private volatile boolean keepListening;

    public SSH2TelnetProxyListener(String string, int n, SSH2Connection sSH2Connection) throws IOException {
        this(string, n, sSH2Connection, "\r\nremote host[:port] : ");
    }

    public SSH2TelnetProxyListener(String string, int n, SSH2Connection sSH2Connection, String string2) throws IOException {
        this.localAddr = string;
        this.localPort = n;
        this.connection = sSH2Connection;
        this.prompt = string2;
        this.listenSocket = new ServerSocket(n, 32, InetAddress.getByName(string));
        this.keepListening = true;
        Thread thread = new Thread((Runnable)this, "SSHTelnetPrompt2Listener_" + string + ":" + n);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block17: {
            while (this.keepListening) {
                Socket socket = null;
                try {
                    socket = this.listenSocket.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.keepListening) continue;
                }
                if (!this.keepListening) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(this.prompt.getBytes());
                String string = this.readLine(inputStream).trim();
                int n = 23;
                int n2 = string.indexOf(58);
                if (n2 != -1) {
                    n = this.getPort(string.substring(n2 + 1));
                    string = string.substring(0, n2);
                }
                InetAddress inetAddress = socket.getInetAddress();
                int n3 = socket.getPort();
                SSH2TCPChannel sSH2TCPChannel = new SSH2TCPChannel(1, this.connection, this, socket, string, n, inetAddress.getHostName(), n3);
                this.connection.connectLocalChannel(sSH2TCPChannel, string, n, inetAddress.getHostAddress(), n3);
            }
            Object var11_13 = null;
            try {
                this.listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listenSocket = null;
            this.connection.getLog().debug("SSH2TelnetProxyListener", "stopping listener on " + this.localAddr + ":" + this.localPort);
            {
                break block17;
                catch (IOException iOException) {
                    if (this.keepListening) {
                        this.connection.getLog().error("SSH2TelnetProxyListener", "run", "Error in accept for listener " + this.localAddr + ":" + this.localPort + " : " + iOException.getMessage());
                    }
                    Object var11_14 = null;
                    try {
                        this.listenSocket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.listenSocket = null;
                    this.connection.getLog().debug("SSH2TelnetProxyListener", "stopping listener on " + this.localAddr + ":" + this.localPort);
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    this.listenSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.listenSocket = null;
                this.connection.getLog().debug("SSH2TelnetProxyListener", "stopping listener on " + this.localAddr + ":" + this.localPort);
                throw throwable;
            }
        }
    }

    private int getPort(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 23;
        }
        return n;
    }

    private String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                throw new IOException("Client closed connection");
            }
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return new String(stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.keepListening = false;
        if (this.listenSocket != null) {
            Socket socket = null;
            try {
                socket = new Socket(this.listenSocket.getInetAddress(), this.listenSocket.getLocalPort());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

