/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.mac;

import com.mindbright.jca.security.DigestException;
import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.MacSpi;
import com.mindbright.jce.crypto.spec.SecretKeySpec;

public class HMAC
extends MacSpi {
    protected int macLength;
    protected int hashLength;
    protected int blockSize;
    protected byte[] k_ipad;
    protected byte[] k_opad;
    protected byte[] innerHash;
    protected byte[] outerHash;
    protected MessageDigest inner;
    protected MessageDigest outer;
    protected MessageDigest innerClone;
    protected MessageDigest outerClone;

    protected HMAC(String string) {
        try {
            this.inner = MessageDigest.getInstance(string);
            this.outer = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new Error("Error in HMAC: " + exception);
        }
        this.macLength = this.inner.getDigestLength();
        this.blockSize = 64;
        this.hashLength = this.macLength;
        this.innerHash = new byte[this.hashLength];
        this.outerHash = new byte[this.hashLength];
        this.k_ipad = new byte[this.blockSize];
        this.k_opad = new byte[this.blockSize];
    }

    private final void init(byte[] byArray) {
        this.inner.reset();
        this.outer.reset();
        int n = byArray.length;
        if (n > this.blockSize) {
            this.inner.update(byArray);
            byArray = this.inner.digest();
            this.inner.reset();
            n = this.blockSize;
        }
        System.arraycopy(byArray, 0, this.k_ipad, 0, n);
        System.arraycopy(byArray, 0, this.k_opad, 0, n);
        int n2 = 0;
        while (n2 < this.blockSize) {
            int n3 = n2;
            this.k_ipad[n3] = (byte)(this.k_ipad[n3] ^ 0x36);
            int n4 = n2++;
            this.k_opad[n4] = (byte)(this.k_opad[n4] ^ 0x5C);
        }
        this.updatePads();
        if (this.inner instanceof Cloneable) {
            try {
                this.innerClone = (MessageDigest)this.inner.clone();
                this.outerClone = (MessageDigest)this.outer.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.innerClone = null;
                this.outerClone = null;
            }
        }
    }

    protected final byte[] engineDoFinal() {
        try {
            this.inner.digest(this.innerHash, 0, this.hashLength);
            this.outer.update(this.innerHash, 0, this.hashLength);
            this.outer.digest(this.outerHash, 0, this.hashLength);
        }
        catch (DigestException digestException) {
            throw new Error("Error/bug in HMAC, buffer too short");
        }
        byte[] byArray = new byte[this.macLength];
        System.arraycopy(this.outerHash, 0, byArray, 0, this.macLength);
        this.updatePads();
        return byArray;
    }

    protected final int engineGetMacLength() {
        return this.macLength;
    }

    protected final void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(((SecretKeySpec)key).getEncoded());
    }

    protected final void engineReset() {
        this.updatePads();
    }

    protected final void engineUpdate(byte by) {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n, int n2) {
        this.inner.update(byArray, n, n2);
    }

    private final void updatePads() {
        if (this.innerClone != null) {
            try {
                this.inner = (MessageDigest)this.innerClone.clone();
                this.outer = (MessageDigest)this.outerClone.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.innerClone = null;
                this.outerClone = null;
                this.updatePads();
            }
        } else {
            this.inner.reset();
            this.outer.reset();
            this.inner.update(this.k_ipad);
            this.outer.update(this.k_opad);
        }
    }
}

