/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TFloatHashSet;
import gnu.trove.TFloatIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TFloatHashSetDecorator
extends AbstractSet
implements Set,
Cloneable {
    protected TFloatHashSet _set;

    public TFloatHashSetDecorator(TFloatHashSet tFloatHashSet) {
        this._set = tFloatHashSet;
    }

    public Object clone() {
        try {
            TFloatHashSetDecorator tFloatHashSetDecorator = (TFloatHashSetDecorator)super.clone();
            tFloatHashSetDecorator._set = (TFloatHashSet)this._set.clone();
            return tFloatHashSetDecorator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean add(Object object) {
        return this._set.add(this.unwrap(object));
    }

    public boolean equals(Object object) {
        if (this._set.equals(object)) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (set.size() != this._set.size()) {
                return false;
            }
            Iterator iterator = set.iterator();
            int n = set.size();
            while (n-- > 0) {
                Object e = iterator.next();
                if (e instanceof Float) {
                    float f = this.unwrap(e);
                    if (this._set.contains(f)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object object) {
        return this._set.remove(this.unwrap(object));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TFloatIterator it;
            {
                this.it = TFloatHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TFloatHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Float wrap(float f) {
        return new Float(f);
    }

    protected float unwrap(Object object) {
        return ((Float)object).floatValue();
    }
}

