/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongObjectIterator;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongObjectHashMap
extends TLongHash
implements Serializable {
    protected transient Object[] _values;

    public TLongObjectHashMap() {
    }

    public TLongObjectHashMap(int n) {
        super(n);
    }

    public TLongObjectHashMap(int n, float f) {
        super(n, f);
    }

    public TLongObjectHashMap(TLongHashingStrategy tLongHashingStrategy) {
        super(tLongHashingStrategy);
    }

    public TLongObjectHashMap(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n, tLongHashingStrategy);
    }

    public TLongObjectHashMap(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f, tLongHashingStrategy);
    }

    public Object clone() {
        TLongObjectHashMap tLongObjectHashMap = (TLongObjectHashMap)super.clone();
        tLongObjectHashMap._values = (Object[])this._values.clone();
        return tLongObjectHashMap;
    }

    public TLongObjectIterator iterator() {
        return new TLongObjectIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(long l, Object object) {
        Object object2 = null;
        int n = this.insertionIndex(l);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = l;
        this._states[n] = 1;
        this._values[n] = object;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return object2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertionIndex(l);
            this._set[n4] = l;
            this._values[n4] = objectArray[n3];
            this._states[n4] = 1;
        }
    }

    public Object get(long l) {
        int n = this.index(l);
        return n < 0 ? null : this._values[n];
    }

    public void clear() {
        super.clear();
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = 0L;
            objectArray[n] = null;
            byArray[n] = 0;
        }
    }

    public Object remove(long l) {
        Object object = null;
        int n = this.index(l);
        if (n >= 0) {
            object = this._values[n];
            this.removeAt(n);
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLongObjectHashMap)) {
            return false;
        }
        TLongObjectHashMap tLongObjectHashMap = (TLongObjectHashMap)object;
        if (tLongObjectHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tLongObjectHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = null;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public long[] keys() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        if (null == object) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n]) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && !object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.contains(l);
    }

    public boolean forEachKey(TLongProcedure tLongProcedure) {
        return this.forEach(tLongProcedure);
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongObjectProcedure tLongObjectProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongObjectProcedure.execute(lArray[n], objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TLongObjectProcedure tLongObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        long[] lArray = this._set;
        Object[] objectArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongObjectProcedure.execute(lArray[n], objectArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TObjectFunction tObjectFunction) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInputStream.readLong();
            Object object = objectInputStream.readObject();
            this.put(l, object);
        }
    }

    private static final class EqProcedure
    implements TLongObjectProcedure {
        private final TLongObjectHashMap _otherMap;

        EqProcedure(TLongObjectHashMap tLongObjectHashMap) {
            this._otherMap = tLongObjectHashMap;
        }

        public final boolean execute(long l, Object object) {
            int n = this._otherMap.index(l);
            return n >= 0 && this.eq(object, this._otherMap.get(l));
        }

        private final boolean eq(Object object, Object object2) {
            return object == object2 || object != null && object.equals(object2);
        }
    }

    private final class HashProcedure
    implements TLongObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long l, Object object) {
            this.h += TLongObjectHashMap.this._hashingStrategy.computeHashCode(l) ^ HashFunctions.hash(object);
            return true;
        }
    }
}

