/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TLongDoubleIterator;
import gnu.trove.TLongDoubleProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongDoubleHashMap
extends TLongHash
implements Serializable {
    protected transient double[] _values;

    public TLongDoubleHashMap() {
    }

    public TLongDoubleHashMap(int n) {
        super(n);
    }

    public TLongDoubleHashMap(int n, float f) {
        super(n, f);
    }

    public TLongDoubleHashMap(TLongHashingStrategy tLongHashingStrategy) {
        super(tLongHashingStrategy);
    }

    public TLongDoubleHashMap(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n, tLongHashingStrategy);
    }

    public TLongDoubleHashMap(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f, tLongHashingStrategy);
    }

    public Object clone() {
        TLongDoubleHashMap tLongDoubleHashMap = (TLongDoubleHashMap)super.clone();
        tLongDoubleHashMap._values = (double[])this._values.clone();
        return tLongDoubleHashMap;
    }

    public TLongDoubleIterator iterator() {
        return new TLongDoubleIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new double[n2];
        return n2;
    }

    public double put(long l, double d) {
        double d2 = 0.0;
        int n = this.insertionIndex(l);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            d2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = l;
        this._states[n] = 1;
        this._values[n] = d;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return d2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        double[] dArray = this._values;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._values = new double[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertionIndex(l);
            this._set[n4] = l;
            this._values[n4] = dArray[n3];
            this._states[n4] = 1;
        }
    }

    public double get(long l) {
        int n = this.index(l);
        return n < 0 ? 0.0 : this._values[n];
    }

    public void clear() {
        super.clear();
        long[] lArray = this._set;
        double[] dArray = this._values;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = 0L;
            dArray[n] = 0.0;
            byArray[n] = 0;
        }
    }

    public double remove(long l) {
        double d = 0.0;
        int n = this.index(l);
        if (n >= 0) {
            d = this._values[n];
            this.removeAt(n);
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLongDoubleHashMap)) {
            return false;
        }
        TLongDoubleHashMap tLongDoubleHashMap = (TLongDoubleHashMap)object;
        if (tLongDoubleHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tLongDoubleHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0;
    }

    public double[] getValues() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._values;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public long[] keys() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public boolean containsValue(double d) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || d != dArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.contains(l);
    }

    public boolean forEachKey(TLongProcedure tLongProcedure) {
        return this.forEach(tLongProcedure);
    }

    public boolean forEachValue(TDoubleProcedure tDoubleProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleProcedure.execute(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongDoubleProcedure tLongDoubleProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        double[] dArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongDoubleProcedure.execute(lArray[n], dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TLongDoubleProcedure tLongDoubleProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        long[] lArray = this._set;
        double[] dArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongDoubleProcedure.execute(lArray[n], dArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n] = tDoubleFunction.execute(dArray[n]);
        }
    }

    public boolean increment(long l) {
        return this.adjustValue(l, 1.0);
    }

    public boolean adjustValue(long l, double d) {
        int n = this.index(l);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + d;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInputStream.readLong();
            double d = objectInputStream.readDouble();
            this.put(l, d);
        }
    }

    private static final class EqProcedure
    implements TLongDoubleProcedure {
        private final TLongDoubleHashMap _otherMap;

        EqProcedure(TLongDoubleHashMap tLongDoubleHashMap) {
            this._otherMap = tLongDoubleHashMap;
        }

        public final boolean execute(long l, double d) {
            int n = this._otherMap.index(l);
            return n >= 0 && this.eq(d, this._otherMap.get(l));
        }

        private final boolean eq(double d, double d2) {
            return d == d2;
        }
    }

    private final class HashProcedure
    implements TLongDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long l, double d) {
            this.h += TLongDoubleHashMap.this._hashingStrategy.computeHashCode(l) ^ HashFunctions.hash(d);
            return true;
        }
    }
}

