/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleIntIterator;
import gnu.trove.TDoubleIntProcedure;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TDoubleIntHashMap
extends TDoubleHash
implements Serializable {
    protected transient int[] _values;

    public TDoubleIntHashMap() {
    }

    public TDoubleIntHashMap(int n) {
        super(n);
    }

    public TDoubleIntHashMap(int n, float f) {
        super(n, f);
    }

    public TDoubleIntHashMap(TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(tDoubleHashingStrategy);
    }

    public TDoubleIntHashMap(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, tDoubleHashingStrategy);
    }

    public TDoubleIntHashMap(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f, tDoubleHashingStrategy);
    }

    public Object clone() {
        TDoubleIntHashMap tDoubleIntHashMap = (TDoubleIntHashMap)super.clone();
        tDoubleIntHashMap._values = (int[])this._values.clone();
        return tDoubleIntHashMap;
    }

    public TDoubleIntIterator iterator() {
        return new TDoubleIntIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new int[n2];
        return n2;
    }

    public int put(double d, int n) {
        int n2 = 0;
        int n3 = this.insertionIndex(d);
        boolean bl = true;
        if (n3 < 0) {
            n3 = -n3 - 1;
            n2 = this._values[n3];
            bl = false;
        }
        byte by = this._states[n3];
        this._set[n3] = d;
        this._states[n3] = 1;
        this._values[n3] = n;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return n2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        int[] nArray = this._values;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._values = new int[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.insertionIndex(d);
            this._set[n4] = d;
            this._values[n4] = nArray[n3];
            this._states[n4] = 1;
        }
    }

    public int get(double d) {
        int n = this.index(d);
        return n < 0 ? 0 : this._values[n];
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        int[] nArray = this._values;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = 0.0;
            nArray[n] = 0;
            byArray[n] = 0;
        }
    }

    public int remove(double d) {
        int n = 0;
        int n2 = this.index(d);
        if (n2 >= 0) {
            n = this._values[n2];
            this.removeAt(n2);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleIntHashMap)) {
            return false;
        }
        TDoubleIntHashMap tDoubleIntHashMap = (TDoubleIntHashMap)object;
        if (tDoubleIntHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tDoubleIntHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public double[] keys() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public boolean containsValue(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(double d) {
        return this.contains(d);
    }

    public boolean forEachKey(TDoubleProcedure tDoubleProcedure) {
        return this.forEach(tDoubleProcedure);
    }

    public boolean forEachValue(TIntProcedure tIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TDoubleIntProcedure tDoubleIntProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        int[] nArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleIntProcedure.execute(dArray[n], nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TDoubleIntProcedure tDoubleIntProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        double[] dArray = this._set;
        int[] nArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleIntProcedure.execute(dArray[n], nArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TIntFunction tIntFunction) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n] = tIntFunction.execute(nArray[n]);
        }
    }

    public boolean increment(double d) {
        return this.adjustValue(d, 1);
    }

    public boolean adjustValue(double d, int n) {
        int n2 = this.index(d);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + n;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInputStream.readDouble();
            int n2 = objectInputStream.readInt();
            this.put(d, n2);
        }
    }

    private static final class EqProcedure
    implements TDoubleIntProcedure {
        private final TDoubleIntHashMap _otherMap;

        EqProcedure(TDoubleIntHashMap tDoubleIntHashMap) {
            this._otherMap = tDoubleIntHashMap;
        }

        public final boolean execute(double d, int n) {
            int n2 = this._otherMap.index(d);
            return n2 >= 0 && this.eq(n, this._otherMap.get(d));
        }

        private final boolean eq(int n, int n2) {
            return n == n2;
        }
    }

    private final class HashProcedure
    implements TDoubleIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double d, int n) {
            this.h += TDoubleIntHashMap.this._hashingStrategy.computeHashCode(d) ^ HashFunctions.hash(n);
            return true;
        }
    }
}

