/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.common.util.Objects;
import com.tripwire.common.util.PropertyStream;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.ValidationException;
import com.tripwire.space.core.conditional.ActualCollectable;
import com.tripwire.space.core.conditional.CachedOperandExtractor;
import com.tripwire.space.core.conditional.ConditionTrace;
import com.tripwire.space.core.conditional.PropertyPatternFactory;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyExtractor
extends CachedOperandExtractor
implements ActualCollectable {
    private static final long serialVersionUID = 1L;
    private final int m_type;
    private String m_section;
    private String m_property;
    private transient Pattern m_pattern;

    public PropertyExtractor(int type, String property) throws ValidationException {
        this(type, null, property);
    }

    public PropertyExtractor(int type, String section, String property) throws ValidationException {
        if (type != 3 && type != 4) {
            throw new ValidationException("Types.error.properties");
        }
        this.m_type = type;
        this.setSection(section);
        this.setProperty(property);
    }

    public String getSection() {
        return this.m_section;
    }

    public final void setSection(String name) {
        this.m_section = name != null && name.length() == 0 ? null : name;
        this.reset();
    }

    public String getProperty() {
        return this.m_property;
    }

    public final void setProperty(String name) throws ValidationException {
        if (name == null) {
            throw new ValidationException("PropertyExtractor.propertyRequired");
        }
        this.m_property = name;
        this.reset();
    }

    public int getType() {
        return this.m_type;
    }

    public void collectExtractedValue(Map map) throws SpaceException {
        this.mapActual(map, this.getCollectableKey(), this.getExtractedForDisplay());
    }

    public Object getCollectableKey() {
        return this.m_section != null ? '[' + this.m_section + "]." + this.m_property : this.m_property;
    }

    protected Object extractValue(Object source) {
        String text;
        Matcher matcher;
        if (source == null) {
            return null;
        }
        if (this.m_pattern == null) {
            this.m_pattern = this.m_section == null ? PropertyPatternFactory.createPattern(this.m_type, this.m_property) : PropertyPatternFactory.createPattern(this.m_type, this.m_section, this.m_property);
            PropertyStream tracer = ConditionTrace.getPropertyStream();
            if (tracer != null) {
                tracer.begin("Property Extractor");
                tracer.property("Key", this.m_property);
                tracer.property("Pattern", this.m_pattern);
                tracer.end();
            }
        }
        return (matcher = this.m_pattern.matcher(text = (String)source)).find() ? matcher.group(1) : null;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyExtractor that = (PropertyExtractor)obj;
        return this.m_type == that.m_type && this.m_property.equals(that.m_property) && Objects.equals(this.m_section, that.m_section);
    }

    public int hashCode() {
        int hash = this.m_type ^ this.m_property.hashCode();
        if (this.m_section != null) {
            hash ^= this.m_section.hashCode();
        }
        return hash;
    }

    public void reset() {
        super.reset();
        this.m_pattern = null;
    }
}

