/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.ipdevice;

import com.mindbright.jca.security.SecureRandom;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh2.SSH2AuthKbdInteract;
import com.mindbright.ssh2.SSH2AuthPassword;
import com.mindbright.ssh2.SSH2AuthPublicKey;
import com.mindbright.ssh2.SSH2Authenticator;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2Interactor;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.ssh2.SSH2UserCancelException;
import com.mindbright.util.SecureRandomAndPad;
import com.tripwire.ipdevice.NetworkDeviceException;
import com.tripwire.ipdevice.ResourceLoader;
import com.tripwire.ipdevice.SSHChannel;
import com.tripwire.ipdevice.SSHUtil;
import com.tripwire.space.core.SpaceException;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

public class SSH2Connector {
    int m_refCount = 0;
    private static SecureRandomAndPad mindTermRand;
    private SSH2Transport m_transport;
    private SSH2Connection m_connection;

    public SSH2Connector(Properties parameters) throws SpaceException {
        int port = SSHChannel.getPort(parameters);
        try {
            Socket socket = new Socket(parameters.getProperty("server"), port);
            SSHUtil.setUpSocketParams(socket);
            this.init(parameters, socket);
        }
        catch (UnknownHostException e1) {
            throw new NetworkDeviceException("ssh.error.unknownHost", new Object[]{parameters.getProperty("server")});
        }
        catch (IOException e1) {
            throw new NetworkDeviceException("ssh.error.connectionRefused", new Object[]{parameters.getProperty("server"), new Integer(port)});
        }
    }

    public SSH2Connector(Properties parameters, Socket socket) throws SpaceException {
        this.init(parameters, socket);
    }

    private void init(Properties parameters, Socket socket) throws SpaceException {
        try {
            this.m_transport = new SSH2Transport(socket, mindTermRand);
            if (!SSHUtil.DEBUG_ON) {
                this.m_transport.getLog().setLevel(1);
            }
            try {
                this.m_transport.boot();
            }
            catch (SSH2Exception e2) {
                throw new NetworkDeviceException("ssh.error.connectionFailed", new Object[]{parameters.getProperty("server"), parameters.getProperty("port"), e2.getLocalizedMessage()});
            }
            if (!this.m_transport.waitForKEXComplete()) {
                String ourCipher = this.m_transport.getOurPreferences().getPreference("enc-algorithms-cli2srv");
                throw new NetworkDeviceException("ssh.error.UnsupportedCipher", new Object[]{parameters.getProperty("server"), ourCipher});
            }
            SSH2UserAuth userAuth = new SSH2UserAuth(this.m_transport, this.createAuthenticator(parameters));
            if (!userAuth.authenticateUser("ssh-connection")) {
                throw new NetworkDeviceException("ssh.error.loginFailed", new Object[]{parameters.getProperty("server"), parameters.getProperty("username")});
            }
            this.m_connection = new SSH2Connection(userAuth, this.m_transport);
            this.m_transport.setConnection(this.m_connection);
        }
        catch (SSH2Exception e) {
            throw new SpaceException(e);
        }
    }

    public void close() {
        --this.m_refCount;
        if (this.m_refCount == 0 && this.m_transport != null) {
            this.m_transport.normalDisconnect("");
            this.m_transport = null;
        }
    }

    public SSH2Connection getConnection() {
        ++this.m_refCount;
        return this.m_connection;
    }

    private SSH2Authenticator createAuthenticator(Properties parameters) throws SpaceException, SSH2Exception {
        int[] authMethods = this.getAuthenticationMethods(parameters);
        String userLogin = parameters.getProperty("username");
        SSH2Authenticator auth = new SSH2Authenticator(userLogin);
        for (int i = 0; i < authMethods.length; ++i) {
            if (authMethods[i] == 3) {
                String passwd = parameters.getProperty("password");
                auth.addModule(new SSH2AuthPassword(passwd));
                auth.addModule(new SSH2AuthKbdInteract(new FakeKeyboardInteractor(userLogin, passwd)));
                continue;
            }
            if (authMethods[i] != 2) continue;
            SSH2KeyPairFile keyFile = new SSH2KeyPairFile();
            try {
                keyFile.load(parameters.getProperty("private-key"), parameters.getProperty("key-passphrase"));
            }
            catch (IOException e) {
                throw new SpaceException(e);
            }
            SSH2Signature signature = SSH2Signature.getInstance(keyFile.getAlgorithmName());
            signature.initSign(keyFile.getKeyPair().getPrivate());
            signature.setPublicKey(keyFile.getKeyPair().getPublic());
            auth.addModule(new SSH2AuthPublicKey(signature));
        }
        return auth;
    }

    private int[] getAuthenticationMethods(Properties parameters) {
        int[] methods;
        String authString = parameters.getProperty("auth-method");
        if (authString != null) {
            methods = SSH.getAuthTypes(authString);
        } else {
            int authCount = 0;
            boolean hasPassword = false;
            boolean hasPublicKey = false;
            if (parameters.containsKey("password")) {
                hasPassword = true;
                ++authCount;
            }
            if (parameters.containsKey("private-key") && parameters.containsKey("key-passphrase")) {
                hasPublicKey = true;
                ++authCount;
            }
            methods = new int[authCount];
            authCount = 0;
            if (hasPassword) {
                methods[authCount++] = 3;
            }
            if (hasPublicKey) {
                methods[authCount] = 2;
            }
        }
        return methods;
    }

    static {
        ResourceLoader.load();
        mindTermRand = new SecureRandomAndPad(new SecureRandom());
    }

    public static class FakeKeyboardInteractor
    implements SSH2Interactor {
        private String m_passwd;
        private String m_user;

        public FakeKeyboardInteractor(String user, String passwd) {
            this.m_user = user;
            this.m_passwd = passwd;
        }

        public String promptLine(String prompt, boolean echo) throws SSH2UserCancelException {
            return null;
        }

        public String[] promptMulti(String[] prompts, boolean[] echos) throws SSH2UserCancelException {
            return null;
        }

        public String[] promptMultiFull(String name, String instruction, String[] prompts, boolean[] echos) throws SSH2UserCancelException {
            String[] results = new String[prompts.length];
            for (int i = 0; i < prompts.length; ++i) {
                if (prompts[i].toLowerCase().indexOf("password") != -1) {
                    results[i] = this.m_passwd;
                    continue;
                }
                if (prompts[i].toLowerCase().indexOf("login") != -1 || prompts[i].toLowerCase().indexOf("user") != -1) {
                    results[i] = this.m_user;
                    continue;
                }
                throw new SSH2UserCancelException("Unrecognized prompt: " + prompts[i]);
            }
            return results;
        }

        public int promptList(String name, String instruction, String[] choices) throws SSH2UserCancelException {
            return 0;
        }
    }
}

