/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.view.main;

import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.checker.app.Test;
import com.tripwire.checker.app.TestResultType;
import com.tripwire.checker.app.xml.ContentTest;
import com.tripwire.checker.app.xml.PolicyTest;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.honeybee.ui.HoneybeeUIApplication;
import com.tripwire.honeybee.ui.controller.HoneybeeController;
import com.tripwire.honeybee.ui.controller.requests.CloseTestDialogRequest;
import com.tripwire.honeybee.ui.model.marketing.LinkedImage;
import com.tripwire.honeybee.ui.model.marketing.MarketingCollateralModel;
import com.tripwire.honeybee.ui.model.marketing.TopBannerModel;
import com.tripwire.honeybee.ui.model.marketing.local.LocalAssetRetriever;
import com.tripwire.honeybee.ui.model.testrunner.ComplianceAssessmentModel;
import com.tripwire.honeybee.ui.model.testrunner.PolicyTree;
import com.tripwire.honeybee.ui.util.BrowserLauncher;
import com.tripwire.honeybee.ui.util.ComponentFactory;
import com.tripwire.honeybee.ui.view.main.ResultsTable;
import com.tripwire.honeybee.ui.view.main.ResultsTableModel;
import com.tripwire.vmware.api.EsxServer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
implements ConfigCheckerListener {
    public static final int STATUS_READY = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETE = 2;
    public static final int STATUS_ERROR = 3;
    protected ComplianceAssessmentModel m_complianceModel;
    protected MarketingCollateralModel m_marketingModel;
    protected HoneybeeController m_controller;
    protected Set<String> m_generalErrors = new HashSet<String>();
    protected Set<Test> m_testErrors = new HashSet<Test>();
    private ResourceManager mainResources = ResourceManager.getInstance();
    protected JFrame frame;
    protected JButton banner;
    protected JLabel hostnameLabel;
    protected JTextField hostnameField;
    protected JLabel usernameLabel;
    protected JTextField usernameField;
    protected JLabel passwordLabel;
    protected JPasswordField passwordField;
    protected JLabel rootPasswordLabel;
    protected JPasswordField rootPasswordField;
    protected int m_errorStartRow = -1;
    protected JLabel statusLine;
    protected JLabel statisticsLine;
    protected JLabel passingLine;
    protected JLabel failingLine;
    protected JLabel errorLine;
    protected JProgressBar progressBar;
    protected JButton checkButton;
    protected ResultsTable m_resultsTable;
    protected ResultsTableModel m_resultsTableModel;
    protected Map<String, Integer> m_testToRowMap = new ConcurrentHashMap<String, Integer>();
    protected Map<Integer, String> m_rowToTestMap = new ConcurrentHashMap<Integer, String>();
    protected Map<String, String> m_testToNameMap = new ConcurrentHashMap<String, String>();
    protected Map<String, TestResultType> m_testToResultMap = new ConcurrentHashMap<String, TestResultType>();
    protected Map<String, String> m_testToExternalIdMap = new ConcurrentHashMap<String, String>();
    protected JLabel moreInfoLabel;
    protected JButton[] moreInfoButtons;
    protected JButton[] graphicButtons;
    protected String m_policyFile = null;

    public MainWindow(HoneybeeController controller, ComplianceAssessmentModel complianceModel, MarketingCollateralModel marketingModel) {
        this.m_controller = controller;
        this.m_complianceModel = complianceModel;
        this.m_marketingModel = marketingModel;
        try {
            this.createWindow();
        }
        catch (Exception e) {
            System.out.println(ResourceManager.getInstance().getString("tw.honeybee.fatalError"));
            controller.shutdown();
        }
    }

    public void Open() {
        this.frame.setVisible(true);
    }

    public void init() {
        this.hostnameField.setText(this.m_complianceModel.getHostname());
        this.usernameField.setText(this.m_complianceModel.getUsername());
        this.passwordField.setText(this.m_complianceModel.getPassword());
        this.rootPasswordField.setText(this.m_complianceModel.getRootPassword());
    }

    public void updateModelFromUI() {
        this.m_complianceModel.setHostname(this.hostnameField.getText());
        this.m_complianceModel.setUsername(this.usernameField.getText());
        this.m_complianceModel.setPassword(new String(this.passwordField.getPassword()));
        this.m_complianceModel.setRootPassword(new String(this.rootPasswordField.getPassword()));
    }

    private void createWindow() throws Exception {
        this.frame = ComponentFactory.createTopLevelFrame(this.mainResources.getString("window.title"), this.m_marketingModel.getTopBanner().getWindowIcon(0));
        ActionListener aboutListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MainWindow.this.alert("aboutBox.title", MainWindow.this.mainResources.getString("aboutBox.message", new Object[]{HoneybeeUIApplication.getVersion()}), 1);
            }
        };
        String aboutShortcut = this.mainResources.getString("menu.help.about.shortcut").trim();
        char aboutKey = aboutShortcut.charAt(0);
        JMenuBar menuBar = new JMenuBar();
        JMenu helpMenu = new JMenu(this.mainResources.getString("menu.help"));
        JMenuItem about = new JMenuItem(this.mainResources.getString("menu.help.about"), aboutKey);
        about.addActionListener(aboutListener);
        about.setAccelerator(KeyStroke.getKeyStroke(aboutKey, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        helpMenu.add(about);
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        this.frame.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                try {
                    MainWindow.this.m_controller.handleRequest(new CloseTestDialogRequest());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.hostnameLabel = ComponentFactory.createTextLabel(this.mainResources.getString("hostname.label"), true);
        this.hostnameField = ComponentFactory.createTextEntry();
        this.usernameLabel = ComponentFactory.createTextLabel(this.mainResources.getString("username.label"), true);
        this.usernameField = ComponentFactory.createTextEntry();
        this.passwordLabel = ComponentFactory.createTextLabel(this.mainResources.getString("password.label"), true);
        this.passwordField = ComponentFactory.createPasswordEntry();
        this.rootPasswordLabel = ComponentFactory.createTextLabel(this.mainResources.getString("rootPassword.label"), true);
        this.rootPasswordField = ComponentFactory.createPasswordEntry();
        this.statusLine = ComponentFactory.createTextLabel(this.mainResources.getString("status.ready"), false);
        this.statisticsLine = ComponentFactory.createTextLabel(this.mainResources.getString("statistics.preRun"), false);
        this.passingLine = ComponentFactory.createTextLabel(this.mainResources.getString("passing.preRun"), false);
        this.failingLine = ComponentFactory.createTextLabel(this.mainResources.getString("failing.preRun"), false);
        this.errorLine = ComponentFactory.createTextLabel(this.mainResources.getString("error.preRun"), false);
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.checkButton = ComponentFactory.createButton(this.mainResources.getString("checkButton.text"), new Runnable(){

            public void run() {
                MainWindow.this.m_generalErrors.clear();
                MainWindow.this.m_testErrors.clear();
                MainWindow.this.m_testToNameMap.clear();
                MainWindow.this.m_testToRowMap.clear();
                MainWindow.this.checkButton.setEnabled(false);
                MainWindow.this.setUpMarketingArea(1);
                MainWindow.this.progressBar.setMinimum(0);
                MainWindow.this.progressBar.setMaximum(100);
                MainWindow.this.progressBar.setValue(0);
                MainWindow.this.progressBar.setVisible(true);
                MainWindow.this.failingLine.setText("");
                MainWindow.this.passingLine.setText("");
                MainWindow.this.errorLine.setText("");
                MainWindow.this.setStatus(1, 0, 0, 0, 0, 0);
                MainWindow.this.clearOutputText();
                MainWindow.this.updateModelFromUI();
                MainWindow.this.outputRow(MainWindow.this.mainResources.getString("status.checkingHost", new Object[]{MainWindow.this.m_complianceModel.getHostname()}), 1, 0);
                MainWindow.this.m_complianceModel.startChecking(MainWindow.this);
            }
        });
        this.m_resultsTableModel = new ResultsTableModel();
        this.m_resultsTableModel.setColumnCount(2);
        this.m_resultsTableModel.resetRowCount();
        this.m_resultsTable = new ResultsTable(this.m_resultsTableModel, this);
        this.moreInfoLabel = ComponentFactory.createTextLabel(this.m_marketingModel.getTopBanner().getMoreInfoText(), false);
        this.setUpMarketingArea(0);
        this.layoutComponents();
        ComponentFactory.packFrame(this.frame);
    }

    public void onCellClick(int column, int row) {
        String testId;
        if (column == 1 && (testId = this.m_rowToTestMap.get(row)) != null) {
            TestResultType result = this.m_testToResultMap.get(testId);
            String externalId = this.m_testToExternalIdMap.get(testId);
            if (result != null) {
                if (externalId != null && (result == TestResultType.FAIL || result == TestResultType.PASS) && this.m_marketingModel.getTopBanner().isSupplyingRemediationUrls()) {
                    String url = this.m_marketingModel.getTopBanner().getRemediationUrl(externalId, this.m_policyFile);
                    try {
                        BrowserLauncher.openURL(url);
                    }
                    catch (IOException e) {
                        System.err.println("Error opening browser: " + e.getMessage());
                    }
                }
                if (result == TestResultType.UNAVAILABLE || result == TestResultType.ERROR) {
                    this.m_resultsTable.scrollRectToVisible(this.m_resultsTable.getCellRect(this.m_resultsTableModel.getRowCount() - 1, 0, true));
                    this.m_resultsTable.getSelectionModel().clearSelection();
                    this.m_resultsTable.getSelectionModel().addSelectionInterval(this.m_errorStartRow, this.m_errorStartRow);
                }
            }
        }
    }

    protected JPanel createSubPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }

    protected void setUpMarketingArea(int phase) {
        LinkedImage topBanner = this.m_marketingModel.getTopBanner().getBannerImage(phase);
        if (this.banner == null) {
            this.banner = ComponentFactory.createGraphicLinkButton(topBanner.getImage(), topBanner.getLinkUrl());
        } else {
            ComponentFactory.updateGraphicLinkButton(this.banner, topBanner.getImage(), topBanner.getLinkUrl());
        }
        if (this.moreInfoButtons == null || this.moreInfoButtons.length == 0) {
            this.moreInfoButtons = ComponentFactory.createTextLinkButtons(this.m_marketingModel.getMoreInfoArea().getLinks(phase));
        } else {
            ComponentFactory.updateTextLinkButtons(this.moreInfoButtons, this.m_marketingModel.getMoreInfoArea().getLinks(phase));
        }
        if (this.graphicButtons == null || this.graphicButtons.length == 0) {
            this.graphicButtons = ComponentFactory.createGraphicLinkButtons(this.m_marketingModel.getRightBanner().getImages(phase));
        } else {
            ComponentFactory.updateGraphicLinkButtons(this.graphicButtons, this.m_marketingModel.getRightBanner().getImages(phase));
        }
    }

    @Override
    public void onStart(String policyFile) {
        this.m_policyFile = policyFile;
        this.m_testToResultMap.clear();
        this.m_testToExternalIdMap.clear();
    }

    @Override
    public void onTestsLoaded(HashMap<String, PolicyTest> tests) {
        PolicyTree tree = this.m_complianceModel.getPolicyTree();
        final int[] leafCount = new int[]{0};
        tree.walkTree(new PolicyTree.TreeProcessor(){

            public void onReceiveNode(PolicyTree.PolicyTreeNode treeNode) {
                int row = MainWindow.this.outputRow(treeNode.name, treeNode.leaf ? 1 : 0, treeNode.level);
                MainWindow.this.m_testToRowMap.put(treeNode.id, new Integer(row));
                if (treeNode.leaf) {
                    MainWindow.this.m_rowToTestMap.put(new Integer(row), treeNode.id);
                }
                MainWindow.this.m_testToNameMap.put(treeNode.id, treeNode.name);
                if (treeNode.leaf) {
                    leafCount[0] = leafCount[0] + 1;
                }
            }
        });
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(leafCount[0]);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
    }

    protected int getRowForTestResult(ContentTest test) {
        Integer id = this.m_testToRowMap.get(test.getAttribId());
        if (id != null) {
            return id;
        }
        System.out.println("Result received for unknown test: " + test.getAttribId());
        return -1;
    }

    @Override
    public void onChangeTest(ContentTest test, TestResultType newResult, TestResultType oldResult) {
        if (this.m_testToResultMap.containsKey(test.getAttribId())) {
            System.out.println("Received multiple results for test " + test.getAttribId());
            return;
        }
        this.m_testToResultMap.put(test.getAttribId(), newResult);
        this.m_testToExternalIdMap.put(test.getAttribId(), test.getAttribExternalId());
        switch (newResult) {
            case PASS: {
                this.setRowStatus(this.getRowForTestResult(test), this.mainResources.getString("result.passed"), 2);
                break;
            }
            case FAIL: {
                String output;
                this.setRowStatus(this.getRowForTestResult(test), this.mainResources.getString("result.failed"), 3);
                if (!test.isAttribDisplayableElementOutput() || (output = test.getElementContent()) == null || output.length() <= 0) break;
                this.outputRow("", 0, 0);
                this.outputRow(this.mainResources.getString("detailsFor", new Object[]{test.getAttribName()}), 0, 0);
                int idx = output.indexOf(10);
                if (idx > 0) {
                    idx = -1;
                    while (output.indexOf(10, idx + 1) >= 0) {
                        int lastIdx = idx + 1;
                        idx = output.indexOf(10, idx + 1);
                        this.outputRow(output.substring(lastIdx, idx), 0, 0);
                    }
                    String theRestOfIt = output.substring(idx);
                    if (theRestOfIt.length() <= 0) break;
                    this.outputRow(theRestOfIt, 0, 0);
                    break;
                }
                this.outputRow(output, 0, 0);
                break;
            }
            case ERROR: {
                this.setRowStatus(this.getRowForTestResult(test), this.mainResources.getString("result.error"), 3);
                break;
            }
            case UNAVAILABLE: {
                this.setRowStatus(this.getRowForTestResult(test), this.mainResources.getString("result.unavailable"), 3);
                break;
            }
        }
        this.setStatus(1, this.m_complianceModel.getPassedCount(), this.m_complianceModel.getFailedCount(), this.m_complianceModel.getPendingCount(), this.m_complianceModel.getErrorCount(), this.m_complianceModel.getUnavailableCount());
    }

    protected synchronized void handleGeneralError(Test test, CheckerException error) {
        if (this.m_generalErrors.isEmpty() && this.m_testErrors.isEmpty()) {
            this.m_errorStartRow = this.m_resultsTableModel.getRowCount() + 2;
            this.outputRow("", 0, 0);
            this.outputRow("", 0, 0);
            this.outputRow(this.mainResources.getString("generalErrors.occurred.rowText"), 1, 0);
        }
        if (test == null) {
            if (!this.m_generalErrors.contains(error.getMessage())) {
                this.m_generalErrors.add(error.getMessage());
                this.outputRow(error.getMessage(), 0, 0);
                this.outputRow("", 0, 0);
            }
        } else if (!this.m_testErrors.contains(test)) {
            this.m_testErrors.add(test);
            this.outputRow(this.m_testToNameMap.get(test.getName()), 3, 0);
            this.outputRow(error.getMessage(), 3, 1);
            this.outputRow("", 0, 0);
        }
    }

    @Override
    public void onTestError(Test test, CheckerException error) {
        this.handleGeneralError(test, error);
    }

    @Override
    public void onFatalError(CheckerException error) {
        this.m_resultsTableModel.resetRowCount();
        this.alert("fatalError.alert.title", error.getMessage(), 0);
        this.outputRow(ResourceManager.getInstance().getString("blankLine.text"), 3, 0);
        this.outputRow(error.getMessage(), 1, 0);
        this.outputRow(ResourceManager.getInstance().getString("blankLine.text"), 3, 0);
        this.outputRow(ResourceManager.getInstance().getString("testsAborted.text"), 3, 0);
        this.onEnd(0L);
        this.setUpMarketingArea(0);
    }

    @Override
    public synchronized void onGeneralError(CheckerException error) {
        this.handleGeneralError(null, error);
    }

    @Override
    public void onVersionInfo(String uname, String vmware, EsxServer.Version version) {
    }

    @Override
    public void onAccessorStart(String accessorType) {
        this.setStatus(1, this.m_complianceModel.getPassedCount(), this.m_complianceModel.getFailedCount(), this.m_complianceModel.getPendingCount(), this.m_complianceModel.getErrorCount(), this.m_complianceModel.getUnavailableCount());
    }

    @Override
    public void onAccessorChange(String accessorType, AccessorResultType newResult, AccessorResultType oldResult) {
    }

    @Override
    public void onAccessorEnd(String accessorType, long timeTaken, AccessorResultType result, Exception e) {
        this.setStatus(1, this.m_complianceModel.getPassedCount(), this.m_complianceModel.getFailedCount(), this.m_complianceModel.getPendingCount(), this.m_complianceModel.getErrorCount(), this.m_complianceModel.getUnavailableCount());
    }

    @Override
    public void onEnd(long timeTaken) {
        this.checkButton.setEnabled(true);
        this.setUpMarketingArea(2);
        this.setStatus(this.m_complianceModel.getErrorCount() == 0 ? 2 : 3, this.m_complianceModel.getPassedCount(), this.m_complianceModel.getFailedCount(), 0, this.m_complianceModel.getErrorCount(), this.m_complianceModel.getUnavailableCount());
    }

    private void layoutComponents() throws Exception {
        LocalAssetRetriever retriever = LocalAssetRetriever.getInstance();
        GridBagLayout layout = new GridBagLayout();
        JPanel backgroundPanel = new JPanel(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        JLabel backgroundImage = new JLabel(new ImageIcon(retriever.loadImage("background-with-logo.png")));
        backgroundImage.setPreferredSize(new Dimension(1, 1));
        backgroundImage.setMinimumSize(new Dimension(1, 1));
        backgroundImage.setVerticalAlignment(1);
        backgroundImage.setHorizontalAlignment(10);
        JPanel left = this.createLeftPanel();
        JPanel right = this.createRightPanel();
        layout.setConstraints(left, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 0), 0, 0));
        backgroundPanel.add(left);
        layout.setConstraints(right, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        backgroundPanel.add(right);
        backgroundPanel.add((Component)backgroundImage, gbc);
        this.frame.add(backgroundPanel);
    }

    private JPanel createLeftPanel() {
        JPanel panel = this.createSubPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        int y = 0;
        layout.setConstraints(this.banner, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 17, 0, new Insets(1, 1, 8, 0), 0, 0));
        panel.setMinimumSize(new Dimension(panel.getWidth(), panel.getWidth()));
        panel.add(this.banner);
        JPanel fieldPanel = this.createFieldPanel();
        layout.setConstraints(fieldPanel, new GridBagConstraints(0, y++, 1, 1, 0.7, 1.0, 17, 2, new Insets(1, 10, 1, 0), 0, 0));
        panel.add(fieldPanel);
        JPanel statusPanel = this.createStatusPanel();
        layout.setConstraints(statusPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 17, 2, new Insets(4, 1, 4, 0), 0, 0));
        panel.add(statusPanel);
        JPanel outputPanel = this.createOutputPanel();
        layout.setConstraints(outputPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 0), 0, 0));
        panel.add(outputPanel);
        JPanel infoPanel = this.createMoreInfoPanel();
        layout.setConstraints(infoPanel, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 17, 2, new Insets(8, 1, 1, 0), 0, 0));
        panel.add(infoPanel);
        return panel;
    }

    private JPanel createFieldPanel() {
        JPanel panel = this.createSubPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        int y = 0;
        this.hostnameLabel.setForeground(Color.white);
        layout.setConstraints(this.hostnameLabel, new GridBagConstraints(0, y, 1, 1, 0.3, 1.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(this.hostnameLabel);
        layout.setConstraints(this.hostnameField, new GridBagConstraints(1, y, 2, 1, 4.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(this.hostnameField);
        this.usernameLabel.setForeground(Color.white);
        layout.setConstraints(this.usernameLabel, new GridBagConstraints(3, y, 1, 1, 0.3, 1.0, 17, 0, new Insets(1, 5, 1, 1), 0, 0));
        panel.add(this.usernameLabel);
        layout.setConstraints(this.usernameField, new GridBagConstraints(4, y++, 2, 1, 4.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(this.usernameField);
        this.passwordLabel.setForeground(Color.white);
        layout.setConstraints(this.passwordLabel, new GridBagConstraints(0, y, 1, 1, 0.3, 1.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(this.passwordLabel);
        layout.setConstraints(this.passwordField, new GridBagConstraints(1, y, 2, 1, 0.7, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(this.passwordField);
        this.rootPasswordLabel.setForeground(Color.white);
        layout.setConstraints(this.rootPasswordLabel, new GridBagConstraints(3, y, 1, 1, 0.3, 1.0, 17, 0, new Insets(1, 5, 1, 1), 0, 0));
        panel.add(this.rootPasswordLabel);
        layout.setConstraints(this.rootPasswordField, new GridBagConstraints(4, y, 2, 1, 0.7, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(this.rootPasswordField);
        layout.setConstraints(this.checkButton, new GridBagConstraints(6, y, 1, 2, 0.5, 1.0, 14, 0, new Insets(0, 10, 0, 10), 1, 1));
        panel.add(this.checkButton);
        return panel;
    }

    private JPanel createStatusPanel() {
        JPanel panel = this.createSubPanel();
        JPanel outerPanel = this.createSubPanel();
        panel.setBackground(Color.white);
        panel.setOpaque(true);
        LineBorder lineBorder = new LineBorder(Color.GRAY, 1, true);
        panel.setBorder(lineBorder);
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        layout.setConstraints(this.statusLine, new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 17, 0, new Insets(5, 5, 5, 5), 1, 1));
        panel.add(this.statusLine);
        JPanel statisticsPanel = this.createSubPanel();
        statisticsPanel.setLayout(new FlowLayout(0));
        statisticsPanel.add(this.statisticsLine);
        statisticsPanel.add(this.passingLine);
        statisticsPanel.add(this.failingLine);
        statisticsPanel.add(this.errorLine);
        this.passingLine.setForeground(Color.green.darker());
        this.failingLine.setForeground(Color.red.darker());
        this.passingLine.setFont(this.passingLine.getFont().deriveFont(1));
        this.failingLine.setFont(this.failingLine.getFont().deriveFont(1));
        this.errorLine.setFont(this.errorLine.getFont().deriveFont(1));
        layout.setConstraints(statisticsPanel, new GridBagConstraints(1, 0, 1, 1, 11.0, 1.0, 17, 2, new Insets(0, 1, 0, 0), 1, 1));
        panel.add(statisticsPanel);
        this.progressBar.setSize(100, 30);
        this.progressBar.setMaximumSize(new Dimension(100, 30));
        this.progressBar.setMinimumSize(new Dimension(100, 30));
        this.progressBar.setBackground(Color.white);
        layout.setConstraints(this.progressBar, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 1, 0, 5), 1, 1));
        panel.add(this.progressBar);
        GridBagLayout outerLayout = new GridBagLayout();
        outerPanel.setLayout(outerLayout);
        outerLayout.setConstraints(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 1, 1));
        outerPanel.add(panel);
        return outerPanel;
    }

    private JPanel createOutputPanel() {
        JPanel panel = this.createSubPanel();
        JScrollPane scrollPane = new JScrollPane(this.m_resultsTable);
        scrollPane.getViewport().setBackground(this.m_resultsTable.getBackground());
        scrollPane.setPreferredSize(new Dimension(this.banner.getIcon().getIconWidth() - 7, 280));
        scrollPane.setMaximumSize(new Dimension(this.banner.getIcon().getIconWidth() - 7, 280));
        scrollPane.setMinimumSize(new Dimension(this.banner.getIcon().getIconWidth() - 7, 280));
        panel.add(scrollPane);
        return panel;
    }

    private JPanel createMoreInfoPanel() {
        JPanel panel = this.createSubPanel();
        if (this.graphicButtons.length > 0) {
            GridBagLayout layout = new GridBagLayout();
            panel.setLayout(layout);
            this.moreInfoLabel.setFont(this.moreInfoLabel.getFont().deriveFont(12.0f).deriveFont(1));
            layout.setConstraints(this.moreInfoLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 6, 3, 0), 0, 0));
            panel.add(this.moreInfoLabel);
            int row = 1;
            int col = 0;
            for (JButton button : this.moreInfoButtons) {
                button.setFont(button.getFont().deriveFont(12.0f));
                layout.setConstraints(button, new GridBagConstraints(col, row, 1, 1, 1.0, 1.0, 17, 0, new Insets(1, 4, 1, 4), 4, 0));
                ++col;
                if ((col %= 2) == 0) {
                    ++row;
                }
                panel.add(button);
            }
        }
        return panel;
    }

    private JPanel createRightPanel() {
        JPanel panel = this.createSubPanel();
        if (this.graphicButtons.length > 0) {
            int width = 0;
            int height = 0;
            GridBagLayout layout = new GridBagLayout();
            panel.setLayout(layout);
            for (int i = 0; i < this.graphicButtons.length; ++i) {
                layout.setConstraints(this.graphicButtons[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                panel.add(this.graphicButtons[i]);
                if (width < this.graphicButtons[i].getWidth()) {
                    width = this.graphicButtons[i].getWidth();
                }
                height += this.graphicButtons[i].getHeight();
            }
            panel.setMinimumSize(new Dimension(width, height));
        }
        return panel;
    }

    public void setStatus(final int status, final int passed, final int failed, final int pending, final int errors, final int unavailable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuffer sb = new StringBuffer();
                switch (status) {
                    case 0: {
                        MainWindow.this.statusLine.setText(MainWindow.this.mainResources.getString("status.ready"));
                        break;
                    }
                    case 1: {
                        MainWindow.this.statusLine.setText(MainWindow.this.mainResources.getString("status.checking"));
                        break;
                    }
                    case 2: {
                        MainWindow.this.statusLine.setText(MainWindow.this.mainResources.getString("status.complete"));
                        TopBannerModel top = MainWindow.this.m_marketingModel.getTopBanner();
                        if ((passed > 0 || failed > 0) && top.isSupplyingRemediationUrls() && top.getRemediationMessage() != null) {
                            MainWindow.this.alert("tw.honeybee.remediation.title", top.getRemediationMessage(), 1);
                        }
                        if (MainWindow.this.m_generalErrors.isEmpty() && MainWindow.this.m_testErrors.isEmpty()) break;
                        MainWindow.this.alert("generalError.alert.title", MainWindow.this.mainResources.getString("generalErrors.occurred.alertText"), 0);
                        break;
                    }
                    case 3: {
                        MainWindow.this.statusLine.setText(MainWindow.this.mainResources.getString("status.error"));
                        MainWindow.this.progressBar.setVisible(false);
                        MainWindow.this.statisticsLine.setText("");
                        return;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (passed > 0 || failed > 0 || pending > 0 || errors > 0) {
                    if (pending > 0) {
                        MainWindow.this.progressBar.setValue(passed + failed + errors);
                        MainWindow.this.failingLine.setText("");
                        MainWindow.this.passingLine.setText("");
                        MainWindow.this.errorLine.setText("");
                        MainWindow.this.statisticsLine.setFont(MainWindow.this.statisticsLine.getFont().deriveFont(0));
                        if (errors > 0 || unavailable > 0) {
                            sb.append(MainWindow.this.mainResources.getString("testCountWithPendingWithErrors", new Object[]{pending, passed, failed, errors + unavailable}));
                        } else {
                            sb.append(MainWindow.this.mainResources.getString("testCountWithPending", new Object[]{pending, passed, failed}));
                        }
                        if (sb.length() == 0) {
                            MainWindow.this.statisticsLine.setText(MainWindow.this.mainResources.getString("loadingTests"));
                        } else {
                            MainWindow.this.statisticsLine.setText(sb.toString());
                        }
                    } else {
                        MainWindow.this.progressBar.setVisible(false);
                        MainWindow.this.statisticsLine.setText("");
                        MainWindow.this.passingLine.setText(MainWindow.this.mainResources.getString("passingTestCount", new Object[]{new Integer(passed)}));
                        if (errors > 0 || unavailable > 0) {
                            MainWindow.this.failingLine.setText(MainWindow.this.mainResources.getString("failingTestCount", new Object[]{new Integer(failed)}));
                            MainWindow.this.errorLine.setText(MainWindow.this.mainResources.getString("errorTestCount", new Object[]{new Integer(errors + unavailable)}));
                        } else {
                            MainWindow.this.failingLine.setText(MainWindow.this.mainResources.getString("failingTestCountNoErrors", new Object[]{new Integer(failed)}));
                            MainWindow.this.errorLine.setText("");
                        }
                    }
                }
            }
        });
    }

    public synchronized int outputRow(final String text, final int style, final int indentationLevel) {
        final int row = this.m_resultsTableModel.incrementRowCount() - 1;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.m_resultsTableModel.setRowCount(MainWindow.this.m_resultsTableModel.getRowCount() + 1);
                MainWindow.this.m_resultsTableModel.setTextAt(text, row, 0, style, indentationLevel);
                MainWindow.this.m_resultsTable.adjustColumnWidthsToFitData();
            }
        });
        return row;
    }

    public void setRowStatus(final int row, final String text, final int style) {
        if (row > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.m_resultsTableModel.setTextAt(text, row, 1, style, 0);
                    MainWindow.this.m_resultsTable.adjustColumnWidthsToFitData();
                }
            });
        }
    }

    public void clearOutputText() {
        this.m_resultsTableModel.resetRowCount();
    }

    public void alert(final String titleResourceName, final String dialogMsg, final int dialogType) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(MainWindow.this.frame, dialogMsg, MainWindow.this.mainResources.getString(titleResourceName), dialogType);
            }
        });
    }

    public void errorDialog(final String resourceName, final Object[] arguments) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(MainWindow.this.frame, MainWindow.this.getFormattedString(resourceName + ".message", arguments), MainWindow.this.getFormattedString(resourceName + ".title", arguments), 0);
            }
        });
    }

    private String getFormattedString(String resource, Object[] arguments) {
        MessageFormat format = new MessageFormat(this.mainResources.getString(resource));
        format.setLocale(Locale.getDefault());
        return format.format(arguments);
    }

    static {
        ResourceManager.getInstance().addStandardResources(MainWindow.class);
    }
}

