/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.model.marketing.remote;

import com.tripwire.honeybee.ui.HoneybeeUIApplication;
import com.tripwire.honeybee.ui.model.marketing.AssetRetriever;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class RemoteAssetRetriever
implements AssetRetriever {
    protected final String m_remoteUrl;
    protected Properties m_remoteProperties = null;

    public RemoteAssetRetriever(String remoteUrl) {
        this.m_remoteUrl = remoteUrl;
    }

    public Image loadImage(String imageLocation) throws Exception {
        URL url = this.buildUrl(imageLocation);
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public String getString(String key) throws Exception {
        Properties properties = this.getRemoteProperties();
        if (!properties.containsKey(key)) {
            return null;
        }
        return (String)properties.get(key);
    }

    private Properties getRemoteProperties() throws Exception {
        if (this.m_remoteProperties == null) {
            URL url = this.buildUrl("content.cfm");
            URLConnection connection = url.openConnection();
            Properties properties = new Properties();
            properties.load(connection.getInputStream());
            this.m_remoteProperties = properties;
        }
        return this.m_remoteProperties;
    }

    private boolean isAbsoluteUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }

    private URL buildUrl(String fileName) throws MalformedURLException {
        String url = fileName;
        if (!this.isAbsoluteUrl(url)) {
            url = this.m_remoteUrl + "/" + fileName;
        }
        StringBuilder sb = new StringBuilder(url);
        sb.append("?");
        sb.append("appvers=");
        sb.append(HoneybeeUIApplication.getVersion());
        sb.append("&locale=");
        sb.append(HoneybeeUIApplication.getLocale());
        sb.append("&policies=");
        sb.append(HoneybeeUIApplication.getPolicies());
        sb.append("&source=");
        sb.append(HoneybeeUIApplication.getDistributor());
        return new URL(sb.toString());
    }
}

