/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.util.Dbg;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.UnsignedExtension;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StringUtil {
    public static final String NO_ENCODING = "ISO8859_1";
    public static final String UTF8 = "UTF8";
    public static final String UTF16 = "UTF-16";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String MAP_KEY_VALUE_SEPARATOR = " = ";
    public static final String COLLECTION_ELEMENT_SEPARATOR = System.getProperty("line.separator");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;

    private StringUtil() {
    }

    public static byte[] getMD5(String value) throws NoSuchAlgorithmException {
        return StringUtil.getDigest("MD5", value);
    }

    public static byte[] getDigest(String encoding, String value) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(encoding).digest(value.getBytes());
    }

    public static String getLineTerminator(CharSequence seq) {
        int length = seq.length() - 1;
        for (int at = 0; at < length; ++at) {
            char ch = seq.charAt(at);
            if (ch == '\r') {
                char cNext = seq.charAt(at + 1);
                return cNext == '\n' ? "\r\n" : "\r";
            }
            if (ch != '\n') continue;
            return "\n";
        }
        return "";
    }

    public static String reformatLines(CharSequence original, CharSequence terminator) {
        StringArray lines = new StringArray();
        StringUtil.splitStringEOL(lines, original);
        StringBuffer buf = new StringBuffer(original.length() + lines.size() * terminator.length());
        int count = lines.size();
        for (int at = 0; at < count; ++at) {
            buf.append(lines.m_rep[at]);
            buf.append(terminator);
        }
        return buf.toString();
    }

    public static byte[] hexToBytes(CharSequence hexString) {
        if (hexString == null || hexString.length() == 0) {
            return null;
        }
        byte[] results = new byte[hexString.length() / 2];
        int resIdx = 0;
        for (int i = 0; i < hexString.length(); i += 2) {
            char msn = hexString.charAt(i);
            char lsn = hexString.charAt(i + 1);
            int value = msn >= '0' && msn <= '9' ? msn - 48 : 10 + msn - 97;
            value <<= 4;
            results[resIdx] = (byte)(value += lsn >= '0' && lsn <= '9' ? lsn - 48 : 10 + lsn - 97);
            ++resIdx;
        }
        return results;
    }

    public static String convertToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length * 2];
        int byteIndex = 0;
        int charIndex = 0;
        while (byteIndex < bytes.length) {
            int b = bytes[byteIndex] & 0xFF;
            chars[charIndex] = HEX_DIGITS[b >>> 4];
            chars[charIndex + 1] = HEX_DIGITS[b & 0xF];
            ++byteIndex;
            charIndex += 2;
        }
        return new String(chars);
    }

    public static String convertToHexString(byte[] bytes, String separator) {
        assert (bytes != null);
        assert (separator != null);
        int count = bytes.length;
        if (count == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        StringUtil.appendHexDigits(bytes[0], buf);
        for (int pos = 1; pos < count; ++pos) {
            buf.append(separator);
            StringUtil.appendHexDigits(bytes[pos], buf);
        }
        return buf.toString();
    }

    private static void appendHexDigits(byte value, StringBuffer destination) {
        int b = value & 0xFF;
        destination.append(HEX_DIGITS[b >>> 4]);
        destination.append(HEX_DIGITS[b & 0xF]);
    }

    public static String convertToPrintableText(String input) {
        StringBuffer buf = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char inchar = input.charAt(i);
            if (inchar >= ' ' && inchar <= '~' || inchar == '\r' || inchar == '\n' || inchar == '\t') {
                buf.append(inchar);
                continue;
            }
            if (inchar == '\u0000') {
                buf.append('\\');
                buf.append('0');
                continue;
            }
            if (inchar >= '\u0001' && inchar <= '\u001a') {
                buf.append('^');
                inchar = (char)(inchar + 64);
                buf.append(inchar);
                continue;
            }
            if (inchar >= '\u001b' && inchar <= '\u00ff') {
                buf.append("\\x");
                buf.append(Integer.toHexString(inchar));
                continue;
            }
            if (inchar < '\u0100') continue;
            buf.append("\\u");
            String s = Integer.toHexString(inchar);
            for (int j = s.length(); j < 4; ++j) {
                buf.append('0');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String toString(byte b) {
        return ((Object)StringUtil.zeroFill(Integer.toHexString(UnsignedExtension.byteToInt(b)), 2)).toString();
    }

    public static String toString(short s) {
        return ((Object)StringUtil.zeroFill(Integer.toHexString(s & 0xFFFF), 4)).toString();
    }

    public static String toString(int i) {
        return ((Object)StringUtil.zeroFill(Integer.toHexString(i), 8)).toString();
    }

    public static String toString(long l) {
        return ((Object)StringUtil.zeroFill(Long.toHexString(l), 16)).toString();
    }

    public static String firstLine(CharSequence string) {
        int stop = string.length();
        for (int at = 0; at < stop; ++at) {
            char c = string.charAt(at);
            if (c != '\n' && c != '\r') continue;
            return ((Object)string.subSequence(0, at)).toString();
        }
        return ((Object)string).toString();
    }

    public static int countLines(CharSequence in) {
        int lineCount = 0;
        int endOfString = in.length();
        boolean nonEOLCharFound = false;
        for (int cursor = 0; cursor < endOfString; ++cursor) {
            if (in.charAt(cursor) == '\r') {
                ++lineCount;
                nonEOLCharFound = false;
                if (cursor + 1 >= endOfString || in.charAt(cursor + 1) != '\n') continue;
                ++cursor;
                continue;
            }
            if (in.charAt(cursor) == '\n') {
                ++lineCount;
                nonEOLCharFound = false;
                continue;
            }
            nonEOLCharFound = true;
        }
        return lineCount + (nonEOLCharFound ? 1 : 0);
    }

    public static String[] splitStringEOL(CharSequence in) {
        StringArray list = new StringArray();
        StringUtil.splitStringEOL(list, in);
        return list.getStringArray();
    }

    public static void splitStringEOL(StringArray list, CharSequence in) {
        EolLine line;
        int count = in.length();
        for (int cursor = 0; cursor < count; cursor += line.length()) {
            line = StringUtil.findNextLine(in, cursor);
            list.add(line.lineWithoutEol());
        }
    }

    public static void splitStringEOL(List list, CharSequence in) {
        EolLine line;
        int count = in.length();
        for (int cursor = 0; cursor < count; cursor += line.length()) {
            line = StringUtil.findNextLine(in, cursor);
            list.add(line.lineWithoutEol());
        }
    }

    public static EolLine findNextLine(CharSequence source, int startPos) {
        int cursor;
        int sourceLen = source.length();
        assert (startPos >= 0 && startPos < sourceLen);
        for (cursor = startPos; cursor < sourceLen; ++cursor) {
            char currentChar = source.charAt(cursor);
            if (currentChar == '\r') {
                if (cursor + 1 < sourceLen && source.charAt(cursor + 1) == '\n') {
                    return new EolLine(source.subSequence(startPos, cursor + 2), cursor - startPos);
                }
                return new EolLine(source.subSequence(startPos, cursor + 1), cursor - startPos);
            }
            if (currentChar != '\n') continue;
            return new EolLine(source.subSequence(startPos, cursor + 1), cursor - startPos);
        }
        return new EolLine(source.subSequence(startPos, cursor), cursor - startPos);
    }

    public static String head(CharSequence in, int lineLimit) {
        ArrayList lines = new ArrayList();
        StringUtil.splitStringEOL(lines, in);
        StringBuffer sb = new StringBuffer();
        int min = Math.min(lineLimit, lines.size());
        for (int i = 0; i < min; ++i) {
            sb.append(lines.get(i));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equalsIgnoreCase(b);
    }

    public static String formatDateTime(Date date) {
        return StringUtil.formatDateTime(date, "dateTime.string.short");
    }

    public static String formatDateTimeLong(Date date) {
        return StringUtil.formatDateTime(date, "dateTime.string.long");
    }

    public static String formatDateTime(Date date, String key) {
        if (date == null) {
            return null;
        }
        ResourceManager resMgr = ResourceManager.getInstance();
        String str = resMgr.getSafeString(key, new Object[]{date});
        return str;
    }

    public static String formatDate(Date date) {
        return StringUtil.formatDateTime(date, "date.string.short");
    }

    public static String getShortenedString(String original, int maxLength) {
        String shortName = null;
        int stringLength = original.length();
        int utfLength = 0;
        char[] chars = new char[stringLength];
        int[] charSize = new int[stringLength];
        original.getChars(0, stringLength, chars, 0);
        for (int i = 0; i < stringLength; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLength;
                charSize[i] = 1;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                charSize[i] = 3;
                continue;
            }
            utfLength += 2;
            charSize[i] = 2;
        }
        if (utfLength > maxLength) {
            if (utfLength == stringLength) {
                shortName = StringUtil.truncateWithEllipsis(original, maxLength);
            } else if (utfLength > stringLength) {
                String multi = ResourceManager.getInstance().getString("shortenedString.multibyteFactor", "1");
                double multifactor = Double.valueOf(multi);
                int newLimit = (int)(multifactor * (double)maxLength);
                StringBuffer buff = new StringBuffer();
                int count = 0;
                for (int i = 0; i < chars.length && count <= newLimit; count += charSize[i], ++i) {
                    buff.append(chars[i]);
                }
                buff.append("...");
                shortName = buff.toString();
            }
        } else {
            shortName = original;
        }
        return shortName;
    }

    public static String repeatCharacter(char character, int count) {
        assert (count >= 0);
        char[] buf = new char[count];
        for (int i = count - 1; i >= 0; --i) {
            buf[i] = character;
        }
        return new String(buf);
    }

    public static CharSequence alignString(CharSequence s, int width, int align, char chFill) {
        int i;
        int nRight;
        int nLeft;
        int nFill = width - s.length();
        if (nFill <= 0) {
            return s;
        }
        switch (align) {
            case 0: {
                nLeft = 0;
                nRight = nFill;
                break;
            }
            case 1: {
                nLeft = nFill;
                nRight = 0;
                break;
            }
            case 2: {
                nLeft = nFill / 2;
                nRight = nFill - nLeft;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid alignment value: " + align);
            }
        }
        StringBuffer sb = new StringBuffer(nLeft + nRight + s.length());
        for (i = 0; i < nLeft; ++i) {
            sb.append(chFill);
        }
        sb.append(s);
        for (i = 0; i < nRight; ++i) {
            sb.append(chFill);
        }
        return sb;
    }

    public static CharSequence alignString(CharSequence s, int width, int align) {
        return StringUtil.alignString(s, width, align, ' ');
    }

    public static CharSequence padString(CharSequence s, int width) {
        return StringUtil.alignString(s, width, 0, ' ');
    }

    public static CharSequence padString(CharSequence s, int width, char chFill) {
        return StringUtil.alignString(s, width, 0, chFill);
    }

    public static CharSequence zeroFill(CharSequence s, int width) {
        return StringUtil.alignString(s, width, 1, '0');
    }

    public static CharSequence indent(CharSequence source, int indentSize, char indentChar) {
        EolLine line;
        StringBuffer ret = new StringBuffer();
        for (int cursor = 0; cursor < source.length(); cursor += line.length()) {
            line = StringUtil.findNextLine(source, cursor);
            for (int i = indentSize; i > 0; --i) {
                ret.append(indentChar);
            }
            ret.append(line);
        }
        return ret;
    }

    public static CharSequence indent(CharSequence source, CharSequence indentCharSequence) {
        EolLine line;
        StringBuffer ret = new StringBuffer();
        for (int cursor = 0; cursor < source.length(); cursor += line.length()) {
            line = StringUtil.findNextLine(source, cursor);
            ret.append(indentCharSequence);
            ret.append(line);
        }
        return ret;
    }

    public static CharSequence wrapWords(CharSequence line, int maxLineLen, int minLineLen, int continuationIndent) {
        String indentString;
        StringBuffer ret = new StringBuffer(((Object)line).toString());
        int startOfCurrentLine = 0;
        int startOfEol = line.length();
        if (ret.charAt(startOfEol - 2) == '\r' && ret.charAt(startOfEol - 1) == '\n') {
            startOfEol -= 2;
        } else if (ret.charAt(startOfEol - 1) == '\n' || ret.charAt(startOfEol - 1) == '\r') {
            --startOfEol;
        }
        boolean processingFirstLine = true;
        String string = indentString = continuationIndent > 0 ? StringUtil.repeatCharacter(' ', continuationIndent) : null;
        while (startOfEol - startOfCurrentLine > maxLineLen) {
            int lastWhitespaceFoundAt = -1;
            for (int i = startOfEol - 1; i > startOfCurrentLine + minLineLen; --i) {
                if (!Character.isWhitespace(ret.charAt(i))) continue;
                lastWhitespaceFoundAt = i;
                if (i - startOfCurrentLine < maxLineLen) break;
            }
            if (lastWhitespaceFoundAt == -1) break;
            while (lastWhitespaceFoundAt > startOfCurrentLine + 1 && Character.isWhitespace(ret.charAt(lastWhitespaceFoundAt - 1))) {
                --lastWhitespaceFoundAt;
            }
            ret.setCharAt(lastWhitespaceFoundAt, '\n');
            if (continuationIndent > 0) {
                ret.insert(lastWhitespaceFoundAt + 1, indentString);
                startOfCurrentLine = lastWhitespaceFoundAt + 1 + continuationIndent;
                startOfEol += continuationIndent;
                if (processingFirstLine) {
                    if (maxLineLen - continuationIndent > minLineLen) {
                        maxLineLen -= continuationIndent;
                    }
                    processingFirstLine = false;
                }
            } else {
                startOfCurrentLine = lastWhitespaceFoundAt + 1;
            }
            while (startOfCurrentLine < startOfEol && Character.isWhitespace(ret.charAt(startOfCurrentLine))) {
                ret.deleteCharAt(startOfCurrentLine);
                --startOfEol;
            }
        }
        return ret;
    }

    public static CharSequence indent(CharSequence s, int indentSize) {
        return StringUtil.indent(s, indentSize, ' ');
    }

    public static String[] splitStringCSV(String input) {
        return StringUtil.splitStringAtDelimiters(input, ",", "\"");
    }

    public static String[] splitStringAtDelimiters(String input, String fieldSeparators, String quoteCharacters) {
        if (fieldSeparators == null || fieldSeparators.length() == 0) {
            return new String[]{input};
        }
        StringArray ret = new StringArray();
        StringBuffer s = new StringBuffer(32);
        boolean LOOKING_FOR_NEXT_TEXT = true;
        int INSIDE_UNQUOTED = 2;
        int INSIDE_QUOTED = 3;
        int LOOKING_FOR_NEXT_DELIMITOR = 4;
        int ESCAPE_CHAR = 92;
        int state = 1;
        char openingQuote = '\u0000';
        int count = input.length();
        block12: for (int inputIndex = 0; inputIndex < count; ++inputIndex) {
            char currentChar = input.charAt(inputIndex);
            switch (state) {
                default: {
                    Dbg.trace("Bad state in StringUtil.splitStringAtDelimiters\n");
                }
                case 1: {
                    if (Character.isSpaceChar(currentChar)) continue block12;
                    if (quoteCharacters != null && quoteCharacters.indexOf(currentChar) != -1) {
                        state = 3;
                        openingQuote = currentChar;
                        continue block12;
                    }
                    if (currentChar == '\\') {
                        state = 2;
                        if (++inputIndex >= input.length()) {
                            s.append('\\');
                            break block12;
                        }
                        s.append(input.charAt(inputIndex));
                        continue block12;
                    }
                    if (fieldSeparators.indexOf(currentChar) != -1) {
                        ret.add(s.toString());
                        s = new StringBuffer(32);
                        continue block12;
                    }
                    state = 2;
                    s.append(currentChar);
                    continue block12;
                }
                case 2: {
                    if (fieldSeparators.indexOf(currentChar) != -1) {
                        while (s.length() > 0 && Character.isSpaceChar(s.charAt(s.length() - 1))) {
                            s.setLength(s.length() - 1);
                        }
                        ret.add(s.toString());
                        s = new StringBuffer(32);
                        state = 1;
                        continue block12;
                    }
                    if (currentChar == '\\' && ++inputIndex >= input.length()) {
                        s.append('\\');
                        break block12;
                    }
                    s.append(input.charAt(inputIndex));
                    continue block12;
                }
                case 3: {
                    if (currentChar == openingQuote) {
                        if (inputIndex + 1 < input.length() && input.charAt(inputIndex + 1) == openingQuote) {
                            s.append(openingQuote);
                            ++inputIndex;
                            continue block12;
                        }
                        ret.add(s.toString());
                        s = new StringBuffer(32);
                        state = 4;
                        continue block12;
                    }
                    if (currentChar == '\\' && ++inputIndex >= input.length()) {
                        s.append('\\');
                        break block12;
                    }
                    s.append(input.charAt(inputIndex));
                    continue block12;
                }
                case 4: {
                    if (fieldSeparators.indexOf(currentChar) == -1) continue block12;
                    state = 1;
                }
            }
        }
        switch (state) {
            default: {
                Dbg.trace("Bad state in StringUtil.splitStringAtDelimiters\n");
                break;
            }
            case 2: {
                while (s.length() > 0 && Character.isSpaceChar(s.charAt(s.length() - 1))) {
                    s.setLength(s.length() - 1);
                }
                ret.add(s.toString());
                break;
            }
            case 3: {
                ret.add(s.toString());
                break;
            }
            case 1: {
                if (ret.size() <= 0) break;
                ret.add("");
            }
            case 4: 
        }
        return ret.getStringArray();
    }

    public static String[] asStringArray(Collection collection) {
        String[] results = new String[collection.size()];
        return collection.toArray(results);
    }

    public static String asSingleString(Collection strings) {
        return StringUtil.asSingleString(strings, COLLECTION_ELEMENT_SEPARATOR);
    }

    public static String asSingleString(Collection items, String delim) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = items.iterator();
        buffer.append(iter.next());
        while (iter.hasNext()) {
            buffer.append(delim);
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    public static String asSingleStringAllowTrailingBlank(Collection strings) {
        if (strings == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            String s;
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            if ((s = (String)iter.next()).equals("") && !iter.hasNext()) {
                s = "\n";
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    public static String asSingleString(String[] strings) {
        return StringUtil.asSingleString(strings, COLLECTION_ELEMENT_SEPARATOR);
    }

    public static String asSingleString(String[] strings, String separator) {
        int startIndex = 0;
        return StringUtil.asSingleString(strings, startIndex, separator);
    }

    public static String asSingleString(String[] strings, int startIndex, String separator) {
        if (startIndex > strings.length) {
            throw new IllegalArgumentException("Start index (" + startIndex + ") " + "is greater than the length of the array (" + strings.length + ")");
        }
        StringBuffer buff = new StringBuffer();
        for (int i = startIndex; i < strings.length; ++i) {
            if (i > startIndex) {
                buff.append(separator);
            }
            buff.append(strings[i]);
        }
        return buff.toString();
    }

    public static String asSingleString(Map strings) {
        return StringUtil.asSingleString(strings, MAP_KEY_VALUE_SEPARATOR, COLLECTION_ELEMENT_SEPARATOR);
    }

    public static String asSingleString(Map strings, String keyValSeparator, String entrySeparator) {
        StringBuffer buff = new StringBuffer();
        for (Map.Entry entry : strings.entrySet()) {
            StringBuffer entryText = new StringBuffer((String)entry.getKey());
            entryText.append(keyValSeparator);
            entryText.append((String)entry.getValue());
            buff.append(entryText).append(entrySeparator);
        }
        return buff.toString();
    }

    public static String encode(String s, char toReplace, char replaceWith) {
        if (s == null) {
            return null;
        }
        assert (toReplace != replaceWith);
        StringBuffer buffer = new StringBuffer(s.length());
        int count = s.length();
        for (int i = 0; i < count; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                buffer.append('\\').append('\\');
                continue;
            }
            if (c == toReplace) {
                buffer.append('\\').append(replaceWith);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String unencode(String s, char replacedWith, char original) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(s.length());
        boolean escaped = false;
        int count = s.length();
        for (int i = 0; i < count; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (escaped) {
                    buffer.append('\\');
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (c == replacedWith) {
                if (escaped) {
                    buffer.append(original);
                    escaped = false;
                    continue;
                }
                buffer.append(replacedWith);
                continue;
            }
            if (escaped) {
                escaped = false;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static char charFromHexDigit(int digit) {
        return digit >= 0 && digit <= 9 ? (char)(digit + 48) : (char)(digit - 10 + 97);
    }

    public static String hexDump(char[] chars, int length) {
        length = length == 0 ? chars.length : Math.min(length, chars.length);
        byte[] bytes = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            bytes[i * 2] = (byte)(chars[i] >> 8);
            bytes[i * 2 + 1] = (byte)(chars[i] & 0xFF);
        }
        return StringUtil.hexDump(null, bytes);
    }

    public static String hexDump(char[] chars) {
        return StringUtil.hexDump(chars, 0);
    }

    public static String hexDump(byte[] bytes) {
        return StringUtil.hexDump(null, bytes);
    }

    public static String hexDump(String prefix, byte[] bytes) {
        if (bytes == null) {
            return prefix + "(null)";
        }
        StringBuffer sb = new StringBuffer();
        int chunkSize = 16;
        for (int pos = 0; pos < bytes.length; pos += 16) {
            int x;
            int lineLength;
            int n = lineLength = bytes.length - pos > 16 ? 16 : bytes.length - pos;
            if (prefix != null) {
                sb.append(prefix);
            }
            for (int d = 0; d < 8; ++d) {
                int digitValue = (pos >> 4 * (7 - d)) % 16;
                sb.append(StringUtil.charFromHexDigit(digitValue >= 0 ? digitValue : 16 + digitValue));
            }
            sb.append("  ");
            for (x = 0; x < lineLength; ++x) {
                int by = bytes[x + pos];
                int i = by >= 0 ? by : 256 + by;
                sb.append(StringUtil.charFromHexDigit(i / 16)).append(StringUtil.charFromHexDigit(i % 16));
                if (x % 2 != 1) continue;
                sb.append(' ');
            }
            x = 0;
            while ((double)x < 2.0 + (double)(16 - lineLength) * 2.5) {
                sb.append(' ');
                ++x;
            }
            for (x = 0; x < lineLength; ++x) {
                char v = (char)bytes[x + pos];
                if (v >= ' ' && v < '\u007f') {
                    sb.append(v);
                    continue;
                }
                sb.append('.');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String randomString(Random rand, int maxLen) {
        if (rand == null) {
            rand = new Random();
        }
        maxLen = rand.nextInt(maxLen - 1) + 1;
        char[] chars = new char[maxLen];
        for (int at = 0; at < maxLen; ++at) {
            chars[at] = (char)(rand.nextInt(25) + 97);
        }
        return new String(chars);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static Iterator tokenIterator(String src, char del) {
        return new SplitIterator(src, del);
    }

    public static int count(char c, String s) {
        char[] chars = s.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            ++count;
        }
        return count;
    }

    public static int indexOf(char c, int occurence, String s) {
        if (occurence <= 0) {
            return -1;
        }
        char[] chars = s.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c || ++count != occurence) continue;
            return i;
        }
        return -1;
    }

    public static String removeDuplicates(String string, char character) {
        StringBuffer clean = new StringBuffer();
        char last = '\u0000';
        int count = string.length();
        for (int i = 0; i < count; ++i) {
            char current = string.charAt(i);
            if (last != character || current != character) {
                clean.append(current);
            }
            last = current;
        }
        return clean.toString();
    }

    public static String removeTrailingCharacter(String string, char character) {
        int length = string.length();
        if (length > 1 && string.charAt(length - 1) == character) {
            return string.substring(0, length - 1);
        }
        return string;
    }

    public static boolean endsWith(String string, char chacter) {
        int length = string.length();
        return length > 0 && string.charAt(length - 1) == chacter;
    }

    public static boolean containsWildcards(String string) {
        return string.indexOf(63) != -1 || string.indexOf(42) != -1;
    }

    public static String truncateWithEllipsis(String originalString, int maxLength) {
        assert (originalString != null);
        String result = originalString;
        if (maxLength > 0 && originalString.length() > maxLength) {
            StringBuffer buff = new StringBuffer(originalString.substring(0, maxLength - 3));
            buff.append("...");
            result = buff.toString();
        }
        return result;
    }

    public static String createString(char character, int length) {
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buffer.append(character);
        }
        return buffer.toString();
    }

    public static class SplitIterator
    implements Iterator {
        final String m_src;
        final int m_length;
        final char m_delimiter;
        int m_start = -1;
        int m_pos = -1;

        public SplitIterator(String src, char delimiter) {
            this.m_src = src;
            this.m_length = src.length();
            this.m_delimiter = delimiter;
        }

        public boolean hasNext() {
            int pos = this.m_pos;
            int length = this.m_length;
            if (pos == length) {
                return false;
            }
            int start = pos + 1;
            if ((pos = this.m_src.indexOf(this.m_delimiter, start)) == -1) {
                pos = length;
            }
            this.m_start = start;
            this.m_pos = pos;
            return start != length;
        }

        public Object next() {
            return this.nextString();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String nextString() {
            return this.m_src.substring(this.m_start, this.m_pos);
        }
    }

    static class StringArray {
        private String[] m_rep;
        private int m_count = 0;

        StringArray() {
            this(256);
        }

        StringArray(int size) {
            this.m_rep = new String[size];
        }

        public void add(CharSequence s) {
            int capacity = this.m_rep.length;
            if (this.m_count >= capacity) {
                String[] rep = new String[capacity << 1];
                System.arraycopy(this.m_rep, 0, rep, 0, capacity);
                this.m_rep = rep;
            }
            this.m_rep[this.m_count++] = ((Object)s).toString();
        }

        public String[] getStringArray() {
            int capacity = this.m_rep.length;
            if (this.m_count < capacity) {
                String[] rep = new String[this.m_count];
                System.arraycopy(this.m_rep, 0, rep, 0, this.m_count);
                this.m_rep = rep;
            }
            return this.m_rep;
        }

        public int size() {
            return this.m_count;
        }
    }

    public static class EolLine
    implements CharSequence {
        protected CharSequence charSequence;
        protected int eolStart;

        public EolLine(CharSequence cs, int eolStart) {
            assert (eolStart >= 0 && eolStart <= cs.length());
            this.charSequence = cs;
            this.eolStart = eolStart;
        }

        public int length() {
            return this.charSequence.length();
        }

        public char charAt(int index) {
            return this.charSequence.charAt(index);
        }

        public CharSequence subSequence(int start, int end) {
            return this.charSequence.subSequence(start, end);
        }

        public String toString() {
            return ((Object)this.charSequence).toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof EolLine) {
                EolLine that = (EolLine)obj;
                return this.charSequence.equals(that.charSequence) && this.eolStart == that.eolStart;
            }
            return false;
        }

        public int hashCode() {
            return this.charSequence.hashCode() + this.eolStart;
        }

        public int getEolStart() {
            return this.eolStart;
        }

        public CharSequence lineWithoutEol() {
            return this.eolStart == this.charSequence.length() ? this.charSequence : this.charSequence.subSequence(0, this.eolStart);
        }
    }
}

