/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.collections.CollectionTools;
import gnu.trove.TIntObjectHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Regex {
    private static Cache sm_cache = new Cache();

    public static Pattern getPattern(String regex) {
        return Regex.getPattern(regex, 0);
    }

    public static synchronized Pattern getPattern(String regex, int flags) {
        Pattern pattern = sm_cache.get(regex, flags);
        if (pattern == null) {
            pattern = Pattern.compile(regex, flags);
            sm_cache.put(regex, flags, pattern);
        }
        return pattern;
    }

    public static Pattern wildcardToPattern(String wildcard) {
        return Regex.getPattern(Regex.wildcardToStringPattern(wildcard));
    }

    public static Pattern wildcardToPattern(String wildcard, int flags) {
        return Regex.getPattern(Regex.wildcardToStringPattern(wildcard), flags);
    }

    public static String wildcardToStringPattern(String wildcard) {
        int length = wildcard.length();
        StringBuffer regex = new StringBuffer(length * 2);
        block5: for (int i = 0; i < length; ++i) {
            char ch = wildcard.charAt(i);
            switch (ch) {
                case '*': {
                    regex.append(".*");
                    continue block5;
                }
                case '?': {
                    regex.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regex.append('\\');
                }
                default: {
                    regex.append(ch);
                }
            }
        }
        return regex.toString();
    }

    static class Cache {
        private Map m_patternMap = CollectionTools.createMap();

        Cache() {
        }

        public Pattern get(String regex, int flags) {
            TIntObjectHashMap flaggedPatternMap = (TIntObjectHashMap)this.m_patternMap.get(regex);
            if (flaggedPatternMap != null) {
                return (Pattern)flaggedPatternMap.get(flags);
            }
            return null;
        }

        public void put(String regex, int flags, Pattern pattern) {
            TIntObjectHashMap flaggedPatternMap = (TIntObjectHashMap)this.m_patternMap.get(regex);
            if (flaggedPatternMap == null) {
                flaggedPatternMap = new TIntObjectHashMap();
                this.m_patternMap.put(regex, flaggedPatternMap);
            }
            flaggedPatternMap.put(flags, pattern);
        }
    }
}

