/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostDiskDimensionsLba;
import com.vmware.vim25.HostScsiDisk;
import com.vmware.vim25.ScsiLunDurableName;

public class HostScsiDiskCollector
extends AbstractVmwareCollector {
    public HostScsiDiskCollector() {
        super(HostScsiDisk.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostScsiDisk";
        if (o instanceof HostScsiDisk) {
            Integer queueDepth;
            HostScsiDisk hostScsiDisk = (HostScsiDisk)o;
            ScsiLunDurableName[] alternateNames = hostScsiDisk.getAlternateName();
            if (null != alternateNames) {
                for (int ii = 0; ii < alternateNames.length; ++ii) {
                    if (null == alternateNames[ii]) continue;
                    this.doCollect(alternateNames[ii], curKey + ".AlternateName" + ii);
                }
            }
            String canonicalName = hostScsiDisk.getCanonicalName();
            this.doPut(curKey + ".CanonicalName", canonicalName);
            HostDiskDimensionsLba capacity = hostScsiDisk.getCapacity();
            this.doCollect(capacity, curKey);
            String deviceName = hostScsiDisk.getDeviceName();
            this.doPut(curKey + ".DeviceName", deviceName);
            String devicePath = hostScsiDisk.getDevicePath();
            this.doPut(curKey + ".DevicePath", devicePath);
            String deviceType = hostScsiDisk.getDeviceType();
            this.doPut(curKey + ".DeviceType", deviceType);
            ScsiLunDurableName durableName = hostScsiDisk.getDurableName();
            this.doCollect(durableName, curKey);
            String key = hostScsiDisk.getKey();
            this.doPut(curKey + ".Key", key);
            String lunType = hostScsiDisk.getLunType();
            this.doPut(curKey + ".LunType", lunType);
            String model = hostScsiDisk.getModel();
            this.doPut(curKey + ".Model", model);
            String[] operationalStates = hostScsiDisk.getOperationalState();
            if (null != operationalStates) {
                for (int ii = 0; ii < operationalStates.length; ++ii) {
                    if (null == operationalStates[ii]) continue;
                    this.doPut(curKey + ".OperationalState" + ii, operationalStates[ii]);
                }
            }
            if (null != (queueDepth = hostScsiDisk.getQueueDepth())) {
                this.doPut(curKey + ".QueueDepth", "" + queueDepth);
            }
            String revision = hostScsiDisk.getRevision();
            this.doPut(curKey + ".Revision", revision);
            Integer scsiLevel = hostScsiDisk.getScsiLevel();
            if (null != scsiLevel) {
                this.doPut(curKey + ".ScsiLevel", "" + scsiLevel);
            }
            String serialNumber = hostScsiDisk.getSerialNumber();
            this.doPut(curKey + ".SerialNumber", serialNumber);
            byte[] standardInquiry = hostScsiDisk.getStandardInquiry();
            if (null != standardInquiry) {
                for (int ii = 0; ii < standardInquiry.length; ++ii) {
                    this.doPut(curKey + ".StandardInquiry" + ii, "" + standardInquiry[ii]);
                }
            }
            String uuid = hostScsiDisk.getUuid();
            this.doPut(curKey + ".Uuid", uuid);
            String vendor = hostScsiDisk.getVendor();
            this.doPut(curKey + ".Vendor", vendor);
        }
    }
}

