/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.HostAutoStartManagerConfig;
import com.vmware.vim25.HostConfigInfo;
import com.vmware.vim25.HostDatastoreSystemCapabilities;
import com.vmware.vim25.HostDateTimeInfo;
import com.vmware.vim25.HostDiagnosticPartition;
import com.vmware.vim25.HostFileSystemVolumeInfo;
import com.vmware.vim25.HostFirewallInfo;
import com.vmware.vim25.HostFlagInfo;
import com.vmware.vim25.HostHyperThreadScheduleInfo;
import com.vmware.vim25.HostNetCapabilities;
import com.vmware.vim25.HostNetOffloadCapabilities;
import com.vmware.vim25.HostNetworkInfo;
import com.vmware.vim25.HostServiceInfo;
import com.vmware.vim25.HostStorageDeviceInfo;
import com.vmware.vim25.HostSystemResourceInfo;
import com.vmware.vim25.HostVMotionInfo;
import com.vmware.vim25.OptionDef;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.ServiceConsoleReservationInfo;
import com.vmware.vim25.VirtualMachineMemoryReservationInfo;

public class HostConfigInfoCollector
extends AbstractVmwareCollector {
    public HostConfigInfoCollector() {
        super(HostConfigInfo.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostConfigInfo";
        if (o instanceof HostConfigInfo) {
            OptionDef[] optionDefs;
            HostConfigInfo hostConfigInfo = (HostConfigInfo)o;
            HostDiagnosticPartition activeDiagnosticPartition = hostConfigInfo.getActiveDiagnosticPartition();
            this.doCollect(activeDiagnosticPartition, curKey);
            Boolean adminDisabled = hostConfigInfo.getAdminDisabled();
            this.doPut(curKey + ".adminDisabled", adminDisabled, Boolean.FALSE);
            HostAutoStartManagerConfig autoStart = hostConfigInfo.getAutoStart();
            this.doCollect(autoStart, curKey);
            HostNetCapabilities capabilities = hostConfigInfo.getCapabilities();
            this.doCollect(capabilities, curKey);
            ServiceConsoleReservationInfo consoleReservation = hostConfigInfo.getConsoleReservation();
            this.doCollect(consoleReservation, curKey);
            HostDatastoreSystemCapabilities datastoreCapabilities = hostConfigInfo.getDatastoreCapabilities();
            this.doCollect(datastoreCapabilities, curKey);
            HostDateTimeInfo dateTimeInfo = hostConfigInfo.getDateTimeInfo();
            this.doCollect(dateTimeInfo, curKey);
            HostFileSystemVolumeInfo fileSystemVolume = hostConfigInfo.getFileSystemVolume();
            this.doCollect(fileSystemVolume, curKey);
            HostFirewallInfo firewall = hostConfigInfo.getFirewall();
            this.doCollect(firewall, curKey);
            HostFlagInfo flags = hostConfigInfo.getFlags();
            this.doCollect(flags, curKey);
            HostHyperThreadScheduleInfo hyperThread = hostConfigInfo.getHyperThread();
            this.doCollect(hyperThread, curKey);
            HostNetworkInfo network = hostConfigInfo.getNetwork();
            this.doCollect(network, curKey);
            HostNetOffloadCapabilities offloadCapabilities = hostConfigInfo.getOffloadCapabilities();
            this.doCollect(offloadCapabilities, curKey);
            OptionValue[] optionValues = hostConfigInfo.getOption();
            this.doCollect(fileSystemVolume, curKey);
            if (null != optionValues) {
                for (int ii = 0; ii < optionValues.length; ++ii) {
                    if (null == optionValues[ii]) continue;
                    String key = optionValues[ii].getKey();
                    if (null == key || key.length() == 0) {
                        key = "" + ii;
                    }
                    this.doCollect(optionValues[ii], curKey + ".optionValue." + key);
                }
            }
            if (null != (optionDefs = hostConfigInfo.getOptionDef())) {
                for (int ii = 0; ii < optionDefs.length; ++ii) {
                    if (null == optionDefs[ii]) continue;
                    this.doCollect(optionDefs[ii], curKey + ".optionDef" + ii);
                }
            }
            AboutInfo product = hostConfigInfo.getProduct();
            this.doCollect(product, curKey);
            HostServiceInfo service = hostConfigInfo.getService();
            this.doCollect(service, curKey);
            HostStorageDeviceInfo storageDevice = hostConfigInfo.getStorageDevice();
            this.doCollect(storageDevice, curKey);
            HostSystemResourceInfo systemResources = hostConfigInfo.getSystemResources();
            this.doCollect(systemResources, curKey);
            VirtualMachineMemoryReservationInfo virtualMachineReservation = hostConfigInfo.getVirtualMachineReservation();
            this.doCollect(virtualMachineReservation, curKey);
            HostVMotionInfo vmotion = hostConfigInfo.getVmotion();
            this.doCollect(vmotion, curKey);
        }
    }
}

