/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import com.tripwire.checker.accessor.BaseAccessor;
import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.common.util.StreamUtil;
import com.tripwire.vmware.api.EsxServer;
import com.tripwire.vmware.api.HostCredentials;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

public class GetHostAccessor
extends BaseAccessor {
    public static final String ACCESSOR_NAME = "HttpGet";
    private String[][] files = new String[][]{{"", "hostDirectory"}, {"config.log", "config.log"}, {"esx.conf", "/etc/vmware/esx.conf"}, {"hostAgentConfig.parser", "/etc/vmware/hostd/config.parser"}, {"hosts", "/etc/hosts"}, {"license.cfg", "/etc/vmware/licenses.cfg"}, {"motd", "/etc/motd"}, {"openwsman.conf", "/etc/opwsman/openwsman.conf"}, {"proxy.parser", "/etc/vmware/hostd/proxy.parser"}, {"sfcb.cfg", "sfcb.parser"}, {"snmp.parser", "/etc/vmware/snmp.parser"}, {"ssl_cert", "/etc/vmware/ssl/rui.crt"}, {"syslog.conf", "/etc/syslog.conf"}, {"vmware.lic", "/etc/vmware.lic"}, {"vmware_config", "/etc/vmware/config"}, {"vmware_configrules", "/etc/vmware/configrules"}};

    public GetHostAccessor(HostCredentials hostCredentials) {
        this.setHostCredentials(hostCredentials);
    }

    public String getName() {
        return ACCESSOR_NAME;
    }

    public void access() throws Exception {
        EsxServer server = new EsxServer(this.getHostCredentials());
        String baseUrl = "https://" + this.getHostCredentials().getHost() + "/host";
        for (int ii = 0; ii < this.files.length; ++ii) {
            String curFile = this.files[ii][0];
            String curElementName = this.files[ii][1];
            try {
                this.getFile(server, baseUrl, curFile, curElementName);
                continue;
            }
            catch (FileNotFoundException e) {
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            catch (KeyManagementException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFile(EsxServer server, String baseUrl, String curFile, String curElementName) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        String fileUrl = curFile.length() > 0 ? baseUrl + "/" + curFile : baseUrl;
        InputStream in = null;
        try {
            in = this.getFile(server, fileUrl);
            String fileContents = StreamUtil.getString(in);
            ElementCache.getInstance().put(curElementName, fileContents);
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
    }
}

