/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import com.tripwire.checker.accessor.ConfigBackupAccessor;
import com.tripwire.checker.accessor.GetHostAccessor;
import com.tripwire.checker.accessor.LogBundlesAccessor;
import com.tripwire.checker.accessor.SoapAccessor;
import com.tripwire.checker.accessor.SshAccessor;
import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.common.time.Time;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.vmware.api.EsxServer;
import com.tripwire.vmware.api.HostCredentials;
import com.vmware.vim25.InvalidLogin;
import org.apache.axis.AxisFault;

public class AccessRunner
implements Runnable {
    private HostCredentials m_hostCredentials;
    private boolean m_sshAccessor = true;
    private boolean m_logBundlesAccessor = false;
    private boolean m_configBackupAccessor = false;
    private boolean m_soapAccessor = true;
    private boolean m_httpGetAccessor = true;
    private boolean m_printDetail = false;
    private boolean m_printContent = false;
    private String m_rulesFile;
    private ConfigCheckerListener m_listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsxServer.Version prepare() throws CheckerException {
        long startTime = Time.now();
        EsxServer.Version version = null;
        this.setLogBundlesAccessor(false);
        this.setConfigBackupAccessor(false);
        this.setHttpGetAccessor(false);
        EsxServer server = null;
        try {
            server = new EsxServer(this.getHostCredentials());
            version = server.getVersion();
            if (null != version && version.isProductLineEmbedded()) {
                this.setSshAccessor(false);
                this.getListener().onAccessorStart("SSH");
                this.getListener().onAccessorEnd("SSH", Time.now() - startTime, AccessorResultType.NOT_SUPPORTED, null);
                if (!Boolean.getBoolean("tw.3i")) {
                    throw new CheckerException("tw.error.3iNotSupported");
                }
            } else {
                this.setSoapAccessor(false);
            }
        }
        catch (InvalidLogin e) {
            throw new CheckerException(e, "tw.error.invalidLogin", null);
        }
        catch (AxisFault e) {
            String faultString = e.getFaultString();
            if (null != faultString && faultString.startsWith("java.net.UnknownHostException")) {
                throw new CheckerException(e, "tw.error.unknownHost", null);
            }
            if (null != faultString && faultString.startsWith("Unsupported namespace in content of SOAP Body")) {
                this.soapUnavailable(startTime, e);
            } else {
                this.soapUnavailable(startTime, e);
            }
        }
        catch (CheckerException e) {
            throw e;
        }
        catch (Exception e) {
            this.soapUnavailable(startTime, e);
        }
        finally {
            if (null != server) {
                try {
                    server.close();
                }
                catch (Exception e) {}
            }
        }
        return version;
    }

    private void soapUnavailable(long startTime, Exception e) {
        this.getListener().onAccessorStart("SOAP");
        this.getListener().onAccessorEnd("SOAP", Time.now() - startTime, AccessorResultType.UNAVAILABLE, new CheckerException(e, "tw.checker.soap.unavailable", null));
    }

    public void run() {
        try {
            HostCredentials curHost = this.getHostCredentials();
            Thread hostThread = null;
            Thread logBundlesThread = null;
            Thread configBackupThread = null;
            Thread soapThread = null;
            Thread sshThread = null;
            if (this.isHttpGetAccessor()) {
                GetHostAccessor host = new GetHostAccessor(curHost);
                host.setListener(this.getListener());
                hostThread = new Thread(host);
                hostThread.start();
            }
            if (this.isSoapAccessor()) {
                SoapAccessor soap = new SoapAccessor(curHost);
                soap.setListener(this.getListener());
                soapThread = new Thread(soap);
                soapThread.start();
            }
            if (this.isLogBundlesAccessor()) {
                LogBundlesAccessor logBundles = new LogBundlesAccessor(curHost);
                logBundles.setListener(this.getListener());
                logBundlesThread = new Thread(logBundles);
                logBundlesThread.start();
            }
            if (this.isConfigBackupAccessor()) {
                ConfigBackupAccessor configBackup = new ConfigBackupAccessor(curHost);
                configBackup.setListener(this.getListener());
                configBackupThread = new Thread(configBackup);
                configBackupThread.start();
            }
            SshAccessor ssh = null;
            if (this.isSshAccessor()) {
                ssh = new SshAccessor(curHost);
                ssh.setRulesFile(this.getRulesFile());
                ssh.setListener(this.getListener());
                sshThread = new Thread(ssh);
                sshThread.start();
            }
            if (null != sshThread) {
                sshThread.join();
            }
            if (null != soapThread) {
                soapThread.join();
            }
            if (null != hostThread) {
                hostThread.join();
            }
            if (null != configBackupThread) {
                configBackupThread.join();
            }
            if (null != ssh && ssh.getResult() == AccessorResultType.FINISHED_SUCCESSFULLY) {
                if (null != logBundlesThread) {
                    logBundlesThread.interrupt();
                }
            } else if (null != logBundlesThread) {
                logBundlesThread.join();
            }
        }
        catch (Exception e) {
            this.getListener().onFatalError(new CheckerException(e, "tw.checker.app.accessRunner", null));
        }
    }

    public HostCredentials getHostCredentials() {
        return this.m_hostCredentials;
    }

    public void setHostCredentials(HostCredentials hostCredentials) {
        this.m_hostCredentials = hostCredentials;
    }

    public boolean isSshAccessor() {
        return this.m_sshAccessor;
    }

    public void setSshAccessor(boolean sshAccessor) {
        this.m_sshAccessor = sshAccessor;
    }

    public boolean isLogBundlesAccessor() {
        return this.m_logBundlesAccessor;
    }

    public void setLogBundlesAccessor(boolean logBundlesAccessor) {
        this.m_logBundlesAccessor = logBundlesAccessor;
    }

    public boolean isConfigBackupAccessor() {
        return this.m_configBackupAccessor;
    }

    public void setConfigBackupAccessor(boolean configBackupAccessor) {
        this.m_configBackupAccessor = configBackupAccessor;
    }

    public boolean isHttpGetAccessor() {
        return this.m_httpGetAccessor;
    }

    public void setHttpGetAccessor(boolean httpGetAccessor) {
        this.m_httpGetAccessor = httpGetAccessor;
    }

    public boolean isPrintDetail() {
        return this.m_printDetail;
    }

    public void setPrintDetail(boolean printDetail) {
        this.m_printDetail = printDetail;
    }

    public boolean isPrintContent() {
        return this.m_printContent;
    }

    public void setPrintContent(boolean printContent) {
        this.m_printContent = printContent;
    }

    public ConfigCheckerListener getListener() {
        return this.m_listener;
    }

    public void setListener(ConfigCheckerListener listener) {
        this.m_listener = listener;
    }

    public String getRulesFile() {
        return this.m_rulesFile;
    }

    public void setRulesFile(String rulesFile) {
        this.m_rulesFile = rulesFile;
    }

    public boolean isSoapAccessor() {
        return this.m_soapAccessor;
    }

    public void setSoapAccessor(boolean soapAccessor) {
        this.m_soapAccessor = soapAccessor;
    }

    static {
        ResourceManager.getInstance().addStandardResources(AccessRunner.class);
    }
}

