/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.SwingConvenience;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import com.mindbright.terminal.TerminalOption;
import com.mindbright.terminal.TerminalWin;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class TerminalMenuHandlerFullSwing
extends TerminalMenuHandlerFull {
    private JMenu vtOptionsMenu;
    private JComponent[] vtoptions;
    private TerminalOption[] toptions;
    private JComboBox comboTE;
    private JComboBox comboEN;
    private JComboBox comboFN;
    private JComboBox comboSB;
    private JComboBox comboPB;
    private JComboBox comboFG;
    private JComboBox comboBG;
    private JComboBox comboCC;
    private JTextField textFS;
    private JTextField textRows;
    private JTextField textCols;
    private JTextField textInitPos;
    private JTextField textSL;
    private JTextField textSD;
    private JTextField textFG;
    private JTextField textBG;
    private JTextField textCC;
    private JLabel lblAlert;
    private JTextField findText;
    private JCheckBox dirCheck;
    private JCheckBox caseCheck;
    private JButton findBut;
    private JButton cancBut;
    private JPopupMenu popupMenu = null;

    protected void setEnabled(int n, int n2, boolean bl) {
        ((JMenuItem)this.menuItems[n][n2]).setEnabled(bl);
    }

    protected void setState(int n, int n2, boolean bl) {
        ((JCheckBoxMenuItem)this.menuItems[n][n2]).setSelected(bl);
    }

    protected boolean getState(int n, int n2) {
        return ((JCheckBoxMenuItem)this.menuItems[n][n2]).isSelected();
    }

    protected void addBasicMenusInternal(Frame frame) {
        JMenuBar jMenuBar = ((JFrame)frame).getJMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new JMenuBar();
            ((JFrame)frame).setJMenuBar(jMenuBar);
        }
        jMenuBar.add((JMenu)this.getMenu(0));
        jMenuBar.add((JMenu)this.getMenu(1));
        jMenuBar.add((JMenu)this.getMenu(2));
    }

    public Object getMenu(int n) {
        JMenu jMenu = new JMenu(TerminalMenuHandlerFull.menuTexts[n][0]);
        int n2 = TerminalMenuHandlerFull.menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new JMenuItem[TerminalMenuHandlerFull.menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new JMenuItem[TerminalMenuHandlerFull.menuTexts[n].length];
        }
        for (int i = 1; i < n2; ++i) {
            JMenuItem jMenuItem;
            String string = TerminalMenuHandlerFull.menuTexts[n][i];
            if (string == null) {
                jMenu.addSeparator();
                continue;
            }
            if (string.charAt(0) == '_') {
                string = string.substring(1);
                jMenuItem = new JCheckBoxMenuItem(string);
                ((JCheckBoxMenuItem)jMenuItem).addItemListener(this);
            } else {
                jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(this);
            }
            if (TerminalMenuHandlerFull.menuShortCuts[n][i] != -1) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(TerminalMenuHandlerFull.menuShortCuts[n][i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            }
            this.menuItems[n][i] = jMenuItem;
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private Component getVTOptionsPanel(boolean bl) {
        int n;
        int n2;
        if (bl) {
            this.toptions = this.term.getOptions();
            this.vtoptions = new JComponent[this.toptions.length];
            n2 = 0;
            n = this.toptions.length / 2;
        } else {
            n2 = this.toptions.length / 2;
            n = this.toptions.length;
        }
        if (this.toptions == null || this.toptions.length == 0) {
            return null;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        for (int i = n2; i < n; ++i) {
            String[] stringArray = this.toptions[i].getChoices();
            if (stringArray == null) {
                this.vtoptions[i] = new JCheckBox(this.toptions[i].getDescription(), this.toptions[i].getValueB());
            } else {
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)new JLabel(this.toptions[i].getDescription(), 4), gridBagConstraints);
                this.vtoptions[i] = new JComboBox<String>(stringArray);
                ((JComboBox)this.vtoptions[i]).setSelectedItem(this.toptions[i].getValue().toLowerCase());
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 0;
            }
            jPanel.add((Component)this.vtoptions[i], gridBagConstraints);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.getViewport().setBackground(new Color(jPanel.getBackground().getRGB()));
        return jScrollPane;
    }

    private void setVTOptions() {
        if (this.vtoptions == null) {
            return;
        }
        for (int i = 0; i < this.vtoptions.length; ++i) {
            String string = this.vtoptions[i] instanceof JComboBox ? (String)((JComboBox)this.vtoptions[i]).getSelectedItem() : (((JCheckBox)this.vtoptions[i]).isSelected() ? "true" : "false");
            this.setProperty(this.toptions[i].getKey(), string);
        }
        this.vtoptions = null;
        this.toptions = null;
    }

    public void termSettingsDialog(String string) {
        final JDialog jDialog = new JDialog(this.term.ownerFrame, string, true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        this.comboTE = new JComboBox<String>(TerminalMenuHandlerFull.TERMINAL_TYPES);
        jPanel.add((Component)new JLabel("Terminal type", 4), gridBagConstraints);
        jPanel.add((Component)this.comboTE, gridBagConstraints2);
        this.textCols = new JTextField("", 3);
        jPanel.add((Component)new JLabel("Columns", 4), gridBagConstraints);
        jPanel.add((Component)this.textCols, gridBagConstraints2);
        this.textRows = new JTextField("", 3);
        jPanel.add((Component)new JLabel("Rows", 4), gridBagConstraints);
        jPanel.add((Component)this.textRows, gridBagConstraints2);
        this.comboEN = new JComboBox<String>(TerminalMenuHandlerFull.ENCODINGS);
        this.comboEN.setEditable(true);
        jPanel.add((Component)new JLabel("Encoding", 4), gridBagConstraints);
        jPanel.add((Component)this.comboEN, gridBagConstraints2);
        this.comboFN = new JComboBox<String>(TerminalMenuHandlerFull.FONT_LIST);
        jPanel.add((Component)new JLabel("Font", 4), gridBagConstraints);
        jPanel.add((Component)this.comboFN, gridBagConstraints2);
        this.textFS = new JTextField("", 3);
        jPanel.add((Component)new JLabel("Size", 4), gridBagConstraints);
        jPanel.add((Component)this.textFS, gridBagConstraints2);
        this.textSL = new JTextField("", 3);
        jPanel.add((Component)new JLabel("Scrollback buffer", 4), gridBagConstraints);
        jPanel.add((Component)this.textSL, gridBagConstraints2);
        this.comboSB = new JComboBox<String>(TerminalMenuHandlerFull.SCROLLBAR_POS);
        jPanel.add((Component)new JLabel("Scrollbar position", 4), gridBagConstraints);
        jPanel.add((Component)this.comboSB, gridBagConstraints2);
        this.lblAlert = new JLabel("", 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.gridwidth = 0;
        jPanel.add((Component)this.lblAlert, gridBagConstraints3);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("General", jPanel);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TerminalMenuHandlerFullSwing.this.updateColors();
            }
        };
        this.comboFG = new JComboBox();
        this.comboFG.addItemListener(itemListener);
        this.textFG = new JTextField("", 10);
        jPanel.add((Component)new JLabel("Foreground color", 4), gridBagConstraints3);
        jPanel.add((Component)this.comboFG, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 0;
        jPanel.add((Component)this.textFG, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 1;
        this.comboBG = new JComboBox();
        this.comboBG.addItemListener(itemListener);
        this.textBG = new JTextField("", 10);
        jPanel.add((Component)new JLabel("Background color", 4), gridBagConstraints3);
        jPanel.add((Component)this.comboBG, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 0;
        jPanel.add((Component)this.textBG, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 1;
        this.comboCC = new JComboBox();
        this.comboCC.addItemListener(itemListener);
        this.textCC = new JTextField("", 10);
        jPanel.add((Component)new JLabel("Cursor color", 4), gridBagConstraints3);
        jPanel.add((Component)this.comboCC, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 0;
        jPanel.add((Component)this.textCC, gridBagConstraints3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints3);
        jTabbedPane.addTab("Colors", jPanel);
        gridBagConstraints3 = new GridBagConstraints();
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridwidth = 1;
        jPanel.add((Component)new JLabel("Paste button", 4), gridBagConstraints3);
        this.comboPB = new JComboBox<String>(TerminalMenuHandlerFull.PASTE_BUTTON);
        gridBagConstraints3.gridwidth = 0;
        jPanel.add((Component)this.comboPB, gridBagConstraints3);
        gridBagConstraints3.gridwidth = 1;
        jPanel.add((Component)new JLabel("Select delim.", 4), gridBagConstraints3);
        this.textSD = new JTextField("", 8);
        gridBagConstraints3.gridwidth = 0;
        jPanel.add((Component)this.textSD, gridBagConstraints3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints3);
        jTabbedPane.addTab("Misc", jPanel);
        Component component = this.getVTOptionsPanel(true);
        if (component != null) {
            jTabbedPane.addTab("VT 1", component);
        }
        if ((component = this.getVTOptionsPanel(false)) != null) {
            jTabbedPane.addTab("VT 2", component);
        }
        jDialog.getContentPane().add((Component)jTabbedPane, "Center");
        jTabbedPane.setSelectedIndex(0);
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        JPanel jPanel2 = SwingConvenience.newButtonPanel(new JButton[]{jButton, jButton2});
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TerminalMenuHandlerFullSwing.this.setVTOptions();
                    TerminalMenuHandlerFullSwing.this.setProperty("term-type", TerminalMenuHandlerFull.TERMINAL_TYPES[TerminalMenuHandlerFullSwing.this.comboTE.getSelectedIndex()]);
                    TerminalMenuHandlerFullSwing.this.setProperty("encoding", (String)TerminalMenuHandlerFullSwing.this.comboEN.getSelectedItem());
                    TerminalMenuHandlerFullSwing.this.setProperty("font-name", TerminalMenuHandlerFull.FONT_LIST[TerminalMenuHandlerFullSwing.this.comboFN.getSelectedIndex()]);
                    TerminalMenuHandlerFullSwing.this.setProperty("font-size", TerminalMenuHandlerFullSwing.this.textFS.getText());
                    TerminalMenuHandlerFullSwing.this.setProperty("scrollbar", TerminalMenuHandlerFull.SCROLLBAR_POS[TerminalMenuHandlerFullSwing.this.comboSB.getSelectedIndex()]);
                    TerminalMenuHandlerFullSwing.this.setProperty("save-lines", TerminalMenuHandlerFullSwing.this.textSL.getText());
                    TerminalMenuHandlerFullSwing.this.setProperty("geometry", TerminalMenuHandlerFullSwing.this.textCols.getText() + "x" + TerminalMenuHandlerFullSwing.this.textRows.getText());
                    TerminalMenuHandlerFullSwing.this.setProperty("paste-button", TerminalMenuHandlerFull.PASTE_BUTTON[TerminalMenuHandlerFullSwing.this.comboPB.getSelectedIndex()]);
                    TerminalMenuHandlerFullSwing.this.setProperty("select-delim", TerminalMenuHandlerFullSwing.this.textSD.getText());
                    TerminalMenuHandlerFullSwing.this.setProperty("fg-color", TerminalMenuHandlerFullSwing.getSelectedColor(TerminalMenuHandlerFullSwing.this.comboFG, TerminalMenuHandlerFullSwing.this.textFG));
                    TerminalMenuHandlerFullSwing.this.setProperty("bg-color", TerminalMenuHandlerFullSwing.getSelectedColor(TerminalMenuHandlerFullSwing.this.comboBG, TerminalMenuHandlerFullSwing.this.textBG));
                    TerminalMenuHandlerFullSwing.this.setProperty("cursor-color", TerminalMenuHandlerFullSwing.getSelectedColor(TerminalMenuHandlerFullSwing.this.comboCC, TerminalMenuHandlerFullSwing.this.textCC));
                    jDialog.dispose();
                }
                catch (Exception exception) {
                    TerminalMenuHandlerFullSwing.this.lblAlert.setText(exception.getMessage());
                }
            }
        });
        jButton2.addActionListener(new AWTConvenience.CloseAction(jDialog));
        jDialog.getContentPane().add((Component)jPanel2, "South");
        this.comboTE.setSelectedItem(this.getProperty("term-type"));
        this.comboEN.setSelectedItem(this.getProperty("encoding"));
        this.comboFN.setSelectedItem(this.getProperty("font-name"));
        this.textFS.setText(this.getProperty("font-size"));
        this.textCols.setText(String.valueOf(this.term.cols()));
        this.textRows.setText(String.valueOf(this.term.rows()));
        this.comboSB.setSelectedItem(this.getProperty("scrollbar"));
        this.textSL.setText(this.getProperty("save-lines"));
        this.comboPB.setSelectedItem(this.getProperty("paste-button"));
        String string2 = this.getProperty("select-delim");
        if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        this.textSD.setText(string2);
        this.comboBG.addItem("custom rgb");
        this.comboFG.addItem("custom rgb");
        this.comboCC.addItem("custom rgb");
        for (int i = 0; i < TerminalWin.termColorNames.length; ++i) {
            this.comboBG.addItem(TerminalWin.termColorNames[i]);
            this.comboFG.addItem(TerminalWin.termColorNames[i]);
            this.comboCC.addItem(TerminalWin.termColorNames[i]);
        }
        TerminalMenuHandlerFullSwing.initColorSelect(this.comboFG, this.textFG, this.getProperty("fg-color"));
        TerminalMenuHandlerFullSwing.initColorSelect(this.comboBG, this.textBG, this.getProperty("bg-color"));
        TerminalMenuHandlerFullSwing.initColorSelect(this.comboCC, this.textCC, this.getProperty("cursor-color"));
        this.updateColors();
        this.lblAlert.setText("");
        jDialog.setResizable(true);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        this.comboTE.requestFocus();
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    private static void initColorSelect(JComboBox jComboBox, JTextField jTextField, String string) {
        if (Character.isDigit(string.charAt(0))) {
            jComboBox.setSelectedItem("custom rgb");
            jTextField.setText(string);
        } else {
            jTextField.setText("");
            jTextField.setEnabled(false);
            jComboBox.setSelectedItem(string);
        }
    }

    private static void checkColorSelect(JComboBox jComboBox, JTextField jTextField) {
        int n = jComboBox.getSelectedIndex();
        if (n <= 0) {
            if (!jTextField.isEnabled()) {
                jTextField.setEditable(true);
                jTextField.setEnabled(true);
                jTextField.setBackground(SystemColor.text);
                jTextField.requestFocus();
            }
        } else {
            jTextField.setText("");
            jTextField.setEditable(false);
            jTextField.setEnabled(false);
            jTextField.setBackground(TerminalWin.termColors[n - 1]);
        }
    }

    private void updateColors() {
        TerminalMenuHandlerFullSwing.checkColorSelect(this.comboFG, this.textFG);
        TerminalMenuHandlerFullSwing.checkColorSelect(this.comboBG, this.textBG);
        TerminalMenuHandlerFullSwing.checkColorSelect(this.comboCC, this.textCC);
    }

    private static String getSelectedColor(JComboBox jComboBox, JTextField jTextField) {
        return jComboBox.getSelectedIndex() == 0 ? jTextField.getText() : (String)jComboBox.getSelectedItem();
    }

    public void findDialog(String string) {
        this.lastSearch = null;
        JDialog jDialog = SwingConvenience.newBorderJDialog(this.term.ownerFrame, string, false);
        jDialog.getContentPane().setLayout(new FlowLayout(0));
        Box box = new Box(1);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Find"));
        this.findText = new JTextField("", 20);
        jPanel.add(this.findText);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0));
        this.caseCheck = new JCheckBox("Case sensitive");
        jPanel.add(this.caseCheck);
        this.dirCheck = new JCheckBox("Find backwards");
        jPanel.add(this.dirCheck);
        box.add(jPanel);
        jDialog.getContentPane().add(box);
        jPanel = new JPanel(new GridLayout(0, 1, 0, 5));
        this.findBut = new JButton("Find");
        jPanel.add(this.findBut);
        this.cancBut = new JButton("Cancel");
        jPanel.add(this.cancBut);
        jDialog.getContentPane().add(jPanel);
        this.cancBut.addActionListener(new AWTConvenience.CloseAction(jDialog));
        this.findBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TerminalMenuHandlerFullSwing.this.findText.getText();
                if (string != null && string.length() > 0) {
                    TerminalMenuHandlerFullSwing.this.doFind(string, TerminalMenuHandlerFullSwing.this.caseCheck.isSelected(), TerminalMenuHandlerFullSwing.this.dirCheck.isSelected());
                }
            }
        });
        jDialog.setResizable(true);
        jDialog.pack();
        AWTConvenience.placeDialog(jDialog);
        this.findText.requestFocus();
        jDialog.addWindowListener(SwingConvenience.getWindowDisposer());
        ((Component)jDialog).setVisible(true);
    }

    public void setPopupMenu(Object object) {
        this.popupMenu = (JPopupMenu)object;
    }

    public void showPopupMenu(int n, int n2) {
        if (this.popupMenu != null) {
            this.popupMenu.show(this.term.ownerFrame, n, n2);
        }
    }
}

