/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.asn1.ASN1DER;
import com.mindbright.asn1.ASN1Integer;
import com.mindbright.asn1.ASN1OIDRegistry;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.asn1.ASN1Sequence;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.interfaces.DSAParams;
import com.mindbright.jca.security.interfaces.DSAPrivateKey;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.jca.security.interfaces.RSAPrivateCrtKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.jca.security.spec.DSAPrivateKeySpec;
import com.mindbright.jca.security.spec.DSAPublicKeySpec;
import com.mindbright.jca.security.spec.KeySpec;
import com.mindbright.jca.security.spec.RSAPrivateCrtKeySpec;
import com.mindbright.jca.security.spec.RSAPublicKeySpec;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.spec.IvParameterSpec;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.security.pkcs1.RSAPrivateKey;
import com.mindbright.ssh2.SSH2AccessDeniedException;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.util.ASCIIArmour;
import com.mindbright.util.HexDump;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;

public class SSH2KeyPairFile {
    private static final int TYPE_PEM_DSA = 0;
    private static final int TYPE_PEM_RSA = 1;
    private static final int TYPE_SSHCOM_DSA = 2;
    public static final String[] BEGIN_PRV_KEY = new String[]{"-----BEGIN DSA PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----", "---- BEGIN SSH2 ENCRYPTED PRIVATE KEY ----"};
    public static final String[] END_PRV_KEY = new String[]{"-----END DSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----", "---- END SSH2 ENCRYPTED PRIVATE KEY ----"};
    public static final int SSH_PRIVATE_KEY_MAGIC = 1064303083;
    public static final String PRV_PROCTYPE = "Proc-Type";
    public static final String PRV_DEKINFO = "DEK-Info";
    public static final String FILE_SUBJECT = "Subject";
    public static final String FILE_COMMENT = "Comment";
    private KeyPair keyPair;
    private ASCIIArmour armour;
    private String subject;
    private String comment;
    private boolean sshComFormat;

    public SSH2KeyPairFile(KeyPair keyPair, String string, String string2) {
        this.keyPair = keyPair;
        this.armour = new ASCIIArmour("----");
        this.subject = string;
        this.comment = string2;
    }

    public SSH2KeyPairFile() {
        this(null, null, null);
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public ASCIIArmour getArmour() {
        return this.armour;
    }

    public boolean isSSHComFormat() {
        return this.sshComFormat;
    }

    public String getAlgorithmName() {
        PublicKey publicKey = this.keyPair.getPublic();
        String string = null;
        if (publicKey instanceof DSAPublicKey) {
            string = "ssh-dss";
        } else if (publicKey instanceof RSAPublicKey) {
            string = "ssh-rsa";
        }
        return string;
    }

    public int getBitLength() {
        PublicKey publicKey = this.keyPair.getPublic();
        if (publicKey instanceof DSAPublicKey) {
            return ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        return ((RSAPublicKey)publicKey).getModulus().bitLength();
    }

    public static byte[] writeKeyPair(ASCIIArmour aSCIIArmour, String string, SecureRandom secureRandom, KeyPair keyPair) throws SSH2FatalException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PublicKey publicKey = keyPair.getPublic();
        if (publicKey instanceof DSAPublicKey) {
            object5 = (DSAPublicKey)keyPair.getPublic();
            object4 = (DSAPrivateKey)keyPair.getPrivate();
            object3 = object5.getParams();
            object = object2 = new PEMDSAPrivate(0, object3.getP(), object3.getQ(), object3.getG(), object5.getY(), object4.getX());
            n = 0;
        } else if (publicKey instanceof RSAPublicKey) {
            object5 = (RSAPublicKey)keyPair.getPublic();
            object4 = (RSAPrivateCrtKey)keyPair.getPrivate();
            object = object3 = new RSAPrivateKey(0, object5.getModulus(), object5.getPublicExponent(), object4.getPrivateExponent(), object4.getPrimeP(), object4.getPrimeQ(), object4.getCrtCoefficient());
            n = 1;
        } else {
            throw new SSH2FatalException("Unsupported key type: " + publicKey);
        }
        aSCIIArmour.setHeaderLine(BEGIN_PRV_KEY[n]);
        aSCIIArmour.setTailLine(END_PRV_KEY[n]);
        object5 = new ByteArrayOutputStream(128);
        object4 = new ASN1DER();
        try {
            ((ASN1DER)object4).encode((OutputStream)object5, (ASN1Object)object);
        }
        catch (IOException iOException) {
            throw new SSH2FatalException("Error while DER encoding");
        }
        object3 = ((ByteArrayOutputStream)object5).toByteArray();
        if (string != null && string.length() > 0) {
            byte[] byArray;
            int n2;
            object2 = new byte[8];
            secureRandom.setSeed((byte[])object3);
            for (n2 = 0; n2 < 8; ++n2) {
                byArray = new byte[1];
                do {
                    secureRandom.nextBytes(byArray);
                    object2[n2] = byArray[0];
                } while (object2[n2] == false);
            }
            byte[] byArray2 = SSH2KeyPairFile.expandPasswordToKey(string, 24, (byte[])object2);
            aSCIIArmour.setHeaderField(PRV_PROCTYPE, "4,ENCRYPTED");
            aSCIIArmour.setHeaderField(PRV_DEKINFO, "DES-EDE3-CBC," + HexDump.toString((byte[])object2).toUpperCase());
            n2 = 8 - ((Object)object3).length % 8 + ((Object)object3).length;
            byArray = new byte[n2];
            SSH2KeyPairFile.doCipher(2, string, (byte[])object3, ((Object)object3).length, byArray, (byte[])object2);
            object3 = byArray;
        }
        return object3;
    }

    public static byte[] writeKeyPairSSHCom(String string, String string2, KeyPair keyPair) throws SSH2FatalException {
        Object object;
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(8192);
        int n = 0;
        DSAPublicKey dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)keyPair.getPrivate();
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (!(dSAPublicKey instanceof DSAPublicKey)) {
            throw new SSH2FatalException("Unsupported key type: " + dSAPublicKey);
        }
        sSH2DataBuffer.writeInt(0);
        sSH2DataBuffer.writeInt(0);
        sSH2DataBuffer.writeBigIntBits(dSAParams.getP());
        sSH2DataBuffer.writeBigIntBits(dSAParams.getG());
        sSH2DataBuffer.writeBigIntBits(dSAParams.getQ());
        sSH2DataBuffer.writeBigIntBits(dSAPublicKey.getY());
        sSH2DataBuffer.writeBigIntBits(dSAPrivateKey.getX());
        n = sSH2DataBuffer.getWPos();
        sSH2DataBuffer.setWPos(0);
        sSH2DataBuffer.writeInt(n - 4);
        if (!string2.equals("none")) {
            try {
                int n2 = SSH2Preferences.getCipherKeyLen(string2);
                object = SSH2Preferences.ssh2ToJCECipher(string2);
                byte[] byArray = SSH2KeyPairFile.expandPasswordToKeySSHCom(string, n2);
                Cipher cipher = Cipher.getInstance((String)object);
                cipher.init(2, new SecretKeySpec(byArray, cipher.getAlgorithm()));
                byte[] byArray2 = sSH2DataBuffer.getData();
                int n3 = cipher.getBlockSize();
                n += (n3 - n % n3) % n3;
                n = cipher.doFinal(byArray2, 0, n, byArray2, 0);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSH2FatalException("Invalid cipher in SSH2KeyPairFile.writeKeyPair: " + string2);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SSH2FatalException("Invalid key derived in SSH2KeyPairFile.writeKeyPair: " + invalidKeyException);
            }
        }
        SSH2DataBuffer sSH2DataBuffer2 = new SSH2DataBuffer(512 + n);
        sSH2DataBuffer2.writeInt(1064303083);
        sSH2DataBuffer2.writeInt(0);
        sSH2DataBuffer2.writeString("dl-modp{sign{dsa-nist-sha1},dh{plain}}");
        sSH2DataBuffer2.writeString(string2);
        sSH2DataBuffer2.writeString(sSH2DataBuffer.getData(), 0, n);
        n = sSH2DataBuffer2.getWPos();
        sSH2DataBuffer2.setWPos(4);
        sSH2DataBuffer2.writeInt(n);
        object = new byte[n];
        System.arraycopy(sSH2DataBuffer2.data, 0, object, 0, n);
        return object;
    }

    public static KeyPair readKeyPair(ASCIIArmour aSCIIArmour, byte[] byArray, String string) throws SSH2Exception {
        Object object;
        String string2;
        Object object2;
        Object object3;
        block12: {
            Object object4;
            Object object5;
            String string3 = aSCIIArmour.getHeaderField(PRV_PROCTYPE);
            if (string3 != null && string != null) {
                object5 = aSCIIArmour.getHeaderField(PRV_DEKINFO);
                if (object5 == null || !((String)object5).startsWith("DES-EDE3-CBC,")) {
                    throw new SSH2FatalException("Proc type not supported: " + string3);
                }
                object4 = new BigInteger((String)(object5 = ((String)object5).substring(13)), 16);
                object3 = ((BigInteger)object4).toByteArray();
                if (((byte[])object3).length > 8) {
                    object2 = object3;
                    object3 = new byte[8];
                    System.arraycopy(object2, 1, object3, 0, 8);
                }
                SSH2KeyPairFile.doCipher(1, string, byArray, byArray.length, byArray, object3);
            }
            object5 = new ByteArrayInputStream(byArray);
            object4 = new ASN1DER();
            object3 = null;
            object2 = null;
            string2 = null;
            String string4 = aSCIIArmour.getHeaderLine();
            if (string4.indexOf("DSA") != -1) {
                string2 = "DSA";
            } else if (string4.indexOf("RSA") != -1) {
                string2 = "RSA";
            }
            try {
                if ("DSA".equals(string2)) {
                    object = new PEMDSAPrivate();
                    ((ASN1DER)object4).decode((InputStream)object5, (ASN1Object)object);
                    BigInteger bigInteger = ((PEMDSAPrivate)object).p.getValue();
                    BigInteger bigInteger2 = ((PEMDSAPrivate)object).q.getValue();
                    BigInteger bigInteger3 = ((PEMDSAPrivate)object).g.getValue();
                    BigInteger bigInteger4 = ((PEMDSAPrivate)object).y.getValue();
                    BigInteger bigInteger5 = ((PEMDSAPrivate)object).x.getValue();
                    object3 = new DSAPrivateKeySpec(bigInteger5, bigInteger, bigInteger2, bigInteger3);
                    object2 = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
                    break block12;
                }
                if ("RSA".equals(string2)) {
                    object = new RSAPrivateKey();
                    ((ASN1DER)object4).decode((InputStream)object5, (ASN1Object)object);
                    BigInteger bigInteger = ((RSAPrivateKey)object).modulus.getValue();
                    BigInteger bigInteger6 = ((RSAPrivateKey)object).publicExponent.getValue();
                    BigInteger bigInteger7 = ((RSAPrivateKey)object).privateExponent.getValue();
                    BigInteger bigInteger8 = ((RSAPrivateKey)object).prime1.getValue();
                    BigInteger bigInteger9 = ((RSAPrivateKey)object).prime2.getValue();
                    BigInteger bigInteger10 = ((RSAPrivateKey)object).exponent1.getValue();
                    BigInteger bigInteger11 = ((RSAPrivateKey)object).exponent2.getValue();
                    BigInteger bigInteger12 = ((RSAPrivateKey)object).coefficient.getValue();
                    object3 = new RSAPrivateCrtKeySpec(bigInteger, bigInteger6, bigInteger7, bigInteger8, bigInteger9, bigInteger10, bigInteger11, bigInteger12);
                    object2 = new RSAPublicKeySpec(bigInteger, bigInteger6);
                    break block12;
                }
                throw new SSH2FatalException("Unsupported key type: " + string2);
            }
            catch (IOException iOException) {
                throw new SSH2AccessDeniedException("Invalid password or corrupt key blob");
            }
        }
        try {
            object = KeyFactory.getInstance(string2);
            return new KeyPair(((KeyFactory)object).generatePublic((KeySpec)object2), ((KeyFactory)object).generatePrivate((KeySpec)object3));
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Error in readKeyPair: " + exception);
        }
    }

    public static KeyPair readKeyPairSSHCom(byte[] byArray, String string) throws SSH2Exception {
        Object object;
        Object object2;
        Object object3;
        int n;
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(byArray.length);
        sSH2DataBuffer.writeRaw(byArray);
        int n2 = sSH2DataBuffer.readInt();
        int n3 = sSH2DataBuffer.readInt();
        String string2 = sSH2DataBuffer.readJavaString();
        String string3 = sSH2DataBuffer.readJavaString();
        int n4 = sSH2DataBuffer.readInt();
        if (string2.indexOf("dl-modp") == -1) {
            throw new SSH2FatalException("Unknown key type '" + string2 + "'");
        }
        if (n2 != 1064303083) {
            throw new SSH2FatalException("Invalid magic in private key: " + n2);
        }
        if (!string3.equals("none")) {
            try {
                n = SSH2Preferences.getCipherKeyLen(string3);
                String string4 = SSH2Preferences.ssh2ToJCECipher(string3);
                object3 = SSH2KeyPairFile.expandPasswordToKeySSHCom(string, n);
                object2 = Cipher.getInstance(string4);
                ((Cipher)object2).init(1, new SecretKeySpec((byte[])object3, ((Cipher)object2).getAlgorithm()));
                object = sSH2DataBuffer.getData();
                int n5 = sSH2DataBuffer.getRPos();
                ((Cipher)object2).doFinal((byte[])object, n5, n4, (byte[])object, n5);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSH2FatalException("Invalid cipher in SSH2KeyPairFile.readKeyPairSSHCom: " + string3);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SSH2FatalException("Invalid key derived in SSH2KeyPairFile.readKeyPairSSHCom: " + invalidKeyException);
            }
        }
        if ((n = sSH2DataBuffer.readInt()) > sSH2DataBuffer.getMaxReadSize() || n < 0) {
            throw new SSH2AccessDeniedException("Invalid password or corrupt key blob");
        }
        int n6 = sSH2DataBuffer.readInt();
        if (n6 != 0) {
            throw new Error("Predefined DSA params not implemented (" + n6 + ") '" + sSH2DataBuffer.readJavaString() + "'");
        }
        object3 = sSH2DataBuffer.readBigIntBits();
        object = sSH2DataBuffer.readBigIntBits();
        object2 = sSH2DataBuffer.readBigIntBits();
        BigInteger bigInteger = sSH2DataBuffer.readBigIntBits();
        BigInteger bigInteger2 = sSH2DataBuffer.readBigIntBits();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return new KeyPair(keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger, (BigInteger)object3, (BigInteger)object2, (BigInteger)object)), keyFactory.generatePrivate(new DSAPrivateKeySpec(bigInteger2, (BigInteger)object3, (BigInteger)object2, (BigInteger)object)));
        }
        catch (Exception exception) {
            throw new SSH2FatalException("Error in SSH2KeyPairFile.readKeyPair: " + exception);
        }
    }

    public void store(String string, SecureRandom secureRandom, String string2) throws IOException, SSH2FatalException {
        this.store(string, secureRandom, string2, this.sshComFormat);
    }

    public void store(String string, SecureRandom secureRandom, String string2, boolean bl) throws IOException, SSH2FatalException {
        Object object;
        this.armour.setBlankHeaderSep(!bl);
        this.armour.setLineLength(bl ? 70 : 64);
        this.armour.setHeaderField(PRV_PROCTYPE, null);
        this.armour.setHeaderField(PRV_DEKINFO, null);
        this.armour.setHeaderField(FILE_SUBJECT, null);
        this.armour.setHeaderField(FILE_COMMENT, null);
        byte[] byArray = null;
        if (bl) {
            if (!(this.keyPair.getPublic() instanceof DSAPublicKey)) {
                throw new SSH2FatalException("Only DSA keys supported when saving in compatibility mode");
            }
            object = string2 != null && string2.length() > 0 ? "3des-cbc" : "none";
            this.armour.setHeaderLine(BEGIN_PRV_KEY[2]);
            this.armour.setTailLine(END_PRV_KEY[2]);
            this.comment = "\"" + this.comment + "\"";
            byArray = SSH2KeyPairFile.writeKeyPairSSHCom(string2, (String)object, this.keyPair);
        } else {
            byArray = SSH2KeyPairFile.writeKeyPair(this.armour, string2, secureRandom, this.keyPair);
        }
        this.armour.setHeaderField(FILE_SUBJECT, this.subject);
        this.armour.setHeaderField(FILE_COMMENT, this.comment);
        object = new FileOutputStream(string);
        this.armour.setCanonicalLineEnd(false);
        this.armour.encode((OutputStream)object, byArray);
        ((FileOutputStream)object).close();
    }

    public void load(String string, String string2) throws IOException, SSH2Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream);
        int n = pushbackInputStream.read();
        if (n != 45) {
            throw new SSH2FatalException("Corrupt or unsupported key file: " + string);
        }
        pushbackInputStream.unread(n);
        this.armour = new ASCIIArmour("----");
        byte[] byArray = this.armour.decode(pushbackInputStream);
        pushbackInputStream.close();
        if (this.armour.getHeaderLine().indexOf("SSH2") != -1) {
            this.sshComFormat = true;
            this.keyPair = SSH2KeyPairFile.readKeyPairSSHCom(byArray, string2);
        } else {
            this.keyPair = SSH2KeyPairFile.readKeyPair(this.armour, byArray, string2);
        }
        this.subject = this.armour.getHeaderField(FILE_SUBJECT);
        this.comment = this.stripQuotes(this.armour.getHeaderField(FILE_COMMENT));
    }

    public static byte[] expandPasswordToKey(String string, int n, byte[] byArray) {
        try {
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n3 = messageDigest.getDigestLength();
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n];
            for (int i = 0; i < n; i += n2) {
                if (i > 0) {
                    messageDigest.update(byArray2);
                }
                messageDigest.update(string.getBytes());
                messageDigest.update(byArray);
                messageDigest.digest(byArray2, 0, n3);
                n2 = n3 > n - i ? n - i : n3;
                System.arraycopy(byArray2, 0, byArray3, i, n2);
            }
            return byArray3;
        }
        catch (Exception exception) {
            throw new Error("Error in SSH2KeyPairFile.expandPasswordToKey: " + exception);
        }
    }

    public static byte[] expandPasswordToKeySSHCom(String string, int n) {
        try {
            if (string == null) {
                string = "";
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n2 = messageDigest.getDigestLength();
            byte[] byArray = new byte[(n + n2) / n2 * n2];
            for (int i = 0; i < n; i += n2) {
                messageDigest.update(string.getBytes());
                if (i > 0) {
                    messageDigest.update(byArray, 0, i);
                }
                messageDigest.digest(byArray, i, n2);
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        catch (Exception exception) {
            throw new Error("Error in SSH2KeyPairFile.expandPasswordToKeySSHCom: " + exception);
        }
    }

    private static void doCipher(int n, String string, byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) throws SSH2FatalException {
        byte[] byArray4 = SSH2KeyPairFile.expandPasswordToKey(string, 24, byArray3);
        try {
            Cipher cipher = Cipher.getInstance("3DES/CBC/PKCS5Padding");
            cipher.init(n, new SecretKeySpec(byArray4, cipher.getAlgorithm()), new IvParameterSpec(byArray3));
            cipher.doFinal(byArray, 0, n2, byArray2, 0);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSH2FatalException("Invalid algorithm in SSH2KeyPairFile.doCipher: " + noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSH2FatalException("Invalid key derived in SSH2KeyPairFile.doCipher: " + invalidKeyException);
        }
    }

    private String stripQuotes(String string) throws SSH2FatalException {
        if (string != null && string.length() > 0 && string.charAt(0) == '\"') {
            if (string.charAt(string.length() - 1) != '\"') {
                throw new SSH2FatalException("Unbalanced quotes in key file comment");
            }
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static {
        ASN1OIDRegistry.addModule("com.mindbright.security.pkcs1");
    }

    public static final class PEMDSAPrivate
    extends ASN1Sequence {
        public ASN1Integer version = new ASN1Integer();
        public ASN1Integer p = new ASN1Integer();
        public ASN1Integer q = new ASN1Integer();
        public ASN1Integer g = new ASN1Integer();
        public ASN1Integer y = new ASN1Integer();
        public ASN1Integer x = new ASN1Integer();

        public PEMDSAPrivate() {
            this.addComponent(this.version);
            this.addComponent(this.p);
            this.addComponent(this.q);
            this.addComponent(this.g);
            this.addComponent(this.y);
            this.addComponent(this.x);
        }

        public PEMDSAPrivate(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
            this();
            this.version.setValue(n);
            this.p.setValue(bigInteger);
            this.q.setValue(bigInteger2);
            this.g.setValue(bigInteger3);
            this.y.setValue(bigInteger4);
            this.x.setValue(bigInteger5);
        }
    }
}

