/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.security.publickey.RSAPublicKey;
import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHCompressor;
import com.mindbright.ssh.SSHPduInputStream;
import com.mindbright.ssh.Version;
import com.mindbright.util.RandomSeed;
import com.mindbright.util.SecureRandomAndPad;
import java.io.IOException;

public abstract class SSH {
    public static boolean DEBUG = false;
    public static boolean DEBUGMORE = false;
    public static final int SSH_VER_MAJOR = 1;
    public static final int SSH_VER_MINOR = 5;
    public static final String VER_MINDTERM = "MindTerm_" + Version.version;
    public static final String VER_MINDTUNL = "MindTunnel_" + Version.version;
    public static final String CVS_NAME = "$Name: v3_0_1 $";
    public static final String CVS_DATE = "$Date: 2005/10/07 11:50:14 $";
    public static final int DEFAULTPORT = 22;
    public static final int SESSION_KEY_LENGTH = 256;
    public static final int SERVER_KEY_LENGTH = 768;
    public static final int HOST_KEY_LENGTH = 1024;
    public static final int PROTOFLAG_SCREEN_NUMBER = 1;
    public static final int PROTOFLAG_HOST_IN_FWD_OPEN = 2;
    public static final int MSG_ANY = -1;
    public static final int MSG_NONE = 0;
    public static final int MSG_DISCONNECT = 1;
    public static final int SMSG_PUBLIC_KEY = 2;
    public static final int CMSG_SESSION_KEY = 3;
    public static final int CMSG_USER = 4;
    public static final int CMSG_AUTH_RHOSTS = 5;
    public static final int CMSG_AUTH_RSA = 6;
    public static final int SMSG_AUTH_RSA_CHALLENGE = 7;
    public static final int CMSG_AUTH_RSA_RESPONSE = 8;
    public static final int CMSG_AUTH_PASSWORD = 9;
    public static final int CMSG_REQUEST_PTY = 10;
    public static final int CMSG_WINDOW_SIZE = 11;
    public static final int CMSG_EXEC_SHELL = 12;
    public static final int CMSG_EXEC_CMD = 13;
    public static final int SMSG_SUCCESS = 14;
    public static final int SMSG_FAILURE = 15;
    public static final int CMSG_STDIN_DATA = 16;
    public static final int SMSG_STDOUT_DATA = 17;
    public static final int SMSG_STDERR_DATA = 18;
    public static final int CMSG_EOF = 19;
    public static final int SMSG_EXITSTATUS = 20;
    public static final int MSG_CHANNEL_OPEN_CONFIRMATION = 21;
    public static final int MSG_CHANNEL_OPEN_FAILURE = 22;
    public static final int MSG_CHANNEL_DATA = 23;
    public static final int MSG_CHANNEL_CLOSE = 24;
    public static final int MSG_CHANNEL_CLOSE_CONFIRMATION = 25;
    public static final int MSG_CHANNEL_INPUT_EOF = 24;
    public static final int MSG_CHANNEL_OUTPUT_CLOSED = 25;
    public static final int SMSG_X11_OPEN = 27;
    public static final int CMSG_PORT_FORWARD_REQUEST = 28;
    public static final int MSG_PORT_OPEN = 29;
    public static final int CMSG_AGENT_REQUEST_FORWARDING = 30;
    public static final int SMSG_AGENT_OPEN = 31;
    public static final int MSG_IGNORE = 32;
    public static final int CMSG_EXIT_CONFIRMATION = 33;
    public static final int CMSG_X11_REQUEST_FORWARDING = 34;
    public static final int CMSG_AUTH_RHOSTS_RSA = 35;
    public static final int MSG_DEBUG = 36;
    public static final int CMSG_REQUEST_COMPRESSION = 37;
    public static final int CMSG_MAX_PACKET_SIZE = 38;
    public static final int CMSG_AUTH_TIS = 39;
    public static final int SMSG_AUTH_TIS_CHALLENGE = 40;
    public static final int CMSG_AUTH_TIS_RESPONSE = 41;
    public static final int CMSG_AUTH_SDI = 16;
    public static final int CMSG_ACM_OK = 64;
    public static final int CMSG_ACM_ACCESS_DENIED = 65;
    public static final int CMSG_ACM_NEXT_CODE_REQUIRED = 66;
    public static final int CMSG_ACM_NEXT_CODE = 67;
    public static final int CMSG_ACM_NEW_PIN_REQUIRED = 68;
    public static final int CMSG_ACM_NEW_PIN_ACCEPTED = 69;
    public static final int CMSG_ACM_NEW_PIN_REJECTED = 70;
    public static final int CMSG_ACM_NEW_PIN = 71;
    public static final int IDX_CIPHER_CLASS = 0;
    public static final int IDX_CIPHER_NAME = 1;
    public static final String[][] cipherClasses = new String[][]{{"SSHNoEncrypt", "none"}, {"SSHIDEA", "idea-cbc"}, {"SSHDES", "des-cbc"}, {"SSHDES3", "3des-cbc"}, {null, "tss"}, {null, "arcfour"}, {"SSHBlowfish", "blowfish-cbc"}, {null, "reserved"}};
    public static final int CIPHER_NONE = 0;
    public static final int CIPHER_IDEA = 1;
    public static final int CIPHER_DES = 2;
    public static final int CIPHER_3DES = 3;
    public static final int CIPHER_TSS = 4;
    public static final int CIPHER_RC4 = 5;
    public static final int CIPHER_BLOWFISH = 6;
    public static final int CIPHER_RESERVED = 7;
    public static final int CIPHER_NOTSUPPORTED = 8;
    public static final int CIPHER_DEFAULT = 6;
    public static final String[] authTypeDesc = new String[]{"_N/A_", "rhosts", "publickey", "password", "rhostsrsa", "tis", "kerberos", "kerbtgt", "securid", "cryptocard", "keyboard-interactive"};
    public static final int AUTH_RHOSTS = 1;
    public static final int AUTH_PUBLICKEY = 2;
    public static final int AUTH_PASSWORD = 3;
    public static final int AUTH_RHOSTS_RSA = 4;
    public static final int AUTH_TIS = 5;
    public static final int AUTH_KERBEROS = 6;
    public static final int PASS_KERBEROS_TGT = 7;
    public static final int AUTH_SDI = 8;
    public static final int AUTH_CRYPTOCARD = 9;
    public static final int AUTH_KBDINTERACT = 10;
    public static final int AUTH_NOTSUPPORTED = authTypeDesc.length;
    public static final int AUTH_DEFAULT = 3;
    static final String[] proxyTypes = new String[]{"none", "http", "socks4", "socks5", "socks5-local-dns"};
    static final int[] defaultProxyPorts = new int[]{0, 8080, 1080, 1080, 1080};
    public static final int PROXY_NONE = 0;
    public static final int PROXY_HTTP = 1;
    public static final int PROXY_SOCKS4 = 2;
    public static final int PROXY_SOCKS5_DNS = 3;
    public static final int PROXY_SOCKS5_IP = 4;
    public static final int PROXY_NOTSUPPORTED = proxyTypes.length;
    public static final int TTY_OP_END = 0;
    public static final int TTY_OP_ISPEED = 192;
    public static final int TTY_OP_OSPEED = 193;
    public static final int MAIN_CHAN_NUM = -1;
    public static final int CONNECT_CHAN_NUM = -2;
    public static final int LISTEN_CHAN_NUM = -3;
    public static final int UNKNOWN_CHAN_NUM = -4;
    public static final String KNOWN_HOSTS_FILE = "known_hosts";
    public static final int SRV_HOSTKEY_KNOWN = 0;
    public static final int SRV_HOSTKEY_NEW = 1;
    public static final int SRV_HOSTKEY_CHANGED = 2;
    public SecureRandomAndPad secureRandom;
    public RandomSeed randomSeed;
    protected byte[] sessionKey;
    protected byte[] sessionId;
    protected SSHCipher sndCipher;
    protected SSHCipher rcvCipher;
    protected SSHCompressor sndComp;
    protected SSHCompressor rcvComp;
    protected int cipherType;
    protected byte[] srvCookie;
    protected RSAPublicKey srvServerKey;
    protected RSAPublicKey srvHostKey;
    protected int protocolFlags;
    protected int supportedCiphers;
    protected int supportedAuthTypes;
    protected boolean isAnSSHClient = true;

    public String getVersionId(boolean bl) {
        String string = "SSH-1.5-";
        string = string + (bl ? VER_MINDTERM : VER_MINDTUNL);
        return string;
    }

    public static String[] getProxyTypes() {
        return new String[]{"none", "http", "socks4", "socks5"};
    }

    public static int getProxyType(String string) throws IllegalArgumentException {
        int n;
        if ("socks5-proxy-dns".equals(string)) {
            string = "socks5";
        }
        for (n = 0; n < proxyTypes.length && !proxyTypes[n].equalsIgnoreCase(string); ++n) {
        }
        if (n == PROXY_NOTSUPPORTED) {
            throw new IllegalArgumentException("Proxytype " + string + " not supported");
        }
        return n;
    }

    public static String getCipherName(int n) {
        return cipherClasses[n][1];
    }

    public static int getCipherType(String string) {
        int n;
        if ("blowfish".equals(string)) {
            string = "blowfish-cbc";
        } else if ("rc4".equals(string)) {
            string = "arcfour";
        } else if ("des".equals(string)) {
            string = "des-cbc";
        } else if ("3des".equals(string)) {
            string = "3des-cbc";
        } else if ("idea".equals(string)) {
            string = "idea-cbc";
        }
        for (n = 0; n < cipherClasses.length; ++n) {
            String string2 = cipherClasses[n][1];
            if (!string2.equalsIgnoreCase(string)) continue;
            if (cipherClasses[n][0] != null) break;
            n = cipherClasses.length;
            break;
        }
        return n;
    }

    public static String getAuthName(int n) {
        return authTypeDesc[n];
    }

    public static String getAltAuthName(int n) {
        if (n == 5 || n == 8 || n == 9) {
            return "keyboard-interactive";
        }
        return SSH.getAuthName(n);
    }

    public static int getAuthType(String string) throws IllegalArgumentException {
        int n;
        if ("sdi-token".equals(string) || "secureid".equals(string)) {
            string = "securid";
        } else if ("kbd-interact".equals(string)) {
            string = "keyboard-interactive";
        } else if ("rsa".equals(string)) {
            string = "publickey";
        } else if ("passwd".equals(string)) {
            string = "password";
        }
        for (n = 1; n < authTypeDesc.length && !authTypeDesc[n].equalsIgnoreCase(string); ++n) {
        }
        if (n == AUTH_NOTSUPPORTED) {
            throw new IllegalArgumentException("Authtype " + string + " not supported");
        }
        return n;
    }

    static int cntListSize(String string) {
        int n;
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length() && (n = string.indexOf(44, n3)) != -1) {
            n3 = n + 1;
            ++n2;
        }
        return n2;
    }

    public static int[] getAuthTypes(String string) throws IllegalArgumentException {
        int n = SSH.cntListSize(string);
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.indexOf(44, n2);
            if (n3 == -1) {
                n3 = string.length();
            }
            String string2 = string.substring(n2, n3).trim();
            nArray[i] = SSH.getAuthType(string2);
            n2 = n3 + 1;
        }
        return nArray;
    }

    protected boolean isCipherSupported(int n) {
        int n2 = 1 << n;
        return (n2 & this.supportedCiphers) != 0;
    }

    protected boolean isAuthTypeSupported(int n) {
        int n2 = 1 << n;
        return (n2 & this.supportedAuthTypes) != 0;
    }

    protected boolean isProtocolFlagSet(int n) {
        int n2 = 1 << n;
        return (n2 & this.protocolFlags) != 0;
    }

    public boolean haveSecureRandom() {
        return this.secureRandom != null;
    }

    public synchronized RandomSeed randomSeed() {
        if (this.randomSeed == null) {
            this.randomSeed = new RandomSeed("/dev/random", "/dev/urandom");
        }
        return this.randomSeed;
    }

    public void initSeedGenerator() {
        RandomSeed randomSeed = this.randomSeed();
        if (this.secureRandom == null) {
            byte[] byArray = randomSeed.getBytesBlocking(20, false);
            this.secureRandom = new SecureRandomAndPad(new SecureRandom(byArray));
        } else {
            int n = randomSeed.getAvailableBits() / 8;
            if (n > 0) {
                this.secureRandom.setSeed(randomSeed.getBytesBlocking(n > 20 ? 20 : n));
            }
        }
        this.secureRandom.setPadSeed(randomSeed.getBytes(20));
    }

    public synchronized SecureRandomAndPad secureRandom() {
        this.initSeedGenerator();
        return this.secureRandom;
    }

    public static void log(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void logExtra(String string) {
        if (DEBUGMORE) {
            System.out.println(string);
        }
    }

    public static void logDebug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void logIgnore(SSHPduInputStream sSHPduInputStream) {
        if (DEBUG) {
            System.out.println("MSG_IGNORE received...(len = " + sSHPduInputStream.length + ")");
        }
    }

    void generateSessionId() throws IOException {
        byte[] byArray = this.srvServerKey.getModulus().toByteArray();
        byte[] byArray2 = this.srvHostKey.getModulus().toByteArray();
        int n = byArray.length + byArray2.length + this.srvCookie.length;
        if (byArray[0] == 0) {
            --n;
        }
        if (byArray2[0] == 0) {
            --n;
        }
        byte[] byArray3 = new byte[n];
        if (byArray2[0] == 0) {
            System.arraycopy(byArray2, 1, byArray3, 0, byArray2.length - 1);
            n = byArray2.length - 1;
        } else {
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            n = byArray2.length;
        }
        if (byArray[0] == 0) {
            System.arraycopy(byArray, 1, byArray3, n, byArray.length - 1);
            n += byArray.length - 1;
        } else {
            System.arraycopy(byArray, 0, byArray3, n, byArray.length);
            n += byArray.length;
        }
        System.arraycopy(this.srvCookie, 0, byArray3, n, this.srvCookie.length);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray3);
            this.sessionId = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IOException("MD5 not implemented, can't generate session-id");
        }
    }

    protected void initClientCipher() throws IOException {
        this.initCipher(false);
    }

    protected void initServerCipher() throws IOException {
        this.initCipher(true);
    }

    protected void initCipher(boolean bl) throws IOException {
        this.sndCipher = SSHCipher.getInstance(cipherClasses[this.cipherType][0]);
        this.rcvCipher = SSHCipher.getInstance(cipherClasses[this.cipherType][0]);
        if (this.sndCipher == null) {
            throw new IOException("SSHCipher " + cipherClasses[this.cipherType][1] + " not found, can't use it");
        }
        this.sndCipher.setKey(this.sessionKey);
        this.rcvCipher.setKey(this.sessionKey);
    }
}

