/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.security.digest.MD512BitBlock;

public final class SHA1
extends MD512BitBlock {
    public static final int DIGEST_LENGTH = 20;
    private int[] hash = new int[5];
    private int[] W = new int[80];

    private static int F00_19(int n, int n2, int n3, int n4, int n5, int n6) {
        n = n << 5 | n >>> 27;
        return n + ((n3 ^ n4) & n2 ^ n4) + 1518500249 + n5 + n6;
    }

    private static int F20_39(int n, int n2, int n3, int n4, int n5, int n6) {
        n = n << 5 | n >>> 27;
        return n + (n2 ^ n3 ^ n4) + 1859775393 + n5 + n6;
    }

    private static int F40_59(int n, int n2, int n3, int n4, int n5, int n6) {
        n = n << 5 | n >>> 27;
        return n + (n2 & n3 | (n2 | n3) & n4) + -1894007588 + n5 + n6;
    }

    private static int F60_79(int n, int n2, int n3, int n4, int n5, int n6) {
        n = n << 5 | n >>> 27;
        return n + (n2 ^ n3 ^ n4) + -899497514 + n5 + n6;
    }

    protected void transform(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4 = this.hash[0];
        int n5 = this.hash[1];
        int n6 = this.hash[2];
        int n7 = this.hash[3];
        int n8 = this.hash[4];
        for (n3 = 0; n3 < 16; ++n3) {
            this.W[n3] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        }
        for (n3 = 16; n3 < 80; ++n3) {
            n2 = this.W[n3 - 3] ^ this.W[n3 - 8] ^ this.W[n3 - 14] ^ this.W[n3 - 16];
            this.W[n3] = n2 << 1 | n2 >>> 31;
        }
        for (n3 = 0; n3 < 20; ++n3) {
            n2 = SHA1.F00_19(n4, n5, n6, n7, n8, this.W[n3]);
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        for (n3 = 20; n3 < 40; ++n3) {
            n2 = SHA1.F20_39(n4, n5, n6, n7, n8, this.W[n3]);
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        for (n3 = 40; n3 < 60; ++n3) {
            n2 = SHA1.F40_59(n4, n5, n6, n7, n8, this.W[n3]);
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        for (n3 = 60; n3 < 80; ++n3) {
            n2 = SHA1.F60_79(n4, n5, n6, n7, n8, this.W[n3]);
            n8 = n7;
            n7 = n6;
            n6 = n5 << 30 | n5 >>> 2;
            n5 = n4;
            n4 = n2;
        }
        this.hash[0] = this.hash[0] + n4;
        this.hash[1] = this.hash[1] + n5;
        this.hash[2] = this.hash[2] + n6;
        this.hash[3] = this.hash[3] + n7;
        this.hash[4] = this.hash[4] + n8;
    }

    public SHA1() {
        super("SHA1", 20);
    }

    protected MD512BitBlock cloneInternal() {
        SHA1 sHA1 = new SHA1();
        sHA1.hash[0] = this.hash[0];
        sHA1.hash[1] = this.hash[1];
        sHA1.hash[2] = this.hash[2];
        sHA1.hash[3] = this.hash[3];
        sHA1.hash[4] = this.hash[4];
        return sHA1;
    }

    protected void engineReset() {
        this.hash[0] = 1732584193;
        this.hash[1] = -271733879;
        this.hash[2] = -1732584194;
        this.hash[3] = 271733878;
        this.hash[4] = -1009589776;
        this.count = 0L;
        this.rest = 0;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        int n3;
        int n4 = n3 = this.rest < 56 ? 56 - this.rest : 120 - this.rest;
        if (n2 < 20) {
            throw new DigestException("SHA1, output buffer too short");
        }
        this.count *= 8L;
        byte[] byArray2 = new byte[]{(byte)(this.count >>> 56), (byte)(this.count >>> 58), (byte)(this.count >>> 40), (byte)(this.count >>> 32), (byte)(this.count >>> 24), (byte)(this.count >>> 16), (byte)(this.count >>> 8), (byte)this.count};
        this.engineUpdate(MD512BitBlock.md4_padding, 0, n3);
        this.engineUpdate(byArray2, 0, 8);
        for (int i = 0; i < 5; ++i) {
            int n5 = this.hash[i];
            byArray[n++] = (byte)(n5 >>> 24 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 16 & 0xFF);
            byArray[n++] = (byte)(n5 >>> 8 & 0xFF);
            byArray[n++] = (byte)(n5 & 0xFF);
        }
        this.engineReset();
        return 20;
    }
}

